const dceSignaturePads=new WeakMap();function resizeCanvas(wrapper){const obj=dceSignaturePads.get(wrapper);if(!obj)return;let{canvas,signaturePad,hiddenInput,aspectRatio,useJPEG}=obj;let rect=wrapper.getBoundingClientRect();if(rect.width===0||rect.height===0){return}
const oldData=signaturePad.toData();const oldWidth=canvas.width;const oldHeight=canvas.height;let newWidth=Math.round(rect.width);let newHeight=Math.round(newWidth/aspectRatio);if(newWidth===oldWidth){return}
canvas.width=newWidth;canvas.height=newHeight;if(obj.updateValue){signaturePad.removeEventListener("afterUpdateStroke",obj.updateValue)}
signaturePad.off();signaturePad=new SignaturePad(canvas,{penColor:canvas.getAttribute("data-pen-color"),backgroundColor:canvas.getAttribute("data-background-color"),});obj.signaturePad=signaturePad;if(oldWidth>0&&oldHeight>0){const scaleX=newWidth/oldWidth;const scaleY=newHeight/oldHeight;oldData.forEach((stroke)=>{stroke.points.forEach((point)=>{point.x*=scaleX;point.y*=scaleY;point.pressure*=scaleX})});signaturePad.fromData(oldData)}
const updateValue=()=>{if(!signaturePad.isEmpty()){hiddenInput.value=signaturePad.toDataURL(`image/${useJPEG ? 'jpeg' : 'png'}`)}else{hiddenInput.value=""}};signaturePad.addEventListener("afterUpdateStroke",updateValue);obj.updateValue=updateValue}
function initializeSignaturePad(wrapper,$scope,$){const previous=dceSignaturePads.get(wrapper);if(previous){if(previous.updateValue){previous.signaturePad.removeEventListener("afterUpdateStroke",previous.updateValue)}
previous.signaturePad.off();if(previous.clearButton&&previous.clearHandler){previous.clearButton.removeEventListener("click",previous.clearHandler)}
if(previous.resizeObserver){previous.resizeObserver.disconnect()}}
const canvas=wrapper.querySelector("canvas");const hiddenInput=wrapper.querySelector("input");const clearButton=wrapper.querySelector("[data-action=clear]");const aspectRatio=parseFloat(canvas.getAttribute("data-aspect-ratio"))||2;const useJPEG=canvas.getAttribute("data-jpeg")==="yes";let rect=wrapper.getBoundingClientRect();let actualWidth=Math.round(rect.width);let actualHeight=Math.round(actualWidth/aspectRatio);canvas.width=actualWidth;canvas.height=actualHeight;let signaturePad=new SignaturePad(canvas,{penColor:canvas.getAttribute("data-pen-color"),backgroundColor:canvas.getAttribute("data-background-color"),});const updateValue=()=>{if(!signaturePad.isEmpty()){hiddenInput.value=signaturePad.toDataURL(`image/${useJPEG ? 'jpeg' : 'png'}`)}else{hiddenInput.value=""}};signaturePad.addEventListener("afterUpdateStroke",updateValue);const clearHandler=function(){const context=canvas.getContext("2d");context.fillStyle=canvas.getAttribute("data-background-color");context.fillRect(0,0,canvas.width,canvas.height);signaturePad.clear();hiddenInput.value=""};clearButton.addEventListener("click",clearHandler);const resizeObserver=new ResizeObserver((entries)=>{window.requestAnimationFrame(()=>{resizeCanvas(wrapper)})});resizeObserver.observe(wrapper);const padData={wrapper,canvas,signaturePad,hiddenInput,aspectRatio,useJPEG,updateValue,clearButton,clearHandler,resizeObserver};dceSignaturePads.set(wrapper,padData)}
function WidgetElements_FormSignature($scope,$){let wrappers=$scope.find(".dce-signature-wrapper");wrappers.each((_,wrapper)=>initializeSignaturePad(wrapper,$scope,$))}
jQuery(window).on("elementor/frontend/init",function(){elementorFrontend.hooks.addAction("frontend/element_ready/form.default",WidgetElements_FormSignature)})