<?php

/**
 * Created by PhpStorm.
 * User: iGusev
 * Date: 18/04/16
 * Time: 04:00
 */
namespace DynamicOOOS\TelegramBot\Api\Types\Inline\QueryResult;

use DynamicOOOS\TelegramBot\Api\Types\Inline\InlineKeyboardMarkup;
use DynamicOOOS\TelegramBot\Api\Types\Inline\InputMessageContent;
/**
 * Class Location
 *
 * @see https://core.telegram.org/bots/api#inlinequeryresultlocation
 * Represents a location on a map. By default, the location will be sent by the user.
 * Alternatively, you can use InputMessageContent to send a message with the specified content instead of the location.
 *
 * Note: This will only work in Telegram versions released after 9 April, 2016. Older clients will ignore them.
 *
 * @package TelegramBot\Api\Types\Inline\QueryResult
 */
class Location extends AbstractInlineQueryResult
{
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $requiredParams = ['type', 'id', 'latitude', 'longitude', 'title'];
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $map = ['type' => \true, 'id' => \true, 'latitude' => \true, 'longitude' => \true, 'title' => \true, 'thumbnail_url' => \true, 'thumbnail_width' => \true, 'thumbnail_height' => \true, 'reply_markup' => InlineKeyboardMarkup::class, 'input_message_content' => InputMessageContent::class];
    /**
     * {@inheritdoc}
     *
     * @var string
     */
    protected $type = 'location';
    /**
     * Location latitude in degrees
     *
     * @var float
     */
    protected $latitude;
    /**
     * Location longitude in degrees
     *
     * @var float
     */
    protected $longitude;
    /**
     * Optional. Url of the thumbnail for the result
     *
     * @var string|null
     */
    protected $thumbnailUrl;
    /**
     * Optional. Thumbnail width
     *
     * @var int|null
     */
    protected $thumbnailWidth;
    /**
     * Optional. Thumbnail height
     *
     * @var int|null
     */
    protected $thumbnailHeight;
    /**
     * Voice constructor
     *
     * @param string $id
     * @param float $latitude
     * @param float $longitude
     * @param string $title
     * @param string|null $thumbnailUrl
     * @param int|null $thumbnailWidth
     * @param int|null $thumbnailHeight
     * @param InlineKeyboardMarkup|null $inlineKeyboardMarkup
     * @param InputMessageContent|null $inputMessageContent
     */
    public function __construct($id, $latitude, $longitude, $title, $thumbnailUrl = null, $thumbnailWidth = null, $thumbnailHeight = null, $inlineKeyboardMarkup = null, $inputMessageContent = null)
    {
        parent::__construct($id, $title, $inputMessageContent, $inlineKeyboardMarkup);
        $this->latitude = $latitude;
        $this->longitude = $longitude;
        $this->thumbnailUrl = $thumbnailUrl;
        $this->thumbnailWidth = $thumbnailWidth;
        $this->thumbnailHeight = $thumbnailHeight;
    }
    /**
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * @param float $latitude
     *
     * @return void
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }
    /**
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * @param float $longitude
     *
     * @return void
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }
    /**
     * @return string|null
     */
    public function getThumbnailUrl()
    {
        return $this->thumbnailUrl;
    }
    /**
     * @param string|null $thumbnailUrl
     *
     * @return void
     */
    public function setThumbnailUrl($thumbnailUrl)
    {
        $this->thumbnailUrl = $thumbnailUrl;
    }
    /**
     * @deprecated Use getThumbnailUrl
     *
     * @return string|null
     */
    public function getThumbUrl()
    {
        return $this->getThumbnailUrl();
    }
    /**
     * @deprecated Use setThumbnailUrl
     *
     * @param string|null $thumbUrl
     *
     * @return void
     */
    public function setThumbUrl($thumbUrl)
    {
        $this->setThumbnailUrl($thumbUrl);
    }
    /**
     * @return int|null
     */
    public function getThumbnailWidth()
    {
        return $this->thumbnailWidth;
    }
    /**
     * @param int|null $thumbnailWidth
     *
     * @return void
     */
    public function setThumbnailWidth($thumbnailWidth)
    {
        $this->thumbnailWidth = $thumbnailWidth;
    }
    /**
     * @deprecated Use getThumbnailWidth
     *
     * @return int|null
     */
    public function getThumbWidth()
    {
        return $this->getThumbnailWidth();
    }
    /**
     * @deprecated Use setThumbnailWidth
     *
     * @param int|null $thumbWidth
     *
     * @return void
     */
    public function setThumbWidth($thumbWidth)
    {
        $this->setThumbnailWidth($thumbWidth);
    }
    /**
     * @return int|null
     */
    public function getThumbnailHeight()
    {
        return $this->thumbnailHeight;
    }
    /**
     * @param int|null $thumbnailHeight
     *
     * @return void
     */
    public function setThumbnailHeight($thumbnailHeight)
    {
        $this->thumbnailHeight = $thumbnailHeight;
    }
    /**
     * @deprecated Use getThumbnailHeight
     *
     * @return int|null
     */
    public function getThumbHeight()
    {
        return $this->getThumbnailHeight();
    }
    /**
     * @deprecated Use setThumbnailWidth
     *
     * @param int|null $thumbHeight
     *
     * @return void
     */
    public function setThumbHeight($thumbHeight)
    {
        $this->setThumbnailHeight($thumbHeight);
    }
}
