<?php
/**
 * Glozin Addons Modules functions and definitions.
 *
 * @package Glozin
 */

namespace Glozin\Addons\Modules\Variation_Images;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Addons Modules
 */
class Module {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Instantiate the object.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function __construct() {
		$this->includes();
		$this->actions();
		add_action('admin_init', array( $this, 'settings'));
	}

	/**
	 * Includes files
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	private function includes() {
		\Glozin\Addons\Auto_Loader::register( [
			'Glozin\Addons\Modules\Variation_Images\Frontend'        => GLOZIN_ADDONS_DIR . 'modules/variation-images/frontend.php',
			'Glozin\Addons\Modules\Variation_Images\Settings'    	=> GLOZIN_ADDONS_DIR . 'modules/variation-images/settings.php',
			'Glozin\Addons\Modules\Variation_Images\Product_Options' => GLOZIN_ADDONS_DIR . 'modules/variation-images/product-options.php',
		] );
	}

	/**
	 * Settings
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function settings() {
		if ( is_admin() ) {
			\Glozin\Addons\Modules\Variation_Images\Settings::instance();

			if ( get_option( 'glozin_variation_images' ) == 'yes' ) {
				\Glozin\Addons\Modules\Variation_Images\Product_Options::instance();
			}
		}
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function actions() {
		if ( get_option( 'glozin_variation_images' ) == 'yes' ) {
			\Glozin\Addons\Modules\Variation_Images\Frontend::instance();
		}
	}
}
