<?php
/**
 * Containing dynamic css button style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$buttons_keys = array(
	'theme_button_text_color',
	'theme_button_bg_color',
	'theme_button_hover_text_color',
	'theme_button_hover_bg_color',
	'inspiry_back_to_top_bg_color',
	'inspiry_back_to_top_bg_hover_color',
	'inspiry_back_to_top_color'
);

$buttons_options = realhomes_get_options( $buttons_keys );

$buttons_css = array(
	'elements' => '
		.page-main .post-content .real-btn,
		.single-post-main .post-content .real-btn,
		.posts-main .post-footer .real-btn,
		.real-btn
	',
	'property' => 'color',
	'value'    => $buttons_options[ 'theme_button_text_color' ]
);

$buttons_css = array(
	'elements' => '.posts-main .post-footer .real-btn, .real-btn',
	'property' => 'background-color',
	'value'    => $buttons_options[ 'theme_button_bg_color' ]
);

$buttons_css = array(
	'elements' => '
		.page-main .post-content .real-btn:hover,
		.posts-main .post-footer .real-btn:hover,
		.single-post-main .post-content .real-btn:hover,
		.real-btn:hover,
		.real-btn.current
	',
	'property' => 'color',
	'value'    => $buttons_options[ 'theme_button_hover_text_color' ]
);

$buttons_css = array(
	'elements' => '
		.posts-main .post-footer .real-btn:hover,
		.real-btn:hover, .real-btn.current
	',
	'property' => 'background-color',
	'value'    => $buttons_options[ 'theme_button_hover_bg_color' ]
);

$buttons_css = array(
	'elements' => '#scroll-top',
	'property' => 'background-color',
	'value'    => $buttons_options[ 'inspiry_back_to_top_bg_color' ]
);

$buttons_css = array(
	'elements' => '#scroll-top:hover',
	'property' => 'background-color',
	'value'    => $buttons_options[ 'inspiry_back_to_top_bg_hover_color' ]
);

$buttons_css = array(
	'elements' => '#scroll-top',
	'property' => 'color',
	'value'    => $buttons_options[ 'inspiry_back_to_top_color' ]
);

return $buttons_css;