<?php
/**
 * Containing dynamic css core style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$core_keys = array(
	'theme_core_color_orange_light',
	'theme_core_color_orange_dark',
	'theme_core_color_orange_glow',
	'theme_core_color_orange_burnt',
	'theme_core_color_blue_light',
	'theme_core_color_blue_med',
	'theme_core_color_blue_dark',
	array( 'realhomes_selection_bg_color', '#ec894d' )
);

$core_options = realhomes_get_options( $core_keys );

$core_color_orange_light = $core_options['theme_core_color_orange_light'];
$core_color_orange_dark  = $core_options['theme_core_color_orange_dark'];
$core_color_orange_glow  = $core_options['theme_core_color_orange_glow'];
$core_color_orange_burnt = $core_options['theme_core_color_orange_burnt'];
$core_color_blue_light   = $core_options['theme_core_color_blue_light'];
$core_color_blue_med     = $core_options['theme_core_color_blue_med'];
$core_color_blue_dark    = $core_options['theme_core_color_blue_dark'];
$selection_bg_color      = $core_options['realhomes_selection_bg_color'];

$core_css[] = array(
	'elements' => '.main-menu ul li.current-menu-ancestor > a,
		.main-menu ul li.current-menu-parent > a,
		.main-menu ul li.current-menu-item > a,
		.main-menu ul li.current_page_item > a,
		.main-menu ul li:hover > a,
		.main-menu ul li ul,
		.main-menu ul li ul li ul,
		.property-item figure figcaption,
		.inner-wrapper .hentry .post-tags a,
		.real-btn,
		#filter-by a:focus,
		#filter-by a.active,
		#filter-by a:hover,
		#dsidx-listings li.dsidx-listing-container:hover .dsidx-primary-data,
		#dsidx-listings .dsidx-listing-container .dsidx-listing .dsidx-media .dsidx-photo .dsidx-photo-count,
		#dsidx .dsidx-small-button, body.dsidx .dsidx-small-button, #dsidx .dsidx-large-button, body.dsidx .dsidx-large-button,
		.ihf-map-icon,
		#ihf-main-container ul.pagination li:first-child a,
		#ihf-main-container ul.pagination li:first-child span,
		#ihf-main-container ul.pagination li:last-child a,
		#ihf-main-container ul.pagination li:last-child span,
		#ihf-main-container .ihf-widget .row button,
		#ihf-main-container .ihf-listing-search-results .btn-group .btn:not(.dropdown-toggle),
		#ihf-main-container .ihf-listing-search-results #saveSearchButton,
		.real-btn, .btn-blue, .btn-grey, input[type="submit"], 
		.sidebar .widget .dsidx-widget .submit,
		.rh_slide__container .rh_slide__details .rh_prop_details .rh_prop_details__buttons a,
		.rh_cfos .cfos_phone_icon,
		div.rh_login_modal_classic button,
		body .rh_floating_classic .rh_compare__submit,
		.post-content .qe-faqs-filters-container .qe-faqs-filter:hover,
		.post-content .qe-faqs-filters-container .active .qe-faqs-filter,
		.qe-faqs-filters-container .qe-faqs-filter:hover, 
		.qe-faqs-filters-container .active .qe-faqs-filter,
		body.design_classic .inspiry_stars_avg_rating .inspiry_rating_percentage .inspiry_rating_line .inspiry_rating_line_inner,
		.woocommerce a.added_to_cart:hover, .woocommerce #respond input#submit:hover, .woocommerce-page-wrapper .woocommerce a.button:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,
		.woocommerce span.onsale, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content
	',
	'property' => 'background-color',
	'value'    => $core_color_orange_light,
);

$core_css[] = array(
	'elements' => 'div.rh_modal_login_loader.rh_modal_login_classic svg path',
	'property' => 'fill',
	'value'    => $core_color_orange_light,
);

$core_css[] = array(
	'elements' => '.rh_cfos .cfos_phone_icon:after',
	'property' => 'border-left-color',
	'value'    => $core_color_orange_light,
);

$core_css[] = array(
	'elements' => '.rtl .rh_cfos .cfos_phone_icon:before',
	'property' => 'border-right-color',
	'value'    => $core_color_orange_light,
);

$core_css[] = array(
	'elements' => '#ihf-main-container .ihf-widget .row button,
		.rh_slide__container .rh_slide__details .rh_prop_details .rh_prop_details__buttons a,
		.rh_slide__container .rh_slide__details .rh_prop_details .rh_prop_details__buttons a:hover,
		#ihf-main-container .ihf-listing-search-results .btn-group .btn:not(.dropdown-toggle),
		div.rh_login_modal_classic .rh_login_tabs li.rh_active,
		div.rh_login_modal_classic .rh_login_tabs li:hover,
		.woocommerce a.added_to_cart:hover,
		.woocommerce #respond input#submit:hover,
		.woocommerce-page-wrapper .woocommerce a.button:hover,
		.woocommerce a.button:hover,
		.woocommerce button.button:hover,
		.woocommerce input.button:hover,
		.woocommerce #respond input#submit.alt:hover,
		.woocommerce a.button.alt:hover,
		.woocommerce button.button.alt:hover,
		.woocommerce input.button.alt:hover
	',
	'property' => 'border-color',
	'value'    => $core_color_orange_light,
);

$core_css[] = array(
	'elements' => '::selection',
	'property' => 'background-color',
	'value'    => $selection_bg_color,
);

$core_css[] = array(
	'elements' => '::-moz-selection',
	'property' => 'background-color',
	'value'    => $selection_bg_color,
);

$core_css[] = array(
	'elements' => '
		#filter-by a:focus,
		#filter-by a.active,
		#filter-by a:hover,
		#ihf-main-container ul.pagination li:first-child a,
		#ihf-main-container ul.pagination li:first-child span,
		#ihf-main-container ul.pagination li:last-child a,
		#ihf-main-container ul.pagination li:last-child span
    ',
	'property' => 'border-color',
	'value'    => $core_color_orange_light,
);

$core_css[] = array(
	'elements' => '
		.post-meta a,
		#comments a:hover,
		.yelp-wrap .yelp-places-group-title i,
		.gallery-item .item-title a:hover,
		.rh_slide__container .rh_slide__details .rh_prop_details .rh_prop_details__price .price,
		div.rh_login_modal_classic .rh_login_tabs li.rh_active,
		div.rh_login_modal_classic .rh_login_tabs li:hover,
		.rating-stars i.rated,
		.rating-stars i,
		body .br-theme-fontawesome-stars .br-widget a.br-selected:after,
		body .br-theme-fontawesome-stars .br-widget a.br-active:after,
		.woocommerce ul.products li.product .price, .woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce ul.cart_list li .amount, .woocommerce ul.product_list_widget li .amount
    ',
	'property' => 'color',
	'value'    => $core_color_orange_light,
);

$core_css[] = array(
	'elements' => '
		.main-menu ul li ul li:hover > a,
        .main-menu ul li ul li ul li:hover > a,
        #dsidx-top-search #dsidx-search-bar .dsidx-search-controls button,
        #ihf-main-container ul.pagination li:first-child a:hover,
        #ihf-main-container ul.pagination li:first-child span:hover,
        #ihf-main-container ul.pagination li:last-child a:hover,
        #ihf-main-container ul.pagination li:last-child span:hover,
        #ihf-main-container .ihf-listing-search-results .btn-group .btn:not(.dropdown-toggle):hover,
        #ihf-main-container .ihf-listing-search-results .btn-group .btn.active:not(.dropdown-toggle),
        #ihf-main-container .ihf-listing-search-results #saveSearchButton:hover,
        #ihf-main-container .ihf-widget .row button:hover
    ',
	'property' => 'background-color',
	'value'    => $core_color_orange_dark,
);

$core_css[] = array(
	'elements' => '
		#ihf-main-container ul.pagination li:first-child a:hover,
		#ihf-main-container ul.pagination li:first-child span:hover,
		#ihf-main-container ul.pagination li:last-child a:hover,
		#ihf-main-container ul.pagination li:last-child span:hover,
		#ihf-main-container .ihf-listing-search-results .btn-group .btn:not(.dropdown-toggle):hover,
		#ihf-main-container .ihf-listing-search-results .btn-group .btn.active:not(.dropdown-toggle)
	',
	'property' => 'border-color',
	'value'    => $core_color_orange_dark,
);

$core_css[] = array(
	'elements' => '
		.widget ul li a:hover,
	    #footer .widget ul li a:hover,
        #footer .widget ul li a:focus,
        #footer.widget ul li a:active,
        #footer .widget a:hover,
        #footer .widget a:focus,
        #footer .widget a:active,
        #footer-bottom a:hover,
        #footer-bottom a:focus,
        #footer-bottom a:active,
        #overview .share-networks a:hover
    ',
	'property' => 'color',
	'value'    => $core_color_orange_dark,
);

$core_css[] = array(
	'elements' => '
		.real-btn:hover,
		.inner-wrapper .hentry .post-tags a:hover,
		input:hover[type="submit"],
		.tagcloud a:hover,
		.real-btn.current,
		#dsidx-top-search #dsidx-search-bar .dsidx-search-controls button:hover,
		div.rh_login_modal_classic button:hover,
		body .rh_floating_classic .rh_compare__submit:hover,
		div.rh_login_modal_wrapper button:not(.dropdown-toggle):hover
	',
	'property' => 'background-color',
	'value'    => $core_color_orange_glow
);

$core_css[] = array(
	'elements' => '
		#dsidx .dsidx-small-button:hover,
		body.dsidx .dsidx-small-button:hover,
		#dsidx .dsidx-large-button:hover,
		body.dsidx .dsidx-large-button:hover
	',
	'property' => 'background-color',
	'value'    => $core_color_orange_burnt
);

$core_css[] = array(
	'elements' => '
		a:hover,
		.more-details:hover,
		.more-details:focus,
		.more-details:active,
		.es-carousel-wrapper ul li p a:hover,
		.es-carousel-wrapper ul li p a:focus,
		.es-carousel-wrapper ul li p a:active,
		.property-item h4 a:hover,
		.property-item h4 a:focus,
		.property-item h4 a:active,
		.es-carousel-wrapper ul li h4 a:hover,
		.es-carousel-wrapper ul li h4 a:focus,
		.es-carousel-wrapper ul li h4 a:active,
		.post-title a:hover,
		.slide-description h3 a:hover,
		#dsidx-disclaimer a:hover,
		.slide-description span,
		#dsidx.dsidx-results .dsidx-paging-control a:hover,
		#ihf-main-container a:hover,
		#ihf-main-container .ihf-slider-col .ihf-grid-result-container .ihf-grid-result-photocount a:hover,
		#ihf-main-container .ihf-grid-result .ihf-grid-result-container .ihf-grid-result-photocount a:hover,
		#ihf-main-container .ihf-slider-col .ihf-grid-result-container .ihf-grid-result-address:hover,
		#ihf-main-container .ihf-grid-result .ihf-grid-result-container .ihf-grid-result-address:hover,
		ul.featured-properties li h4 a:hover,
		.about-agent h4 a:hover,
		.property-item h4 .about-agent a a:hover,
		.contact-details .contacts-list li a:hover,
		body .rh_floating_classic .rh_compare__slide_img .rh_compare_view_title:hover,
		.list-container .property-item .property-meta .add-to-compare-span a:hover,
		.infoBox span.price,
		.infoBox .prop-title a:hover
	',
	'property' => 'color',
	'value'    => $core_color_orange_burnt,
);

$core_css[] = array(
	'elements' => '.view-type a.grid.active .boxes,
							   .view-type a.grid:hover .boxes,
							   .view-type a.list.active .boxes,
							   .view-type a.list:hover .boxes',
	'property' => 'fill',
	'value'    => $core_color_orange_burnt,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input[type=range]::-webkit-slider-thumb',
	'property' => 'background',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input[type=range]::-moz-range-thumb ',
	'property' => 'background',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input[type=range]::-ms-thumb',
	'property' => 'background',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost_graph_circle .mc_graph_svg .mc_graph_interest',
	'property' => 'stroke',
	'value'    => $core_color_orange_burnt,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost_graph_circle .mc_graph_svg .mc_graph_tax',
	'property' => 'stroke',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost_graph_circle .mc_graph_svg .mc_graph_hoa',
	'property' => 'stroke',
	'value'    => inspiry_hex_to_rgba( $core_color_blue_light, .3 ),
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost ul li.mc_cost_interest::before',
	'property' => 'background-color',
	'value'    => $core_color_orange_burnt,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost ul li.mc_cost_tax::before',
	'property' => 'background-color',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost ul li.mc_cost_hoa::before',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_color_blue_light, .3 ),
);

$core_css[] = array(
	'elements' => '
		.property-item .price,
		.es-carousel-wrapper ul li .price,
		.slide-description .know-more,
		#scroll-top,
		#overview .property-item .price span,
		.tagcloud a,
		.format-image .format-icon.image,
		.format-video .format-icon.video,
		.format-gallery .format-icon.gallery,
		.listing-slider .flex-direction-nav a.flex-next,
		.listing-slider .flex-direction-nav a.flex-prev,
		.listing-slider .flex-control-paging li a,
		#dsidx-listings .dsidx-primary-data,
		#dsidx-top-search #dsidx-search-bar,
		#dsidx-top-search #dsidx-search-form-wrap,
		.dsidx-results-grid #dsidx-listings .dsidx-listing .dsidx-data .dsidx-primary-data .dsidx-price,
		#dsidx-top-search #dsidx-search-form-main #dsidx-search-filters .dsidx-search-openclose,
		#dsidx-zestimate #dsidx-zestimate-notice,
		#dsidx-zestimate #dsidx-rentzestimate-notice,
		#dsidx-rentzestimate #dsidx-zestimate-notice,
		#dsidx-rentzestimate #dsidx-rentzestimate-notice,
		.dsidx-details .dsidx-headerbar-green,
		.rh_slide__container figure .statuses a,
		.posts-main .post-footer .real-btn,
		#ihf-main-container .ihf-slider-col .ihf-grid-result-container .ihf-grid-result-price,
		#ihf-main-container .ihf-grid-result .ihf-grid-result-container .ihf-grid-result-price,
		#property-carousel-two .flex-direction-nav a,
		.select2-container--default .select2-results__option--highlighted[aria-selected],
		.qe-faq-toggle .qe-toggle-title,
		.qe-faq-toggle.active .qe-toggle-title,
		body .leaflet-popup-tip,
		body.design_classic .marker-cluster-small div, body.design_classic .marker-cluster-medium div,
		.inspiry_select_picker_trigger.bootstrap-select ul.dropdown-menu li.selected,
		.inspiry_select_picker_trigger.bootstrap-select ul.dropdown-menu li:hover,
		.cluster div,
		.woocommerce .widget_price_filter .ui-slider .ui-slider-range
	',
	'property' => 'background-color',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => 'body.design_classic .marker-cluster-small, body.design_classic .marker-cluster-medium, .cluster',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_color_blue_light, .5 ),
);

$core_css[] = array(
	'elements' => '
		#dsidx-zestimate #dsidx-zestimate-triangle,
		#dsidx-zestimate #dsidx-rentzestimate-triangle,
		#dsidx-rentzestimate #dsidx-zestimate-triangle,
		#dsidx-rentzestimate #dsidx-rentzestimate-triangle
    ',
	'property' => 'border-left-color',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '
		#dsidx-zestimate,
		#dsidx-rentzestimate,
		.dsidx-details .dsidx-headerbar-green,
		.qe-faq-toggle .qe-toggle-content
	',
	'property' => 'border-color',
	'value'    => $core_color_blue_light
);

$core_css[] = array(
	'elements' => '.gallery-item .media_container',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_color_blue_light, .9 ),
);

$core_css[] = array(
	'elements' => '#dsidx-zestimate, #dsidx-rentzestimate',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_color_blue_light, .1 ),
);

$core_css[] = array(
	'elements' => '#overview .property-item .price .price-and-type .tag-arrow svg',
	'property' => 'fill',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '
		#footer .widget ul.featured-properties li .price,
		ul.featured-properties li .price,
		.property-grid .property-item span,
		.compare-template .compare-properties-column .property-thumbnail .property-price
	',
	'property' => 'color',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '.form-heading, .infoBox .arrow-down',
	'property' => 'border-top-color',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '
		.post-meta,
        body .leaflet-popup-content-wrapper,
        .infoBox .map-info-window
    ',
	'property' => 'border-bottom-color',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '.about-agent .rh_agent_verification__icon',
	'property' => 'background',
	'value'    => $core_color_blue_light,
);

$core_css[] = array(
	'elements' => '
		#scroll-top:hover,
	   .page-head p,
	   .page-head div.page-breadcrumbs,
	   .slide-description .know-more:hover,
	   .home-features-section .home-features-bg,
	   .rh_slide__container figure .statuses a:hover,
	   .posts-main .post-footer .real-btn:hover,
	   .qe-faq-toggle .qe-toggle-title:hover,
	   .contact-number .fa-phone, .contact-number .fa-whatsapp
   ',
	'property' => 'background-color',
	'value'    => $core_color_blue_dark,
);

$core_css[] = array(
	'elements' => '
		.dsidx-widget li:before,
		#dsidx-listings .dsidx-secondary-data div:before,
		div.dsidx-results-widget ul.dsidx-list li:before,
		#dsidx-disclaimer a,
		#dsidx.dsidx-results .dsidx-paging-control a
	',
	'property' => 'color',
	'value'    => $core_color_blue_dark,
);

if ( ! empty( $core_color_orange_light ) ) {
	$core_css[] = array(
		'elements' => '.ihf-map-icon',
		'property' => 'background-color',
		'value'    => $core_color_orange_light . '!important',
	);
	$core_css[] = array(
		'elements' => '.ihf-map-icon',
		'property' => 'border-color',
		'value'    => $core_color_orange_light . '!important',
	);
	$core_css[] = array(
		'elements' => '.ihf-map-icon:after',
		'property' => 'border-top-color',
		'value'    => $core_color_orange_light . '!important',
	);

	$core_css[] = array(
		'elements' => '#ihf-main-container .ihf-select-options .ihf-select-available-option>span.ihf-selected, .ihf-eureka .ihf-select-options .ihf-select-available-option>span.ihf-selected,
				#ihf-main-container .btn-primary, #ihf-main-container .btn.btn-default, #ihf-main-container .ihf-btn.ihf-btn-primary, .ihf-eureka .btn-primary, .ihf-eureka .btn.btn-default, .ihf-eureka .ihf-btn.ihf-btn-primary',
		'property' => 'background-color',
		'value'    => $core_color_orange_light . ' !important',
	);

	$core_css[] = array(
		'elements' => '#ihf-main-container .btn-primary, #ihf-main-container .btn.btn-default,#ihf-main-container .ihf-btn.ihf-btn-primary, .ihf-eureka .btn-primary, .ihf-eureka .btn.btn-default, .ihf-eureka .ihf-btn.ihf-btn-primary',
		'property' => 'border-color',
		'value'    => $core_color_orange_light . ' !important',
	);
}

if ( ! empty( $core_color_orange_light ) ) {
	$dynamic_css[] = array(
		'elements' => '.ihf-map-icon',
		'property' => 'background-color',
		'value'    => $core_color_orange_light . '!important',
	);
	$dynamic_css[] = array(
		'elements' => '.ihf-map-icon',
		'property' => 'border-color',
		'value'    => $core_color_orange_light . '!important',
	);
	$dynamic_css[] = array(
		'elements' => '.ihf-map-icon:after',
		'property' => 'border-top-color',
		'value'    => $core_color_orange_light . '!important',
	);

	$dynamic_css[] = array(
		'elements' => '#ihf-main-container .ihf-select-options .ihf-select-available-option>span.ihf-selected, .ihf-eureka .ihf-select-options .ihf-select-available-option>span.ihf-selected,
				#ihf-main-container .btn-primary, #ihf-main-container .btn.btn-default, #ihf-main-container .ihf-btn.ihf-btn-primary, .ihf-eureka .btn-primary, .ihf-eureka .btn.btn-default, .ihf-eureka .ihf-btn.ihf-btn-primary',
		'property' => 'background-color',
		'value'    => $core_color_orange_light . ' !important',
	);

	$dynamic_css[] = array(
		'elements' => '#ihf-main-container .btn-primary, #ihf-main-container .btn.btn-default,#ihf-main-container .ihf-btn.ihf-btn-primary, .ihf-eureka .btn-primary, .ihf-eureka .btn.btn-default, .ihf-eureka .ihf-btn.ihf-btn-primary',
		'property' => 'border-color',
		'value'    => $core_color_orange_light . ' !important',
	);
}

if ( ! empty( $core_color_orange_glow ) ) {

	$dynamic_css[] = array(
		'elements' => '#ihf-main-container .btn-primary:active, #ihf-main-container .btn-primary:focus, #ihf-main-container .btn-primary:hover, #ihf-main-container .btn.btn-default:active, #ihf-main-container .btn.btn-default:focus, #ihf-main-container .btn.btn-default:hover, #ihf-main-container .ihf-btn.ihf-btn-primary:active, #ihf-main-container .ihf-btn.ihf-btn-primary:focus, #ihf-main-container .ihf-btn.ihf-btn-primary:hover, .ihf-eureka .btn-primary:active, .ihf-eureka .btn-primary:focus, .ihf-eureka .btn-primary:hover, .ihf-eureka .btn.btn-default:active, .ihf-eureka .btn.btn-default:focus, .ihf-eureka .btn.btn-default:hover, .ihf-eureka .ihf-btn.ihf-btn-primary:active, .ihf-eureka .ihf-btn.ihf-btn-primary:focus, .ihf-eureka .ihf-btn.ihf-btn-primary:hover',
		'property' => 'background-color',
		'value'    => $core_color_orange_glow . ' !important',
	);

	$dynamic_css[] = array(
		'elements' => '#ihf-main-container .btn-primary:active, #ihf-main-container .btn-primary:focus, #ihf-main-container .btn-primary:hover, #ihf-main-container .btn.btn-default:active, #ihf-main-container .btn.btn-default:focus, #ihf-main-container .btn.btn-default:hover, #ihf-main-container .ihf-btn.ihf-btn-primary:active, #ihf-main-container .ihf-btn.ihf-btn-primary:focus, #ihf-main-container .ihf-btn.ihf-btn-primary:hover, .ihf-eureka .btn-primary:active, .ihf-eureka .btn-primary:focus, .ihf-eureka .btn-primary:hover, .ihf-eureka .btn.btn-default:active, .ihf-eureka .btn.btn-default:focus, .ihf-eureka .btn.btn-default:hover, .ihf-eureka .ihf-btn.ihf-btn-primary:active, .ihf-eureka .ihf-btn.ihf-btn-primary:focus, .ihf-eureka .ihf-btn.ihf-btn-primary:hover',
		'property' => 'border-color',
		'value'    => $core_color_orange_glow . ' !important',
	);

	$core_css[] = array(
		'elements' => '#ihf-main-container .btn-primary:active, #ihf-main-container .btn-primary:focus, #ihf-main-container .btn-primary:hover, #ihf-main-container .btn.btn-default:active, #ihf-main-container .btn.btn-default:focus, #ihf-main-container .btn.btn-default:hover, #ihf-main-container .ihf-btn.ihf-btn-primary:active, #ihf-main-container .ihf-btn.ihf-btn-primary:focus, #ihf-main-container .ihf-btn.ihf-btn-primary:hover, .ihf-eureka .btn-primary:active, .ihf-eureka .btn-primary:focus, .ihf-eureka .btn-primary:hover, .ihf-eureka .btn.btn-default:active, .ihf-eureka .btn.btn-default:focus, .ihf-eureka .btn.btn-default:hover, .ihf-eureka .ihf-btn.ihf-btn-primary:active, .ihf-eureka .ihf-btn.ihf-btn-primary:focus, .ihf-eureka .ihf-btn.ihf-btn-primary:hover',
		'property' => 'background-color',
		'value'    => $core_color_orange_glow . ' !important',
	);

	$core_css[] = array(
		'elements' => '#ihf-main-container .btn-primary:active, #ihf-main-container .btn-primary:focus, #ihf-main-container .btn-primary:hover, #ihf-main-container .btn.btn-default:active, #ihf-main-container .btn.btn-default:focus, #ihf-main-container .btn.btn-default:hover, #ihf-main-container .ihf-btn.ihf-btn-primary:active, #ihf-main-container .ihf-btn.ihf-btn-primary:focus, #ihf-main-container .ihf-btn.ihf-btn-primary:hover, .ihf-eureka .btn-primary:active, .ihf-eureka .btn-primary:focus, .ihf-eureka .btn-primary:hover, .ihf-eureka .btn.btn-default:active, .ihf-eureka .btn.btn-default:focus, .ihf-eureka .btn.btn-default:hover, .ihf-eureka .ihf-btn.ihf-btn-primary:active, .ihf-eureka .ihf-btn.ihf-btn-primary:focus, .ihf-eureka .ihf-btn.ihf-btn-primary:hover',
		'property' => 'border-color',
		'value'    => $core_color_orange_glow . ' !important',
	);
}

if ( ! empty( $core_color_blue_light ) ) {
	$dynamic_css[] = array(
		'elements' => '#ihf-main-container .ihf-detail-tab-content #ihf-detail-features-tab .title-bar-1',
		'property' => 'background-color',
		'value'    => $core_color_blue_light . ' !important',
	);

	$dynamic_css[] = array(
		'elements' => '.dsidx-details .dsidx-contact-form',
		'property' => 'border-color',
		'value'    => $core_color_blue_light . '!important',
	);
}

if ( ! empty( $core_color_blue_light ) ) {
	$core_css[] = array(
		'elements' => '#ihf-main-container .ihf-detail-tab-content #ihf-detail-features-tab .title-bar-1',
		'property' => 'background-color',
		'value'    => $core_color_blue_light . ' !important',
	);

	$core_css[] = array(
		'elements' => '.dsidx-details .dsidx-contact-form',
		'property' => 'border-color',
		'value'    => $core_color_blue_light . '!important',
	);
}


return $core_css;