<?php
/**
 * Containing dynamic css responsive style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

if ( ! function_exists( 'realhomes_dynamic_css_responsive_header_below_979px' ) ) {
	/**
	 * Function will return generated array combination for responsive
	 * header for below 979px width
	 *
	 * @return array
	 */
	function realhomes_dynamic_css_responsive_header_below_979px() {
		$responsive_header_keys = array(
			'theme_header_bg_color_responsive',
			'theme_header_email_color_responsive',
			'theme_header_email_hover_color_responsive',
			'theme_header_user_nav_color_responsive',
			'theme_header_user_nav_hover_color_responsive',
			'theme_header_user_nav_border_color_responsive',
			'theme_header_site_logo_color_responsive',
			'theme_header_site_logo_hover_color_responsive',
			'theme_header_tag_line_color_responsive',
			'theme_header_tag_line_bg_color_responsive',
			'theme_header_phone_color_responsive',
			'theme_header_phone_hover_color_responsive',
			'theme_responsive_menu_icon_color',
			'theme_nav_bg_color_responsive',
			'theme_nav_text_color_responsive',
			'theme_nav_text_color_hover_responsive',
			'theme_nav_bg_color_hover_responsive'
		);

		$responsive_options = realhomes_get_options( $responsive_header_keys );

		$responsive_css[] = array(
			'elements' => '.header-wrapper',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_header_bg_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '#contact-email,#contact-email a',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_email_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '#contact-email svg .path',
			'property' => 'fill',
			'value'    => $responsive_options['theme_header_email_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '#contact-email a:hover',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_email_hover_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.user-nav a,.user-nav a:after',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_user_nav_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.user-nav a:hover',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_user_nav_hover_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '#header-top',
			'property' => 'border-color',
			'value'    => $responsive_options['theme_header_user_nav_border_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '#logo h2 a',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_site_logo_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '#logo h2 a:hover',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_site_logo_hover_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.tag-line span',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_tag_line_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.tag-line span',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_header_tag_line_bg_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.contact-number',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_phone_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.contact-number a:hover',
			'property' => 'color',
			'value'    => $responsive_options['theme_header_phone_hover_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_responsive_menu_icon_color'],
		);

		$responsive_css[] = array(
			'elements' => '.main-menu .rh_menu__hamburger p',
			'property' => 'color',
			'value'    => $responsive_options['theme_responsive_menu_icon_color'],
		);

		$responsive_css[] = array(
			'elements' => '.main-menu .rh_menu__responsive',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_nav_bg_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.main-menu ul li a,.main-menu .rh_menu__responsive .rh_menu__indicator',
			'property' => 'color',
			'value'    => $responsive_options['theme_nav_text_color_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.main-menu ul li:hover > a,.main-menu ul li.current_page_item > a,.main-menu .rh_menu__responsive li:hover > .rh_menu__indicator',
			'property' => 'color',
			'value'    => $responsive_options['theme_nav_text_color_hover_responsive'],
		);

		$responsive_css[] = array(
			'elements' => '.main-menu ul li:hover > a,.main-menu ul li.current_page_item > a',
			'property' => 'color',
			'value'    => $responsive_options['theme_nav_bg_color_hover_responsive'],
		);

		return $responsive_css;
	}

}

if ( ! function_exists( 'realhomes_dynamic_css_above_980px' ) ) {
	/**
	 * Function will return generated array combination for responsive
	 * css for above 980px width
	 *
	 * @return array
	 */
	function realhomes_dynamic_css_above_980px() {
		$responsive_header_keys = array(
			'theme_phone_bg_color',
			'theme_phone_text_color',
			'theme_phone_icon_bg_color',
			'theme_core_color_blue_light',
			'theme_core_color_blue_dark'
		);

		$responsive_options = realhomes_get_options( $responsive_header_keys );

		$responsive_css[] = array(
			'elements' => '.contact-number, .contact-number .outer-strip',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_phone_bg_color']
		);

		$responsive_css[] = array(
			'elements' => '.contact-number',
			'property' => 'color',
			'value'    => $responsive_options['theme_phone_text_color']
		);

		$responsive_css[] = array(
			'elements' => '.contact-number .fa-phone',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_phone_icon_bg_color']
		);

		$responsive_css[] = array(
			'elements' => '
					.contact-number,
				    .contact-number .outer-strip
			    ',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_core_color_blue_light'],
		);

		$responsive_css[] = array(
			'elements' => '.contact-number .fa-phone, .contact-number .fa-whatsapp',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_core_color_blue_dark'],
		);

		return $responsive_css;
	}

}

if ( ! function_exists( 'realhomes_dynamic_core_css_above_767px' ) ) {
	/**
	 * Function will return generated array combination for responsive
	 * css for above 767px width
	 *
	 * @return array
	 */
	function realhomes_dynamic_core_css_above_767px() {
		$responsive_header_keys = array(
			'theme_core_color_blue_light',
			'theme_core_color_blue_light'
		);

		$responsive_options = realhomes_get_options( $responsive_header_keys );

		$responsive_css[] = array(
			'elements' => '#overview .property-item .price',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_core_color_blue_light']
		);

		$responsive_css[] = array(
			'elements' => '#overview .property-item .price',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_core_color_blue_light']
		);

		return $responsive_css;
	}

}

if ( ! function_exists( 'realhomes_dynamic_core_css_above_767px' ) ) {
	/**
	 * Function will return generated array combination for responsive
	 * css for above 767px width
	 *
	 * @return array
	 */
	function realhomes_dynamic_core_css_above_767px() {
		$responsive_header_keys = array(
			'theme_core_color_blue_light',
			'theme_core_color_blue_light'
		);

		$responsive_options = realhomes_get_options( $responsive_header_keys );

		$responsive_css[] = array(
			'elements' => '#overview .property-item .price',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_core_color_blue_light']
		);

		$responsive_css[] = array(
			'elements' => '#overview .property-item .price',
			'property' => 'background-color',
			'value'    => $responsive_options['theme_core_color_blue_light']
		);

		return $responsive_css;
	}

}