<?php
/**
 * Containing dynamic css search style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$search_keys = array( 'inspiry_SFOI_top_margin' );

$search_options = realhomes_get_options( $search_keys );

$inspiry_SFOI_top_margin        = $search_options[ 'inspiry_SFOI_top_margin' ];
$inspiry_SFOI_title_color       = get_post_meta( get_the_ID(), 'inspiry_SFOI_title_color', true );
$inspiry_SFOI_description_color = get_post_meta( get_the_ID(), 'inspiry_SFOI_description_color', true );
$inspiry_SFOI_overlay_opacity   = get_post_meta( get_the_ID(), 'inspiry_SFOI_overlay_opacity', true );
$inspiry_SFOI_overlay_color     = inspiry_hex2rgb( get_post_meta( get_the_ID(), 'inspiry_SFOI_overlay_color', true ), $inspiry_SFOI_overlay_opacity );

$search_css = array(
	'elements' => '.SFOI__overlay',
	'property' => 'background-color',
	'value'    => $inspiry_SFOI_overlay_color,
);

$search_css = array(
	'elements' => '.SFOI__title',
	'property' => 'color',
	'value'    => $inspiry_SFOI_title_color,
);

$search_css = array(
	'elements' => '.SFOI__description',
	'property' => 'color',
	'value'    => $inspiry_SFOI_description_color,
);

return $search_css;