<?php
/**
 * Similar Blog Posts
 * Similar blog posts to be displayed under single blog post
 * @since      4.4.2
 * @package    realhomes
 * @subpackage modern
 */
$post_id = get_the_ID();

$tag_ids      = wp_get_post_terms( $post_id, 'post_tag', [ 'fields' => 'ids' ] );
$category_ids = wp_get_post_terms( $post_id, 'category', [ 'fields' => 'ids' ] );

$tax_query = [];

if ( ! empty( $category_ids ) ) {
	$tax_query[] = [
		'taxonomy' => 'category',
		'field'    => 'term_id',
		'terms'    => $category_ids,
	];
}

if ( ! empty( $tag_ids ) ) {
	$tax_query[] = [
		'taxonomy' => 'post_tag',
		'field'    => 'term_id',
		'terms'    => $tag_ids,
	];
}

$args = [
	'post_type'           => 'post',
	'post__not_in'        => [ $post_id ],
	'posts_per_page'      => 3,
	'ignore_sticky_posts' => true,
	'tax_query'           => array_merge( [ 'relation' => 'OR' ], $tax_query ),
];

$news_query = new WP_Query( apply_filters( 'realhomes_similar_posts_query', $args ) );
if ( $news_query->have_posts() ) {
	?>
    <section class="rh_section rh_section__news rh-similar-posts-section">
        <h3 class="rh_property__heading"><?php esc_html_e( 'Similar Posts', RH_TEXT_DOMAIN ); ?></h3>
        <div class="wrapper-section-contents">
            <div class="rh_section__news_wrap">
				<?php
				while ( $news_query->have_posts() ) :
					$news_query->the_post();
					?>
                    <article class="rh-wrapper-post">
                        <div class="rh-wrapper-post-media">
							<?php get_template_part( "assets/modern/partials/blog/post-formats/image" ); ?>
                        </div>
                        <div class="rh-wrapper-post-contents">
                            <div class="post-meta">
                                <span class="date"> <?php the_time( get_option( 'date_format' ) ); ?></span>
								<?php
								$get_categories = get_the_category();
								if ( is_array( $get_categories ) && ! empty( $get_categories ) ) {
									?>
                                    <span class="categories">
										<?php
										esc_html_e( 'In ', RH_TEXT_DOMAIN );
										foreach ( $get_categories as $category ) {
											?>
                                            <a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><?php echo esc_html( $category->name ); ?></a>
											<?php
										}
										?>
                                    </span>
									<?php
								}
								?>
                            </div>
                            <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php framework_excerpt( 12 ); ?></p>
                            <span class="by-author"><?php esc_html_e( 'By', RH_TEXT_DOMAIN ); ?><span class="author-link"><?php the_author() ?></span></span>
                        </div>
                    </article>
				<?php
				endwhile;
				wp_reset_postdata();
				?>
            </div><!-- /.rh_section__properties -->
        </div>
    </section><!-- /.rh_section rh_section__agents -->
	<?php
}