<?php
global $post;

$features_terms = get_the_terms( get_the_ID(), 'property-feature' );
if ( ! empty( $features_terms ) ) {
	?>
    <div class="features-content-wrapper single-property-section <?php realhomes_printable_section( 'features' ); ?>">
        <div class="container">
            <div class="rh_property__features_wrap">
				<?php
				$property_features_title = get_option( 'theme_property_features_title' );
				if ( ! empty( $property_features_title ) ) {
					?><h4 class="rh_property__heading"><?php echo esc_html( $property_features_title ); ?></h4><?php
				}
				$property_features_display = get_option( 'inspiry_property_features_display', 'link' );
				?>
                <ul class="rh_property__features arrow-bullet-list">
					<?php
					foreach ( $features_terms as $feature_term ) {
						echo '<li class="rh_property__feature" id="rh_property__feature_' . esc_attr( $feature_term->term_id ) . '">';
						echo '<span class="rh_done_icon">';
						inspiry_safe_include_svg( '/icons/verified-check.svg', '/common/images' );
						echo '</span>';
						if ( 'link' === $property_features_display ) {
							echo '<a href="' . esc_url( get_term_link( $feature_term, 'property-feature' ) ) . '">' . esc_html( $feature_term->name ) . '</a>';
						} else {
							echo esc_html( $feature_term->name );
						}
						echo '</li>';
					}
					?>
                </ul>
            </div>
        </div>
    </div>
	<?php
}