<?php
/**
 * Property Seasonal Prices Section.
 *
 * @since   3.15.0
 * @package realhomes/modern/property
 */

if ( inspiry_is_rvr_enabled() && 'true' === get_option( 'inspiry_seasonal_prices_display', 'true' ) ) {
	$property_id     = get_the_ID();
	$seasonal_prices = get_post_meta( $property_id, 'rvr_seasonal_pricing', true );

	if ( ! empty( $seasonal_prices ) ) {
		?>
        <div class="single-property-section <?php realhomes_printable_section( 'rvr/seasonal-prices' ); ?>">
            <div class="container">
				<?php get_template_part( 'assets/modern/partials/property/single/rvr/seasonal-prices' ); ?>
            </div>
        </div>
		<?php
	}
}