<?php
/**
 * Property features of single property.
 *
 * @package    realhomes
 * @subpackage modern
 */

// Get current property's features
$features_terms = get_the_terms( get_the_ID(), 'property-feature' );
if ( ! empty( $features_terms ) ) {
	?>
    <div id="property-content-section-features" class="property-content-section rh_property__features_wrap <?php realhomes_printable_section( 'features' ); ?>">
		<?php
		$property_features_title = get_option( 'theme_property_features_title' );
		if ( ! empty( $property_features_title ) ) {
			?><h4 class="rh_property__heading"><?php echo esc_html( $property_features_title ); ?></h4><?php
		}
		$rh_property_features_display = get_option( 'inspiry_property_features_display', 'link' );
		?>
        <div class="rh-property-features-inner-wrap">
            <ul class="rh_property__features arrow-bullet-list">
				<?php
				foreach ( $features_terms as $feature_term ) {
					echo '<li class="rh_property__feature" id="rh_property__feature_' . esc_attr( $feature_term->term_id ) . '">';
					echo '<span class="rh_done_icon">';
					inspiry_safe_include_svg( '/icons/verified-check.svg', '/common/images' );
					echo '</span>';
					if ( 'link' === $rh_property_features_display ) {
						echo '<a href="' . esc_url( get_term_link( $feature_term ) ) . '">' . esc_html( $feature_term->name ) . '</a>';
					} else {
						echo esc_html( $feature_term->name );
					}
					echo '</li>';
				}
				?>
            </ul>
        </div>
    </div>
	<?php
}