<?php
/**
 * Display RVR section if enabled.
 *
 * @package    realhomes
 * @subpackage modern
 */
if ( inspiry_is_rvr_enabled() && ( 'true' === get_option( 'realhomes_rvr_surroundings', 'true' ) || 'true' === get_option( 'realhomes_rvr_outdoor_features', 'true' ) ) ) {
	?>
    <div class="property-rvr-outdoor-features <?php realhomes_printable_section( 'rvr/location-surroundings' ); ?>">
		<?php
		$property_id           = get_the_ID();
		$location_surroundings = get_post_meta( $property_id, 'rvr_surroundings', true );
		$rvr_outdoor_features  = get_post_meta( $property_id, 'rvr_outdoor_features', true );
		if ( ! empty( $location_surroundings ) || ! empty( $rvr_outdoor_features ) ) {
			?>
            <h4 class="rh_property__heading property-layout-accordion-toggle-heading">
	            <?php
	            $rvr_settings = get_option( 'rvr_settings' );
	            $rvr_settings = get_option( 'rvr_settings' );
	            $first        = empty( $rvr_settings['rvr_surroundings_label'] ) ? esc_html( $rvr_settings['rvr_surroundings_label'] ) : esc_html__( 'Surroundings', RH_TEXT_DOMAIN );
	            $second       = ! empty( $rvr_settings['rvr_outdoor_features_label'] ) ? esc_html( $rvr_settings['rvr_outdoor_features_label'] ) : esc_html__( 'Outdoor Features', RH_TEXT_DOMAIN );

	            printf( '%s and %s', $first, $second );
	            ?>
            </h4>
            <div class="rh_rvr_alternate_wrapper rh_outdoor_and_surroundings">
                <div class="rh_inner_outdoor_and_surroundings">
                    <?php
                    // RVR - Property Location Surroundings.
                    get_template_part( 'assets/modern/partials/property/single/rvr/surroundings' );

                    // RVR - Property Outdoor Features.
                    get_template_part( 'assets/modern/partials/property/single/rvr/outdoor-features' );
                    ?>
                </div>
            </div>
			<?php
		}
		?>
    </div>
	<?php
}