<?php
/**
 * Dynamic CSS File
 *
 * Dynamic css file for handling user options.
 *
 * @since   3.0.0
 * @package realhomes/modern
 */
if ( ! function_exists( 'inspiry_generate_dynamic_css' ) ) {
	/**
	 * Function: Generate Dynamic CSS.
	 *
	 * @param $realhomes_modern_custom_css
	 *
	 * @return string
	 * @since 3.0.0
	 *
	 */
	function inspiry_generate_dynamic_css( $realhomes_modern_custom_css ) {

		// Skip adding dynamic styles for default color scheme option.
		if ( 'default' === get_option( 'realhomes_color_scheme', 'custom' ) ) {
			return $realhomes_modern_custom_css;
		}

		// Merging all dynamic css files returns
		$dynamic_css = array_merge(
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/cta.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/headings.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/banner.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/core.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/header.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/header-responsive.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/home.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/property.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/properties.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/blog.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/footer.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/buttons.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/gallery.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/slider.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/search.php' ),
			require( get_template_directory() . '/assets/modern/styles/css/dynamic-css/miscellaneous.php' )
		);

		/* Property labels background color */
		$dynamic_css_above_320px  = array();
		$dynamic_css_above_480px  = array();
		$dynamic_css_above_768px  = array();

		$core_green_dark_color = get_option( 'theme_core_mod_color_green_dark' );
		$dynamic_css_above_1024px = array(
			array(
				'elements' => '.open_more_features.featured-open',
				'property' => 'background',
				'value'    => $core_green_dark_color,
			)
		);

		$dynamic_css_above_1140px = array();
		$dynamic_css_above_1280px = array();

		$prop_count = count( $dynamic_css );
		if ( $prop_count > 0 ) {

			foreach ( $dynamic_css as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}

			/* CSS For min-width: 320px */
			if ( ! empty( $dynamic_css_above_320px ) ) {
				$realhomes_modern_custom_css .= "@media ( min-width: 320px ) {\n";
				foreach ( $dynamic_css_above_320px as $css_unit ) {
					if ( ! empty( $css_unit['value'] ) ) {
						$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
					}
				}
				$realhomes_modern_custom_css .= "}\n";
			}

			/* CSS For min-width: 480px */
			if ( ! empty( $dynamic_css_above_480px ) ) {
				$realhomes_modern_custom_css .= "@media ( min-width: 480px ) {\n";
				foreach ( $dynamic_css_above_480px as $css_unit ) {
					if ( ! empty( $css_unit['value'] ) ) {
						$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
					}
				}
				$realhomes_modern_custom_css .= "}\n";
			}

			/* CSS For min-width: 768px */
			if ( ! empty( $dynamic_css_above_768px ) ) {
				$realhomes_modern_custom_css .= "@media ( min-width: 768px ) {\n";
				foreach ( $dynamic_css_above_768px as $css_unit ) {
					if ( ! empty( $css_unit['value'] ) ) {
						$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
					}
				}
				$realhomes_modern_custom_css .= "}\n";
			}

			/* CSS For min-width: 1024px */
			if ( ! empty( $dynamic_css_above_1024px ) ) {
				$realhomes_modern_custom_css .= "@media ( min-width: 1024px ) {\n";
				foreach ( $dynamic_css_above_1024px as $css_unit ) {
					if ( ! empty( $css_unit['value'] ) ) {
						$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
					}
				}
				$realhomes_modern_custom_css .= "}\n";
			}

			/* CSS For min-width: 1140px */
			if ( ! empty( $dynamic_css_above_1140px ) ) {
				$realhomes_modern_custom_css .= "@media ( min-width: 1140px ) {\n";
				foreach ( $dynamic_css_above_1140px as $css_unit ) {
					if ( ! empty( $css_unit['value'] ) ) {
						$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
					}
				}
				$realhomes_modern_custom_css .= "}\n";
			}

			/* CSS For min-width: 1280px */
			if ( ! empty( $dynamic_css_above_1280px ) ) {
				$realhomes_modern_custom_css .= "@media ( min-width: 1280px ) {\n";
				foreach ( $dynamic_css_above_1280px as $css_unit ) {
					if ( ! empty( $css_unit['value'] ) ) {
						$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
					}
				}
				$realhomes_modern_custom_css .= "}\n";
			}
		}

		$responsive_header_bottom_bg_color = get_option( 'realhomes_responsive_header_bottom_bg_color' );
		if ( ! empty( $responsive_header_bottom_bg_color ) ) {
			$realhomes_modern_custom_css .= "@media ( max-width: 767px ) {\n";
			$realhomes_modern_custom_css .= strip_tags( ".rh_responsive_header_temp .rh_menu__user { background-color: " . $responsive_header_bottom_bg_color . ";" . " }\n" );
		}

		return $realhomes_modern_custom_css;
	}
}

add_filter( 'realhomes_modern_custom_css', 'inspiry_generate_dynamic_css' );
