<?php
/**
 * Containing dynamic css blog style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */
global $dynamic_css;

$blog_styles_keys = array(
	'inspiry_post_meta_bg',
	'inspiry_post_title_color',
	'inspiry_post_title_hover_color',
	array( 'inspiry_post_meta_color', '#1a1a1a' ),
	array( 'inspiry_post_meta_hover_color', '#ffffff' )
);

$blog_style_options = realhomes_get_options( $blog_styles_keys );

$post_meta_bg           = $blog_style_options['inspiry_post_meta_bg'];
$post_title_color       = $blog_style_options['inspiry_post_title_color'];
$post_title_hover_color = $blog_style_options['inspiry_post_title_hover_color'];
$post_meta_color        = $blog_style_options['inspiry_post_meta_color'];
$post_meta_hover_color  = $blog_style_options['inspiry_post_meta_hover_color'];

return array(
	array(
		'elements' => '.rh_blog__post .entry-header',
		'property' => 'background',
		'value'    => $post_meta_bg
	),
	array(
		'elements' => '.rh_blog__post .entry-header .entry-title a',
		'property' => 'color',
		'value'    => $post_title_color
	),
	array(
		'elements' => '
			.rh_blog__post .entry-header .entry-title,
			.rh_blog__post .entry-header .entry-title a:hover
		',
		'property' => 'color',
		'value'    => $post_title_hover_color
	),
	array(
		'elements' => '.rh_blog__post .entry-header .entry-meta',
		'property' => 'color',
		'value'    => $post_meta_color
	),
	array(
		'elements' => '.rh_blog__post .entry-header .entry-meta a:hover',
		'property' => 'color',
		'value'    => $post_meta_hover_color,
	)
);