<?php
/**
 * Containing dynamic css buttons style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */
global $dynamic_css;

$button_styles_keys = array(
	'theme_button_text_color',
	'theme_button_bg_color',
	'theme_button_hover_text_color',
	'inspiry_submit_button_border_color',
	'inspiry_submit_button_border_hover_color',
	'theme_button_hover_bg_color',
	'inspiry_advance_search_btn_bg',
	'inspiry_advance_search_btn_hover_bg',
	'inspiry_advance_search_btn_text',
	'inspiry_advance_search_btn_text_hover',
	'inspiry_advance_search_arrow_and_text',
	'inspiry_gallery_button_color',
	'inspiry_gallery_button_hover_color',
	'inspiry_gallery_button_bg_color',
	'inspiry_gallery_button_bg_hover_color'
);

$button_style_options = realhomes_get_options( $button_styles_keys );

$theme_button_text_color                  = $button_style_options['theme_button_text_color'];
$theme_button_bg_color                    = $button_style_options['theme_button_bg_color'];
$theme_button_hover_text_color            = $button_style_options['theme_button_hover_text_color'];
$inspiry_submit_button_border_color       = $button_style_options['inspiry_submit_button_border_color'];
$inspiry_submit_button_border_hover_color = $button_style_options['inspiry_submit_button_border_hover_color'];
$theme_button_hover_bg_color              = $button_style_options['theme_button_hover_bg_color'];
$inspiry_advance_search_btn_bg            = $button_style_options['inspiry_advance_search_btn_bg'];
$inspiry_advance_search_btn_hover_bg      = $button_style_options['inspiry_advance_search_btn_hover_bg'];
$inspiry_advance_search_btn_text          = $button_style_options['inspiry_advance_search_btn_text'];
$inspiry_advance_search_btn_text_hover    = $button_style_options['inspiry_advance_search_btn_text_hover'];
$inspiry_advance_search_arrow_and_text    = $button_style_options['inspiry_advance_search_arrow_and_text'];
$inspiry_gallery_button_color             = $button_style_options['inspiry_gallery_button_color'];
$inspiry_gallery_button_hover_color       = $button_style_options['inspiry_gallery_button_hover_color'];
$inspiry_gallery_button_bg_color          = $button_style_options['inspiry_gallery_button_bg_color'];
$inspiry_gallery_button_bg_hover_color    = $button_style_options['inspiry_gallery_button_bg_hover_color'];

return array(
	array(
		'elements' => '
			.rh_btn--primary, 
            .rh-btn-primary,
            .rh_pagination .current,
		    .rh_pagination .rh_pagination__btn:hover,	
		    #scroll-top, 
		    #scroll-top:hover, 
		    #scroll-top:active,		               
			.post-password-form input[type="submit"], 
			.widget .searchform input[type="submit"], 
			.comment-form .form-submit .submit, 
			.rh_memberships__selection #ims-stripe-payment-btn .stripe-button-el, 
			.rh_memberships__selection #ims-free-button, 
			.rh_contact__form .wpcf7-form input[type="submit"], 
			.widget_mortgage-calculator .mc-wrapper p input[type="submit"], 
			.rh_memberships__selection .ims-receipt-button #ims-receipt, 
			.rh_contact__form .rh_contact__input input[type="submit"], 
			.rh_form__item input[type="submit"], 
			.rh_pagination__pages-nav a,
			.rh_modal .rh_modal__wrap button,
			.widget .tagcloud a,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button,
			.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label
		',
		'property' => 'background',
		'value'    => $theme_button_bg_color
	),
	array(
		'elements' => '
			.rh_btn--primary:hover,
		    .rh-btn-primary:hover, 	
			#scroll-top:before,								
			.post-password-form input[type="submit"]:hover, 
			.widget .searchform input[type="submit"]:hover, 
			.comment-form .form-submit .submit:hover, 
			.rh_memberships__selection #ims-stripe-payment-btn .stripe-button-el:hover, 
			.rh_memberships__selection #ims-free-button:hover, 
			.rh_contact__form .wpcf7-form input[type="submit"]:hover, 
			.widget_mortgage-calculator .mc-wrapper p input[type="submit"]:hover, 
			.rh_memberships__selection .ims-receipt-button #ims-receipt:hover, 
			.rh_contact__form .rh_contact__input input[type="submit"]:hover, 
			.rh_form__item input[type="submit"]:hover, .rh_pagination__pages-nav a:hover,
			.rh_modal .rh_modal__wrap button:hover,
			.widget .tagcloud a:hover,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button:hover,
			.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label:hover
		',
		'property' => 'background',
		'value'    => $theme_button_hover_bg_color
	),
	array(
		'elements' => '
			.rh_btn--primary,
            .rh-btn-primary,
             #scroll-top,  	
             .rh_pagination .current,	
             .rh_var2_header_meta_container .rh_right_box .rh-btn-primary,	               
			.post-password-form input[type="submit"], 
			.widget .searchform input[type="submit"], 
			.comment-form .form-submit .submit, 
			.rh_memberships__selection #ims-stripe-payment-btn .stripe-button-el, 
			.rh_memberships__selection #ims-free-button, 
			.rh_contact__form .wpcf7-form input[type="submit"], 
			.widget_mortgage-calculator .mc-wrapper p input[type="submit"], 
			.rh_memberships__selection .ims-receipt-button #ims-receipt, 
			.rh_contact__form .rh_contact__input input[type="submit"], 
			.rh_form__item input[type="submit"], 
			.rh_pagination__pages-nav a,
			.rh_modal .rh_modal__wrap button,
			.widget .tagcloud a,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button,
			.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label
		',
		'property' => 'color',
		'value'    => $theme_button_text_color
	),
	array(
		'elements' => '
			.rh_btn--primary:hover, 
            .rh-btn-primary:hover,	
            .rh_pagination .rh_pagination__btn:hover,
            #scroll-top:hover, 
		    #scroll-top:active,		
		    .rh_var2_header_meta_container .rh_right_box .rh-btn-primary:hover,		    
            .post-password-form input[type="submit"]:hover, 
			.widget .searchform input[type="submit"]:hover, 
			.comment-form .form-submit .submit:hover, 
			.rh_memberships__selection #ims-stripe-payment-btn .stripe-button-el:hover, 
			.rh_memberships__selection #ims-free-button:hover, 
			.rh_contact__form .wpcf7-form input[type="submit"]:hover, 
			.widget_mortgage-calculator .mc-wrapper p input[type="submit"]:hover, 
			.rh_memberships__selection .ims-receipt-button #ims-receipt:hover, 
			.rh_contact__form .rh_contact__input input[type="submit"]:hover, 
			.rh_form__item input[type="submit"]:hover, 
			.rh_pagination__pages-nav a:hover, 								 
			.rh_modal .rh_modal__wrap button:hover,
			.widget .tagcloud a:hover,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button:hover,
			.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label:hover
		',
		'property' => 'color',
		'value'    => $theme_button_hover_text_color
	),
	array(
		'elements' => '
			.rh_var2_header_meta_container .rh-btn,
			.rh_var2_header_meta_container .rh-btn-primary,
			.rh_var3_header .rh-btn-primary
		',
		'property' => 'border-color',
		'value'    => $inspiry_submit_button_border_color
	),
	array(
		'elements' => '
			.rh_var2_header_meta_container .rh-btn,
			.rh_var2_header_meta_container .rh-btn-primary:hover,
			.rh_var3_header .rh-btn-primary:hover
		',
		'property' => 'border-color',
		'value'    => $inspiry_submit_button_border_hover_color
	),
	array(
		'elements' => '
			.rh-btn-primary svg,
			.rh-btn-primary svg path
		',
		'property' => 'fill',
		'value'    => $theme_button_text_color
	),
	array(
		'elements' => '
			.rh-btn-primary:hover svg,
			.rh-btn-primary:hover svg path
		',
		'property' => 'fill',
		'value'    => $theme_button_hover_text_color
	),
	array(
		'elements' => '
			.rh_prop_search__form .icon-search,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .icon-search
		',
		'property' => 'stroke',
		'value'    => $theme_button_text_color
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_btn__prop_search:hover .icon-search,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart button:hover .icon-search
		',
		'property' => 'stroke',
		'value'    => $theme_button_hover_text_color
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons div.rh_prop_search__advance,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a
		',
		'property' => 'background',
		'value'    => $inspiry_advance_search_btn_bg . ' !important'
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons div.rh_prop_search__advance a:hover,
	        .inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a:hover
	    ',
		'property' => 'background',
		'value'    => $inspiry_advance_search_btn_hover_bg . ' !important'
	),
	array(
		'elements' => '
			.rh_prop_search__form .icon-search-plus,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a .icon-search-plus,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a .rh_icon__search
		',
		'property' => 'stroke',
		'value'    => $inspiry_advance_search_btn_text
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__advance_btn:hover .icon-search-plus,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a:hover .icon-search-plus,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a:hover .rh_icon__search
		',
		'property' => 'stroke',
		'value'    => $inspiry_advance_search_btn_text_hover
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__advance .advance-search-arrow .arrow-inner span
		',
		'property' => 'color',
		'value'    => $inspiry_advance_search_arrow_and_text
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__advance .advance-search-arrow .arrow-inner svg g
		',
		'property' => 'stroke',
		'value'    => $inspiry_advance_search_arrow_and_text
	),
	array(
		'elements' => '.rh_gallery__wrap .rh_gallery__item .media_container a svg',
		'property' => 'fill',
		'value'    => $inspiry_gallery_button_color
	),
	array(
		'elements' => '.rh_gallery__wrap .rh_gallery__item .media_container a:hover svg',
		'property' => 'fill',
		'value'    => $inspiry_gallery_button_hover_color
	),
	array(
		'elements' => '.rh_gallery__wrap .rh_gallery__item .media_container a',
		'property' => 'background',
		'value'    => $inspiry_gallery_button_bg_color
	),
	array(
		'elements' => '.rh_gallery__wrap .rh_gallery__item .media_container a:hover',
		'property' => 'background',
		'value'    => $inspiry_gallery_button_bg_hover_color
	)
);