<?php
/**
 * Containing dynamic css core theme style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$home_styles_array = array();

$home_styles_keys = array(
	'inspiry_home_properties_title_span_color',
	'inspiry_home_properties_title_color',
	'inspiry_home_properties_desc_color',
	'inspiry_home_properties_background_color',
	'theme_featured_prop_title_span_color',
	'theme_featured_prop_title_color',
	'theme_featured_prop_text_color',
	'inspiry_featured_properties_background_color',
	'inspiry_home_agents_title_span_color',
	'inspiry_home_agents_title_color',
	'inspiry_home_agents_desc_color',
	'inspiry_agents_background_color',
	'inspiry_testimonial_bg',
	'inspiry_testimonial_bg_quote',
	'inspiry_testimonial_color',
	'inspiry_testimonial_name_color',
	'inspiry_testimonial_url_color',
	'inspiry_cta_title_color',
	'inspiry_cta_desc_color',
	'inspiry_cta_btn_one_color',
	'inspiry_cta_btn_one_bg',
	'inspiry_cta_btn_two_color',
	array( 'inspiry_cta_btn_two_bg', '#ffffff' ),
	'inspiry_cta_contact_title_color',
	'inspiry_cta_contact_desc_color',
	'inspiry_home_cta_bg_color',
	'inspiry_cta_contact_btn_one_color',
	array( 'inspiry_cta_contact_btn_one_bg', '#303030' ),
	'inspiry_cta_contact_btn_two_color',
	array( 'inspiry_cta_contact_btn_two_bg', '#ffffff' ),
	'inspiry_agents_title_color',
	'inspiry_agents_title_hover_color',
	'inspiry_agents_text_color',
	'inspiry_agents_phone_color',
	'inspiry_agents_listed_props_color',
	'inspiry_home_features_title_span_color',
	'inspiry_home_features_title_color',
	'inspiry_home_features_desc_color',
	'inspiry_home_feature_title_color',
	'inspiry_home_feature_text_color',
	'inspiry_home_features_background_colors',
	'inspiry_home_partners_title_span_color',
	'inspiry_home_partners_title_color',
	'inspiry_home_partners_desc_color',
	'inspiry_home_partners_background_colors',
	'inspiry_home_news_title_span_color',
	'inspiry_home_news_title_color',
	'inspiry_home_news_desc_color',
	'inspiry_home_news_background_colors'
);

$home_style_options = realhomes_get_options( $home_styles_keys );

// Home Sections.
$inspiry_home_properties_title_span_color     = $home_style_options['inspiry_home_properties_title_span_color'];
$inspiry_home_properties_title_color          = $home_style_options['inspiry_home_properties_title_color'];
$inspiry_home_properties_desc_color           = $home_style_options['inspiry_home_properties_desc_color'];
$inspiry_home_properties_bg_color             = $home_style_options['inspiry_home_properties_background_color'];
$theme_featured_prop_title_span_color         = $home_style_options['theme_featured_prop_title_span_color'];
$theme_featured_prop_title_color              = $home_style_options['theme_featured_prop_title_color'];
$theme_featured_prop_text_color               = $home_style_options['theme_featured_prop_text_color'];
$inspiry_featured_properties_background_color = $home_style_options['inspiry_featured_properties_background_color'];
$inspiry_home_agents_title_span_color         = $home_style_options['inspiry_home_agents_title_span_color'];
$inspiry_home_agents_title_color              = $home_style_options['inspiry_home_agents_title_color'];
$inspiry_home_agents_desc_color               = $home_style_options['inspiry_home_agents_desc_color'];
$inspiry_home_agents_bg_color                 = $home_style_options['inspiry_agents_background_color'];

// Home Testimonial.
$inspiry_testimonial_bg         = $home_style_options['inspiry_testimonial_bg'];
$inspiry_testimonial_bg_quote   = $home_style_options['inspiry_testimonial_bg_quote'];
$inspiry_testimonial_color      = $home_style_options['inspiry_testimonial_color'];
$inspiry_testimonial_name_color = $home_style_options['inspiry_testimonial_name_color'];
$inspiry_testimonial_url_color  = $home_style_options['inspiry_testimonial_url_color'];

// Home CTA BG.
$inspiry_cta_title_color      = $home_style_options['inspiry_cta_title_color'];
$inspiry_cta_desc_color       = $home_style_options['inspiry_cta_desc_color'];
$inspiry_cta_btn_one_color    = $home_style_options['inspiry_cta_btn_one_color'];
$inspiry_cta_btn_one_bg       = $home_style_options['inspiry_cta_btn_one_bg'];
$inspiry_cta_btn_one_hover_bg = inspiry_hex_to_rgba( $inspiry_cta_btn_one_bg, 0.8 );
$inspiry_cta_btn_two_color    = $home_style_options['inspiry_cta_btn_two_color'];
$inspiry_cta_btn_two_bg       = $home_style_options['inspiry_cta_btn_two_bg'];
$inspiry_cta_btn_two_bg_rgba  = inspiry_hex_to_rgba( $inspiry_cta_btn_two_bg, 0.25 );
$inspiry_cta_btn_two_hover_bg = inspiry_hex_to_rgba( $inspiry_cta_btn_two_bg, 0.4 );

// Home CTA Contact BG.
$inspiry_cta_contact_title_color      = $home_style_options['inspiry_cta_contact_title_color'];
$inspiry_cta_contact_desc_color       = $home_style_options['inspiry_cta_contact_desc_color'];
$inspiry_home_cta_bg_color            = $home_style_options['inspiry_home_cta_bg_color'];
$inspiry_home_cta_bg_color            = inspiry_hex_to_rgba( $inspiry_home_cta_bg_color, 0.8 );
$inspiry_cta_contact_btn_one_color    = $home_style_options['inspiry_cta_contact_btn_one_color'];
$inspiry_cta_contact_btn_one_bg       = $home_style_options['inspiry_cta_contact_btn_one_bg'];
$inspiry_cta_contact_btn_one_hover_bg = inspiry_hex_to_rgba( $inspiry_cta_contact_btn_one_bg, 0.8 );
$inspiry_cta_contact_btn_two_color    = $home_style_options['inspiry_cta_contact_btn_two_color'];
$inspiry_cta_contact_btn_two_bg       = $home_style_options['inspiry_cta_contact_btn_two_bg'];
$inspiry_cta_contact_btn_two_hover_bg = inspiry_hex_to_rgba( $inspiry_cta_contact_btn_two_bg, 0.8 );

// Home Agents.
$inspiry_agents_title_color        = $home_style_options['inspiry_agents_title_color'];
$inspiry_agents_title_hover_color  = $home_style_options['inspiry_agents_title_hover_color'];
$inspiry_agents_text_color         = $home_style_options['inspiry_agents_text_color'];
$inspiry_agents_phone_color        = $home_style_options['inspiry_agents_phone_color'];
$inspiry_agents_listed_props_color = $home_style_options['inspiry_agents_listed_props_color'];

// Home Features.
$inspiry_home_features_title_span_color  = $home_style_options['inspiry_home_features_title_span_color'];
$inspiry_home_features_title_color       = $home_style_options['inspiry_home_features_title_color'];
$inspiry_home_features_desc_color        = $home_style_options['inspiry_home_features_desc_color'];
$inspiry_home_feature_title_color        = $home_style_options['inspiry_home_feature_title_color'];
$inspiry_home_feature_text_color         = $home_style_options['inspiry_home_feature_text_color'];
$inspiry_home_features_background_colors = $home_style_options['inspiry_home_features_background_colors'];

// Home Partners.
$inspiry_home_partners_title_span_color  = $home_style_options['inspiry_home_partners_title_span_color'];
$inspiry_home_partners_title_color       = $home_style_options['inspiry_home_partners_title_color'];
$inspiry_home_partners_desc_color        = $home_style_options['inspiry_home_partners_desc_color'];
$inspiry_home_partners_background_colors = $home_style_options['inspiry_home_partners_background_colors'];

//Home News
$inspiry_home_news_title_span_color  = $home_style_options['inspiry_home_news_title_span_color'];
$inspiry_home_news_title_color       = $home_style_options['inspiry_home_news_title_color'];
$inspiry_home_news_desc_color        = $home_style_options['inspiry_home_news_desc_color'];
$inspiry_home_news_background_colors = $home_style_options['inspiry_home_news_background_colors'];

$home_styles_array[] = array(
	'elements' => '.rh_section--props_padding .rh_section__head .rh_section__subtitle',
	'property' => 'color',
	'value'    => $inspiry_home_properties_title_span_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section--props_padding .rh_section__head .rh_section__title',
	'property' => 'color',
	'value'    => $inspiry_home_properties_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section--props_padding .rh_section__head .rh_section__desc',
	'property' => 'color',
	'value'    => $inspiry_home_properties_desc_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section--featured .rh_section__head .rh_section__subtitle',
	'property' => 'color',
	'value'    => $theme_featured_prop_title_span_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section--featured .rh_section__head .rh_section__title',
	'property' => 'color',
	'value'    => $theme_featured_prop_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section--featured .rh_section__head .rh_section__desc',
	'property' => 'color',
	'value'    => $theme_featured_prop_text_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__agents .rh_section__head .rh_section__subtitle',
	'property' => 'color',
	'value'    => $inspiry_home_agents_title_span_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__agents .rh_section__head .rh_section__title',
	'property' => 'color',
	'value'    => $inspiry_home_agents_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__agents .rh_section__head .rh_section__desc',
	'property' => 'color',
	'value'    => $inspiry_home_agents_desc_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta--featured .rh_cta__title',
	'property' => 'color',
	'value'    => $inspiry_cta_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta--featured .rh_cta__quote',
	'property' => 'color',
	'value'    => $inspiry_cta_desc_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--secondary',
	'property' => 'color',
	'value'    => $inspiry_cta_btn_one_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--secondary',
	'property' => 'background',
	'value'    => inspiry_hex_to_rgba( $inspiry_cta_btn_one_bg, 1 ),
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--secondary:hover',
	'property' => 'background',
	'value'    => $inspiry_cta_btn_one_hover_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--greyBG',
	'property' => 'color',
	'value'    => $inspiry_cta_btn_two_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--greyBG',
	'property' => 'background',
	'value'    => $inspiry_cta_btn_two_bg_rgba,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--greyBG:hover',
	'property' => 'background',
	'value'    => $inspiry_cta_btn_two_hover_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta--contact .rh_cta .rh_cta__overlay',
	'property' => 'background-color',
	'value'    => $inspiry_home_cta_bg_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta--contact .rh_cta__title',
	'property' => 'color',
	'value'    => $inspiry_cta_contact_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta--contact .rh_cta__quote',
	'property' => 'color',
	'value'    => $inspiry_cta_contact_desc_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--blackBG',
	'property' => 'color',
	'value'    => $inspiry_cta_contact_btn_one_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--blackBG',
	'property' => 'background',
	'value'    => $inspiry_cta_contact_btn_one_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--blackBG:hover',
	'property' => 'background',
	'value'    => $inspiry_cta_contact_btn_one_hover_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--whiteBG',
	'property' => 'color',
	'value'    => $inspiry_cta_contact_btn_two_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--whiteBG',
	'property' => 'background',
	'value'    => $inspiry_cta_contact_btn_two_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_cta__wrap .rh_cta__btns .rh_btn--whiteBG:hover',
	'property' => 'background',
	'value'    => $inspiry_cta_contact_btn_two_hover_bg,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_testimonial blockquote,
		.rh_section__testimonial .diagonal-mod-background,
		.rh_section__testimonial.flat-border
	',
	'property' => 'background-color',
	'value'    => $inspiry_testimonial_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_testimonial blockquote',
	'property' => 'border-left-color',
	'value'    => $inspiry_testimonial_bg,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_latest-properties .diagonal-mod-background,
		.rh_latest-properties.flat-border
	',
	'property' => 'background-color',
	'value'    => $inspiry_home_properties_bg_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_section--featured .diagonal-mod-background,
		.rh_section--featured.flat-border
	',
	'property' => 'background-color',
	'value'    => $inspiry_featured_properties_background_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__testimonial.diagonal-border:before',
	'property' => 'border-bottom-color',
	'value'    => $inspiry_testimonial_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__testimonial.diagonal-border:after',
	'property' => 'border-top-color',
	'value'    => $inspiry_testimonial_bg,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__testimonial .quotes-marks svg',
	'property' => 'fill',
	'value'    => $inspiry_testimonial_bg_quote,
);

$home_styles_array[] = array(
	'elements' => '.rh_testimonial .rh_testimonial__quote',
	'property' => 'color',
	'value'    => $inspiry_testimonial_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_testimonial .rh_testimonial__author .rh_testimonial__author_name',
	'property' => 'color',
	'value'    => $inspiry_testimonial_name_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_testimonial .rh_testimonial__author .rh_testimonial__author__link a',
	'property' => 'color',
	'value'    => $inspiry_testimonial_url_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_agent .rh_agent__details h3 a',
	'property' => 'color',
	'value'    => $inspiry_agents_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_agent .rh_agent__details h3 a:hover',
	'property' => 'color',
	'value'    => $inspiry_agents_title_hover_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_agent .rh_agent__details .rh_agent__email,
		.rh_agent .rh_agent__details .rh_agent__listed .heading
	',
	'property' => 'color',
	'value'    => $inspiry_agents_text_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_agent .rh_agent__details .rh_agent__phone,
		.rh_agent .rh_agent__details .rh_agent__email:hover
	',
	'property' => 'color',
	'value'    => $inspiry_agents_phone_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_agent .rh_agent__details .rh_agent__listed .figure',
	'property' => 'color',
	'value'    => $inspiry_agents_listed_props_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_section__agents .diagonal-mod-background,
		.rh_section__agents.flat-border
	',
	'property' => 'background-color',
	'value'    => $inspiry_home_agents_bg_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__features .rh_section__head .rh_section__subtitle',
	'property' => 'color',
	'value'    => $inspiry_home_features_title_span_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__features .rh_section__head .rh_section__title',
	'property' => 'color',
	'value'    => $inspiry_home_features_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__features .rh_section__head .rh_section__desc',
	'property' => 'color',
	'value'    => $inspiry_home_features_desc_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_feature h4.rh_feature__title,
		.rh_feature h4.rh_feature__title a
	',
	'property' => 'color',
	'value'    => $inspiry_home_feature_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_feature .rh_feature__desc p',
	'property' => 'color',
	'value'    => $inspiry_home_feature_text_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_section__features .diagonal-mod-background,
		.rh_section__features.flat-border
	',
	'property' => 'background-color',
	'value'    => $inspiry_home_features_background_colors,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__partners .rh_section__head .rh_section__subtitle',
	'property' => 'color',
	'value'    => $inspiry_home_partners_title_span_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__partners .rh_section__head .rh_section__title',
	'property' => 'color',
	'value'    => $inspiry_home_partners_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__partners .rh_section__head .rh_section__desc',
	'property' => 'color',
	'value'    => $inspiry_home_partners_desc_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_section__partners .diagonal-mod-background,
		.rh_section__partners.flat-border
	',
	'property' => 'background-color',
	'value'    => $inspiry_home_partners_background_colors,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__news .rh_section__head .rh_section__subtitle',
	'property' => 'color',
	'value'    => $inspiry_home_news_title_span_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__news .rh_section__head .rh_section__title',
	'property' => 'color',
	'value'    => $inspiry_home_news_title_color,
);

$home_styles_array[] = array(
	'elements' => '.rh_section__news .rh_section__head .rh_section__desc',
	'property' => 'color',
	'value'    => $inspiry_home_news_desc_color,
);

$home_styles_array[] = array(
	'elements' => '
		.rh_section__news .diagonal-mod-background,
		.rh_section__news.flat-border
	',
	'property' => 'background-color',
	'value'    => $inspiry_home_news_background_colors,
);

return $home_styles_array;