<?php
/**
 * Containing dynamic css property style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

global $dynamic_css;
$is_rtl = is_rtl();

$property_styles_keys = array(
	'theme_property_item_bg_color',
	'theme_property_title_color',
	'theme_property_title_hover_color',
	'theme_property_price_text_color',
	'theme_property_desc_text_color',
	'theme_property_meta_text_color',
	'inspiry_property_meta_heading_color',
	'inspiry_property_meta_icon_color',
	'inspiry_property_image_overlay',
	'inspiry_property_featured_label_bg',
	array( 'inspiry_property_favorite_icon_color', '#ffffff' ),
	array( 'inspiry_property_favorite_icon_hover_color', '#ea3d3d' ),
	array( 'realhomes_favorite_icon_placeholder_color', '#ea3d3d' ),
	array( 'inspiry_property_compare_icon_color', '#ffffff' ),
	array( 'inspiry_property_compare_icon_hover_color', '#ea723d' ),
	array( 'realhomes_compare_icon_placeholder_color', '#ea723d' ),
	array( 'inspiry_property_tooltip_bgcolor', '#ea723d' ),
	array( 'inspiry_property_tooltip_color', '#ffffff' ),
	array( 'inspiry_property_grid_card_address_color', '#1f79b8' ),
	array( 'inspiry_property_grid_card_address_hover_color', '#ea723d' ),
	array( 'inspiry_property_featured_label_color', '#ffffff' )
);

$property_style_options = realhomes_get_options( $property_styles_keys );

$theme_property_item_bg_color                   = $property_style_options['theme_property_item_bg_color'];
$theme_property_title_color                     = $property_style_options['theme_property_title_color'];
$theme_property_title_hover_color               = $property_style_options['theme_property_title_hover_color'];
$theme_property_price_text_color                = $property_style_options['theme_property_price_text_color'];
$theme_property_desc_text_color                 = $property_style_options['theme_property_desc_text_color'];
$theme_property_meta_text_color                 = $property_style_options['theme_property_meta_text_color'];
$inspiry_property_meta_heading_color            = $property_style_options['inspiry_property_meta_heading_color'];
$inspiry_property_meta_icon_color               = $property_style_options['inspiry_property_meta_icon_color'];
$inspiry_property_image_overlay                 = $property_style_options['inspiry_property_image_overlay'];
$inspiry_property_overlay_rgba                  = inspiry_hex_to_rgba( $inspiry_property_image_overlay, 0.7 );
$inspiry_property_featured_label_bg             = $property_style_options['inspiry_property_featured_label_bg'];
$featured_label_property                        = $is_rtl ? 'border-right-color' : 'border-left-color';
$inspiry_property_favorite_icon_color           = $property_style_options['inspiry_property_favorite_icon_color'];
$inspiry_property_favorite_icon_hover_color     = $property_style_options['inspiry_property_favorite_icon_hover_color'];
$realhomes_favorite_icon_placeholder_color      = $property_style_options['realhomes_favorite_icon_placeholder_color'];
$inspiry_property_compare_icon_color            = $property_style_options['inspiry_property_compare_icon_color'];
$inspiry_property_compare_icon_hover_color      = $property_style_options['inspiry_property_compare_icon_hover_color'];
$realhomes_compare_icon_placeholder_color       = $property_style_options['realhomes_compare_icon_placeholder_color'];
$inspiry_property_tooltip_bgcolor               = $property_style_options['inspiry_property_tooltip_bgcolor'];
$inspiry_property_tooltip_color                 = $property_style_options['inspiry_property_tooltip_color'];
$inspiry_property_grid_card_address_color       = $property_style_options['inspiry_property_grid_card_address_color'];
$inspiry_property_grid_card_address_hover_color = $property_style_options['inspiry_property_grid_card_address_hover_color'];
$inspiry_property_featured_label_color          = $property_style_options['inspiry_property_featured_label_color'];

return array(
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__details,
			.rh_list_card__wrap .rh_list_card__details_wrap, 
			.rh_list_card__wrap .rh_list_card__map_wrap,
			.rh_latest_properties_2 .rh_property_card_stylish_inner,
			.rh_latest_properties_2 .rh_detail_wrapper_2
		',
		'property' => 'background-color',
		'value'    => $theme_property_item_bg_color,
	),
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__details h3 a, 
			.rh_list_card__wrap .rh_list_card__map_wrap h3 a, 
			.rh_list_card__wrap .rh_list_card__details_wrap h3 a,
			h3.rh_heading_stylish a
		',
		'property' => 'color',
		'value'    => $theme_property_title_color,
	),
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__details h3 a:hover, 
			.rh_list_card__wrap .rh_list_card__map_wrap h3 a:hover, 
			.rh_list_card__wrap .rh_list_card__details_wrap h3 a:hover,
			h3.rh_heading_stylish a:hover
		',
		'property' => 'color',
		'value'    => $theme_property_title_hover_color,
	),
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__details .rh_prop_card__priceLabel .rh_prop_card__price,
			.rh_list_card__wrap .rh_list_card__map_details .rh_list_card__priceLabel .rh_list_card__price .price, 
			.rh_list_card__wrap .rh_list_card__priceLabel .rh_list_card__price .price,
			.rh_theme_card__priceLabel_sty .rh_theme_card__price_sty
		',
		'property' => 'color',
		'value'    => $theme_property_price_text_color,
	),
	array(
		'elements' => '
			.rh_list_card__wrap,
			.rh_list_card__wrap .rh_list_card__details_wrap .rh_list_card__excerpt, 
			.rh_prop_card .rh_prop_card__details .rh_prop_card__excerpt,
			.rh_prop_card .rh_prop_card__details,
			.rh_latest_properties_2,
			div.rh_added_sty
		',
		'property' => 'color',
		'value'    => $theme_property_desc_text_color,
	),
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__details .rh_prop_card__meta .figure,
			.rh_list_card__meta div .label, .rh_list_card__meta div .figure,
			.rh_prop_card_meta_theme_stylish .rh_prop_card__meta .figure
		',
		'property' => 'color',
		'value'    => $theme_property_meta_text_color,
	),
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__details .rh_prop_card__meta span.rh_meta_titles, 
			.rh_prop_card .rh_prop_card__details .rh_prop_card__priceLabel .rh_prop_card__status, 
			.rh_list_card__wrap .rh_list_card__map_details .rh_list_card__priceLabel .rh_list_card__price .status, 
			.rh_list_card__meta h4, .rh_list_card__wrap .rh_list_card__priceLabel .rh_list_card__price .status, 
			.rh_list_card__wrap .rh_list_card__priceLabel .rh_list_card__author span,
			.rh_theme_card__priceLabel_sty span.rh_theme_card__status_sty,
			div.rh_added_sty span,
			.rh_prop_card_meta_theme_stylish .rh_prop_card__meta .rh_meta_titles
		',
		'property' => 'color',
		'value'    => $inspiry_property_meta_heading_color,
	),
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__details .rh_prop_card__meta svg, .rh_list_card__meta div svg,
            .rh_prop_card_meta_theme_stylish .rh_prop_card__meta .rh_svg
        ',
		'property' => 'fill',
		'value'    => $inspiry_property_meta_icon_color,
	),
	array(
		'elements' => '.rh_overlay',
		'property' => 'background',
		'value'    => $inspiry_property_overlay_rgba,
	),
	array(
		'elements' => '
			.rh_prop_card .rh_prop_card__thumbnail .rh_overlay__contents a:hover,
			.rh_list_card__wrap .rh_list_card__thumbnail .rh_overlay__contents a:hover,
			.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_overlay__contents a:hover
		',
		'property' => 'color',
		'value'    => $inspiry_property_image_overlay,
	),
	array(
		'elements' => '.rh_label, .rh-featured-property-tag',
		'property' => 'background',
		'value'    => $inspiry_property_featured_label_bg,
	),
	array(
		'elements' => '.rh_label, .rh-featured-property-tag',
		'property' => 'color',
		'value'    => get_option( 'inspiry_property_featured_label_color', '#fff' ),
	),
	array(
		'elements' => '
			.rh_list_card__wrap .rh_list_card__thumbnail .rh_list_card__btns a svg path, 
			.rh_prop_card .rh_prop_card__thumbnail .rh_prop_card__btns a svg path,
			.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_list_card__btns a.add-to-favorite svg path
		',
		'property' => 'fill',
		'value'    => $inspiry_property_favorite_icon_color,
	),
	array(
		'elements' => '
			.rh_list_card__wrap .rh_list_card__thumbnail .rh_list_card__btns .favorite:hover svg path, 
			.rh_prop_card .rh_prop_card__thumbnail .rh_prop_card__btns .favorite:hover svg path,
			.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_list_card__btns a:hover.add-to-favorite svg path,
			.rh_fav_icon_box .favorite:hover svg path
		',
		'property' => 'fill',
		'value'    => $inspiry_property_favorite_icon_hover_color,
	),
	array(
		'elements' => '
			.rh_list_card__wrap .rh_list_card__thumbnail .rh_list_card__btns .favorite-placeholder svg path,
			.rh_prop_card .rh_prop_card__thumbnail .rh_prop_card__btns .favorite-placeholder svg path,
			.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_list_card__btns .favorite-placeholder svg path,
			.rh_fav_icon_box .favorite-placeholder svg path
		',
		'property' => 'fill',
		'value'    => $realhomes_favorite_icon_placeholder_color,
	),
	array(
		'elements' => '
			.rh_list_card__wrap .rh_list_card__thumbnail .rh_list_card__btns .rh_trigger_compare svg path,
			.rh_prop_card .rh_prop_card__thumbnail .rh_prop_card__btns .rh_trigger_compare svg path,
			.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_list_card__btns a.add-to-compare svg path
		',
		'property' => 'fill',
		'value'    => $inspiry_property_compare_icon_color,
	),
	array(
		'elements' => '
			.rh_list_card__wrap .rh_list_card__thumbnail .rh_list_card__btns .rh_trigger_compare:hover svg path,
			.rh_prop_card .rh_prop_card__thumbnail .rh_prop_card__btns .rh_trigger_compare:hover svg path,
			.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_list_card__btns a:hover.add-to-compare svg path,
			.rh_fav_icon_box .rh_trigger_compare:hover svg path
		',
		'property' => 'fill',
		'value'    => $inspiry_property_compare_icon_hover_color,
	),
	array(
		'elements' => '
			.rh_list_card__wrap .rh_list_card__thumbnail .rh_list_card__btns .compare-placeholder svg path,
			.rh_prop_card .rh_prop_card__thumbnail .rh_prop_card__btns .compare-placeholder svg path,
			.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_list_card__btns .compare-placeholder svg path,
			.rh_fav_icon_box .compare-placeholder svg path
		',
		'property' => 'fill',
		'value'    => $realhomes_compare_icon_placeholder_color,
	),
	array(
		'elements' => '[data-tooltip]:not([flow])::before, [data-tooltip][flow^=up]::before',
		'property' => 'border-top-color',
		'value'    => $inspiry_property_tooltip_bgcolor,
	),
	array(
		'elements' => '[data-tooltip]::after',
		'property' => 'background',
		'value'    => $inspiry_property_tooltip_bgcolor,
	),
	array(
		'elements' => '[data-tooltip]::after',
		'property' => 'color',
		'value'    => $inspiry_property_tooltip_color,
	),
	array(
		'elements' => '.rh_address_sty a',
		'property' => 'color',
		'value'    => $inspiry_property_grid_card_address_color,
	),
	array(
		'elements' => '.rh_address_sty a:hover',
		'property' => 'color',
		'value'    => $inspiry_property_grid_card_address_hover_color,
	),
	array(
		'elements' => '.rh_address_sty .rh_address_pin svg',
		'property' => 'fill',
		'value'    => $inspiry_property_grid_card_address_color,
	),
	array(
		'elements' => '.rh_address_sty a:hover svg',
		'property' => 'fill',
		'value'    => $inspiry_property_grid_card_address_hover_color,
	),
	array(
		'elements' => 'div.rh_label span',
		'property' => $featured_label_property,
		'value'    => $inspiry_property_featured_label_bg ? $inspiry_property_featured_label_bg . ' !important' : '',
	)
);