<?php
/**
 * Containing dynamic css slider style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */
global $dynamic_css;
$is_rtl                  = is_rtl();
$featured_label_property = $is_rtl ? 'border-right-color' : 'border-left-color';

$slider_styles_keys = array(
	'theme_slide_title_color',
	'theme_slide_title_hover_color',
	'theme_slide_desc_text_color',
	'theme_slide_price_color',
	'inspiry_slider_meta_heading_color',
	'inspiry_slider_meta_text_color',
	'inspiry_slider_meta_icon_color',
	'inspiry_slider_featured_label_bg'
);

$slider_style_options = realhomes_get_options( $slider_styles_keys );

$theme_slide_title_color           = $slider_style_options['theme_slide_title_color'];
$theme_slide_title_hover_color     = $slider_style_options['theme_slide_title_hover_color'];
$theme_slide_desc_text_color       = $slider_style_options['theme_slide_desc_text_color'];
$theme_slide_price_color           = $slider_style_options['theme_slide_price_color'];
$inspiry_slider_meta_heading_color = $slider_style_options['inspiry_slider_meta_heading_color'];
$inspiry_slider_meta_text_color    = $slider_style_options['inspiry_slider_meta_text_color'];
$inspiry_slider_meta_icon_color    = $slider_style_options['inspiry_slider_meta_icon_color'];
$inspiry_slider_featured_label_bg  = $slider_style_options['inspiry_slider_featured_label_bg'];
$slider_featured_label_property    = $is_rtl ? 'border-right-color' : 'border-left-color';

return array(
	array(
		'elements' => '.rh_slide__desc h3 .title, .rh_slide__desc h3',
		'property' => 'color',
		'value'    => $theme_slide_title_color,
	),
	array(
		'elements' => '.rh_slide__desc h3 .title:hover',
		'property' => 'color',
		'value'    => $theme_slide_title_hover_color,
	),
	array(
		'elements' => '.rh_slide__desc p',
		'property' => 'color',
		'value'    => $theme_slide_desc_text_color,
	),
	array(
		'elements' => '.rh_slide__desc .rh_slide_prop_price span',
		'property' => 'color',
		'value'    => $theme_slide_price_color,
	),
	array(
		'elements' => '
			.rh_slide__desc .rh_slide__meta_wrap .rh_slide__prop_meta span.rh_meta_titles,
			.rh_slide__desc .rh_slide_prop_price .rh_price_sym
		',
		'property' => 'color',
		'value'    => $inspiry_slider_meta_heading_color,
	),
	array(
		'elements' => '.rh_slide__desc .rh_slide__meta_wrap .rh_slide__prop_meta div span',
		'property' => 'color',
		'value'    => $inspiry_slider_meta_text_color,
	),
	array(
		'elements' => '.rh_slide__prop_meta .rh_svg',
		'property' => 'fill',
		'value'    => $inspiry_slider_meta_icon_color,
	),
	array(
		'elements' => '.rh_slide__desc .rh_label',
		'property' => 'background',
		'value'    => $inspiry_slider_featured_label_bg,
	),
	array(
		'elements' => '.rh_slide__desc .rh_label span',
		'property' => $slider_featured_label_property,
		'value'    => $inspiry_slider_featured_label_bg,
	),
	array(
		'elements' => '#rh_slider__home .rh_label span',
		'property' => $featured_label_property,
		'value'    => $inspiry_slider_featured_label_bg,
	)
);