<?php
/**
 * Property optional services of single property.
 *
 * @package    realhomes
 * @subpackage ultra
 */

if ( inspiry_is_rvr_enabled() && 'true' === get_option( 'realhomes_rvr_services', 'true' ) ) {
	global $post;

	// Property Optional Services
	$property_id      = get_the_ID();
	$rvr_included     = get_post_meta( $property_id, 'rvr_included', true );
	$rvr_not_included = get_post_meta( $property_id, 'rvr_not_included', true );
	if ( ! empty( $rvr_included ) || ! empty( $rvr_not_included ) ) {
		?>
        <div class="rh_property__features_wrap rh_rvr_optional_services_wrapper <?php realhomes_printable_section( 'rvr/optional-services' ); ?>">
            <h4 class="rh_property__heading"><?php
				$rvr_settings = get_option( 'rvr_settings' );
				echo ! empty( $rvr_settings['rvr_optional_services_label'] ) ? esc_html( $rvr_settings['rvr_optional_services_label'] ) : esc_html__( 'Optional Services', RH_TEXT_DOMAIN );
				?></h4>
            <div class="rh_rvr_optional_services">
				<?php
				if ( ! empty( $rvr_included ) ) {
					?>
                    <div class="rvr_optional_services_status">
                        <h5>
							<?php echo ! empty( $rvr_settings['rvr_optional_services_inc_label'] ) ? esc_html( $rvr_settings['rvr_optional_services_inc_label'] ) : esc_html__( 'Included', RH_TEXT_DOMAIN ); ?>
                        </h5>
                        <ul class="rh_property__features arrow-bullet-list no-link-list rh_rvr_optional_included">
							<?php
							foreach ( $rvr_included as $rvr_include ) {
								echo '<li class="rh_property__feature">';
								echo '<span class="rh_done_icon">';
								inspiry_safe_include_svg( '/icons/right-right.svg' );
								echo '</span>';
								echo esc_html( $rvr_include );
								echo '</li>';
							}
							?>
                        </ul>
                    </div>
					<?php
				}

				if ( ! empty( $rvr_not_included ) ) {
					?>
                    <div class="rvr_optional_services_status">
                        <h5>
							<?php echo ! empty( $rvr_settings['rvr_optional_services_not_inc_label'] ) ? esc_html( $rvr_settings['rvr_optional_services_not_inc_label'] ) : esc_html__( 'Not Included', RH_TEXT_DOMAIN ); ?>
                        </h5>
                        <ul class="rh_property__features arrow-bullet-list no-link-list icon-cross">
							<?php
							foreach ( $rvr_not_included as $rvr_not_include ) {
								echo '<li class="rh_property__feature">';
								echo '<span class="rh_done_icon rvr_not_available"> <i class="fas fa-times"></i>';
								echo '</span>';
								echo esc_html( $rvr_not_include );
								echo '</li>';
							}
							?>
                        </ul>
                    </div>
					<?php
				}
				?>
            </div>
        </div>
		<?php
	}
}