<?php
/**
 * Dynamic CSS File
 *
 * Dynamic css for handling customizer style settings.
 *
 * @since   4.0.0
 *
 * @package realhomes/ultra
 */
if ( ! function_exists( 'realhomes_generate_dynamic_css' ) ) {
	/**
	 * Generate custom CSS.
	 *
	 * @since  4.0.0
	 *
	 * @param $custom_css
	 *
	 * @return string
	 */
	function realhomes_generate_dynamic_css( $custom_css ) {

		// Logo print filters
		$core_options = realhomes_get_options( array(
			'realhomes_site_footer_bg_opacity_mobile',
			'realhomes_site_footer_bg_opacity'
		) );

		$footer_bg_opacity_mobile = (int)$core_options['realhomes_site_footer_bg_opacity_mobile'];
		$footer_bg_opacity        = (int)$core_options['realhomes_site_footer_bg_opacity'];

		// Add Footer background image opacity settings
		$opacity_valid_values = range( 1, 100 );
		if ( ! empty( $footer_bg_opacity_mobile ) ) {
			if ( in_array( $footer_bg_opacity_mobile, $opacity_valid_values ) ) {
				$custom_css .= '.site-footer-bg{ opacity:' . esc_html( $footer_bg_opacity_mobile / 100 ) . '}';
			}
		}

		if ( ! empty( $footer_bg_opacity ) ) {
			if ( in_array( $footer_bg_opacity, $opacity_valid_values ) ) {
				$custom_css .= '@media (min-width: 1024px) {.site-footer-bg{opacity: ' . esc_html( $footer_bg_opacity / 100 ) . ';}}';
			}
		}

		/** Skip the below css if custom colorscheme option is not selected. */
		if ( 'custom' !== get_option( 'realhomes_color_scheme', 'default' ) ) {
			return $custom_css;
		}

		$output_css = array();

		// Merging all dynamic css files returns
		$output_css = array_merge(
			require( get_template_directory() . '/assets/ultra/styles/css/dynamic-css/core.php' ),
			require( get_template_directory() . '/assets/ultra/styles/css/dynamic-css/header.php' ),
			require( get_template_directory() . '/assets/ultra/styles/css/dynamic-css/buttons.php' ),
			require( get_template_directory() . '/assets/ultra/styles/css/dynamic-css/gallery.php' ),
			require( get_template_directory() . '/assets/ultra/styles/css/dynamic-css/footer.php' ),
			require( get_template_directory() . '/assets/ultra/styles/css/dynamic-css/ratings.php' )
		);

		// Process styles
		$prop_count = count( $output_css );
		if ( $prop_count > 0 ) {
			foreach ( $output_css as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$value     = $css_unit['value'];
					$property  = $css_unit['property'];
					$selectors = $css_unit['elements'];

					// For multiple css properties
					if ( is_array( $property ) ) {
						if ( ! empty( $property ) ) {
							$properties = '';
							foreach ( $property as $prop ) {
								$properties .= sprintf( "%s: %s;\n", $prop, $value );
							}

							$custom_css .= strip_tags( $selectors . "{" . $properties . "}\n" );
						}
					} else {
						$custom_css .= strip_tags( $selectors . "{" . $property . ":" . $value . ";" . "}\n" );
					}
				}
			}
		}

		return $custom_css;
	}
}

add_filter( 'realhomes_ultra_custom_css', 'realhomes_generate_dynamic_css' );