<?php
/**
 * Containing dynamic css gallery style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage ultra
 */

$gallery_keys = array(
	'inspiry_gallery_hover_color',
	'inspiry_gallery_button_color',
	'inspiry_gallery_button_hover_color',
	'inspiry_gallery_button_bg_color',
	'inspiry_gallery_button_bg_hover_color'
);

$gallery_options = realhomes_get_options( $gallery_keys );

// Gallery
$gallery_css[] = array(
	'elements' => '.property-gallery-item-media-container:before',
	'property' => 'background-color',
	'value'    => $gallery_options[ 'inspiry_gallery_hover_color' ]
);
$gallery_css[] = array(
	'elements' => '.property-gallery-item-media-container a svg',
	'property' => 'fill',
	'value'    => $gallery_options[ 'inspiry_gallery_button_color' ]
);
$gallery_css[] = array(
	'elements' => '.property-gallery-item-media-container a:hover svg',
	'property' => 'fill',
	'value'    => $gallery_options[ 'inspiry_gallery_button_hover_color' ]
);
$gallery_css[] = array(
	'elements' => '.property-gallery-item-media-container a',
	'property' => 'background-color',
	'value'    => $gallery_options[ 'inspiry_gallery_button_bg_color' ]
);
$gallery_css[] = array(
	'elements' => '.property-gallery-item-media-container a:hover',
	'property' => 'background-color',
	'value'    => $gallery_options[ 'inspiry_gallery_button_bg_hover_color' ]
);

return $gallery_css;