<?php
/**
 * Containing dynamic css header style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage ultra
 */

$header_keys = array(
	'theme_menu_text_color',
	'theme_menu_hover_text_color',
	'theme_header_bg_color',
	'theme_logo_text_color',
	'theme_logo_text_hover_color',
	'theme_main_menu_text_color',
	'theme_main_menu_text_hover_color',
	'inspiry_main_menu_hover_bg',
	'theme_menu_bg_color',
	'theme_menu_hover_bg_color',
	'theme_header_social_icon_color',
	'theme_header_social_icon_color_hover',
	'realhomes_user_menu_separator',
	'theme_phone_text_color',
	'theme_phone_text_color_hover',
	'theme_responsive_submit_button_bg',
	'theme_responsive_submit_button_color',
	'theme_responsive_submit_button_bg_hover',
	'theme_responsive_submit_button_bg_hover',
	'theme_responsive_submit_button_color_hover',
	'theme_responsive_menu_icon_color',
	'theme_responsive_menu_bg_color',
	'theme_responsive_menu_bg_color',
	'realhomes_responsive_menu_container_bg_color',
	'realhomes_responsive_menu_item_hover_bg_color',
	'realhomes_responsive_menu_item_border_color',
	'realhomes_responsive_menu_item_border_color',
	'realhomes_responsive_menu_item_border_color',
	'theme_responsive_menu_text_color',
	'theme_responsive_menu_text_color',
	'theme_responsive_menu_text_hover_color',
	array( 'realhomes_ultra_tooltip_bgcolor', '#000' ),
	array( 'realhomes_ultra_tooltip_color', '#fff' ),
	'theme_modern_sticky_header_bg_color'
);

$header_options = realhomes_get_options( $header_keys );

$header_css[] = array(
	'elements' => '.rh-ultra-header-wrapper, .rh-responsive-header',
	'property' => 'background-color',
	'value'    => $header_options['theme_header_bg_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-logo a, .rh-responsive-header .rh-logo-wrapper a',
	'property' => 'color',
	'value'    => $header_options['theme_logo_text_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-logo a:hover, .rh-responsive-header .rh-logo-wrapper a:hover',
	'property' => 'color',
	'value'    => $header_options['theme_logo_text_hover_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-main-menu li a',
	'property' => 'color',
	'value'    => $header_options['theme_main_menu_text_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-main-menu li:hover > a, 
			.rh-ultra-main-menu li.current_page_item > a,
			.rh-ultra-main-menu li.current-menu-ancestor > a',
	'property' => 'color',
	'value'    => $header_options['theme_main_menu_text_hover_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-main-menu li:hover > a,
			.rh-ultra-main-menu li ul li:hover > a,
			.rh-ultra-main-menu li.current_page_item > a,
			.rh-ultra-main-menu li.current-menu-ancestor > a',
	'property' => 'background-color',
	'value'    => $header_options['inspiry_main_menu_hover_bg'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-main-menu li ul,
			.rh-ultra-menu-user-profile .rh-ultra-modal',
	'property' => 'background-color',
	'value'    => $header_options['theme_menu_bg_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-main-menu li ul li a,
			.rh-ultra-menu-user-profile .rh_user p,
			.rh-ultra-menu-user-profile .rh_user h3,
			.rh-ultra-menu-user-profile .rh_modal__dashboard > a',
	'property' => 'color',
	'value'    => $header_options['theme_menu_text_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-menu-user-profile .rh_modal__dashboard > a svg',
	'property' => 'fill',
	'value'    => $header_options['theme_menu_text_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-main-menu li ul li:hover a,
			.rh-ultra-menu-user-profile .rh_modal__dashboard > a:hover',
	'property' => 'color',
	'value'    => $header_options['theme_menu_hover_text_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-menu-user-profile .rh_modal__dashboard > a:hover svg',
	'property' => 'fill',
	'value'    => $header_options['theme_menu_hover_text_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-main-menu li ul li:hover a,
			.rh-ultra-menu-user-profile .rh_modal__dashboard > a:hover',
	'property' => 'background-color',
	'value'    => $header_options['theme_menu_hover_bg_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-header-social-list a',
	'property' => 'color',
	'value'    => $header_options['theme_header_social_icon_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-header-social-list a:hover',
	'property' => 'background-color',
	'value'    => $header_options['theme_header_social_icon_color_hover'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-social-contacts > div:not(:last-of-type, .rh-ultra-menu-user-profile):after',
	'property' => 'background-color',
	'value'    => $header_options['realhomes_user_menu_separator'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-user-phone a',
	'property' => 'color',
	'value'    => $header_options['theme_phone_text_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-user-phone a:hover',
	'property' => 'color',
	'value'    => $header_options['theme_phone_text_color_hover'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-submit a',
	'property' => 'border-color',
	'value'    => $header_options['theme_responsive_submit_button_bg'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-submit a',
	'property' => 'color',
	'value'    => $header_options['theme_responsive_submit_button_color'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-submit a:hover',
	'property' => 'background-color',
	'value'    => $header_options['theme_responsive_submit_button_bg_hover'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-submit a:hover',
	'property' => 'border-color',
	'value'    => $header_options['theme_responsive_submit_button_bg_hover'],
);
$header_css[] = array(
	'elements' => '.rh-ultra-submit a:hover',
	'property' => 'color',
	'value'    => $header_options['theme_responsive_submit_button_color_hover'],
);

// Responsive Header
$header_css[] = array(
	'elements' => '.rh-responsive-header .hc-nav-trigger span,
			.rh-responsive-header .hc-nav-trigger span::after,
			.rh-responsive-header .hc-nav-trigger span::before',
	'property' => 'background-color',
	'value'    => $header_options['theme_responsive_menu_icon_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-container,
			body .hc-offcanvas-nav .nav-wrapper,
			body .hc-offcanvas-nav ul',
	'property' => 'background-color',
	'value'    => $header_options['theme_responsive_menu_bg_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-container,
			body .hc-offcanvas-nav .nav-wrapper,
			body .hc-offcanvas-nav ul',
	'property' => 'background-color',
	'value'    => $header_options['theme_responsive_menu_bg_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-back a, 
			body .hc-offcanvas-nav .nav-content>.nav-close:first-child a, 
			body .hc-offcanvas-nav .nav-title+.nav-close a.has-label, 
			body .hc-offcanvas-nav li.nav-close a',
	'property' => array( 'background-color', 'border-top-color', 'border-bottom-color' ),
	'value'    => $header_options['realhomes_responsive_menu_container_bg_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-back a:hover, 
			body .hc-offcanvas-nav .nav-content>.nav-close:first-child a:hover,
			body .hc-offcanvas-nav .nav-title+.nav-close a.has-label:hover, 
			body .hc-offcanvas-nav li.nav-close a:hover,
			body .hc-offcanvas-nav:not(.touch-device) li:not(.nav-item-custom) a:not([disabled]):hover',
	'property' => array( 'background-color' ),
	'value'    => $header_options['realhomes_responsive_menu_item_hover_bg_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-wrapper>.nav-content>ul:first-of-type>li:first-child:not(.nav-back):not(.nav-close)>.nav-item-wrapper>.nav-item-link',
	'property' => 'border-top-color',
	'value'    => $header_options['realhomes_responsive_menu_item_border_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-back a, 
			body .hc-offcanvas-nav .nav-item-link, 
			body .hc-offcanvas-nav li.nav-close a',
	'property' => 'border-bottom-color',
	'value'    => $header_options['realhomes_responsive_menu_item_border_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav a.nav-next',
	'property' => array( 'border-left-color', 'border-bottom-color' ),
	'value'    => $header_options['realhomes_responsive_menu_item_border_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-back a,
			 body .hc-offcanvas-nav .nav-item-link,
			 body .hc-offcanvas-nav li.nav-close a,
			 body .hc-offcanvas-nav .nav-content>.nav-close a,
			 body .hc-offcanvas-nav .nav-content > h2',
	'property' => 'color',
	'value'    => $header_options['theme_responsive_menu_text_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-close-button span::after, 
			body .hc-offcanvas-nav .nav-close-button span::before,
			body .hc-offcanvas-nav .nav-back span::before,
			body .hc-offcanvas-nav .nav-next span::before',
	'property' => 'border-color',
	'value'    => $header_options['theme_responsive_menu_text_color'],
);
$header_css[] = array(
	'elements' => 'body .hc-offcanvas-nav .nav-back a:hover,
			 body .hc-offcanvas-nav .nav-item-link:hover,
			 body .hc-offcanvas-nav li.nav-close a:hover',
	'property' => 'color',
	'value'    => $header_options['theme_responsive_menu_text_hover_color'],
);
$header_css[] = array(
	'elements' => 'div.rh-ultra-tooltip, div.rh-ultra-tooltip .arrow::after',
	'property' => 'background',
	'value'    => $header_options['realhomes_ultra_tooltip_bgcolor'] . ' !important',
);
$header_css[] = array(
	'elements' => 'div.rh-ultra-tooltip, div.rh-ultra-tooltip .arrow::after',
	'property' => 'color',
	'value'    => $header_options['realhomes_ultra_tooltip_color'] . ' !important',
);

// Sticky Header
$header_css[] = array(
	'elements' => '.rh-sticky-header.sticked',
	'property' => 'background-color',
	'value'    => $header_options['theme_modern_sticky_header_bg_color'],
);

return $header_css;