<?php
/**
 * Containing dynamic css rating stars style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage ultra
 */

$rating_star_keys = array(
	'realhomes_rating_stars_color',
	'realhomes_unrated_stars_color',
	'realhomes_rating_percentage_inactive_color',
	'realhomes_rating_percentage_active_color'
);

$rating_star_options = realhomes_get_options( $rating_star_keys );

$rating_star_css[] = array(
	'elements' => '
		.rvr_card_info_wrap .rh-ultra-rvr-rating .rating-stars i.rated,
		.rhea_rvr_ratings_wrapper_stylish .rating-stars i.rated,
		.rating-stars i.rated,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-selected,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-selected:after,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-active,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-active:after
	',
	'property' => 'color',
	'value'    => $rating_star_options[ 'realhomes_rating_stars_color' ]
);
$rating_star_css[] = array(
	'elements' => '
		.rvr_card_info_wrap .rh-ultra-rvr-rating .rating-stars i,
		.design_ultra .rhea_rvr_ratings_wrapper_stylish .rating-stars i,
		.rating-stars i,
		.rating-box .br-theme-fontawesome-stars .br-widget a,
		.rating-box .br-theme-fontawesome-stars .br-widget a:after
	',
	'property' => 'color',
	'value'    => $rating_star_options[ 'realhomes_unrated_stars_color' ]
);
$rating_star_css[] = array(
	'elements' => '.design_ultra .inspiry_stars_avg_rating .inspiry_rating_percentage .inspiry_rating_line',
	'property' => 'background-color',
	'value'    => $rating_star_options[ 'realhomes_rating_percentage_inactive_color' ]
);
$rating_star_css[] = array(
	'elements' => '.design_ultra .inspiry_stars_avg_rating .inspiry_rating_percentage .inspiry_rating_line .inspiry_rating_line_inner',
	'property' => 'background-color',
	'value'    => $rating_star_options[ 'realhomes_rating_percentage_active_color' ]
);

return $rating_star_css;