<?php
/**
 * Containing dynamic css currency switcher style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage common
 */

$currency_switcher_styles_keys = array(
	'theme_currency_switcher_background',
	'theme_currency_switcher_selected_text',
	'theme_currency_switcher_background_open',
	'theme_currency_switcher_text_open',
	'theme_currency_switcher_background_dropdown',
	'theme_currency_switcher_text_dropdown',
	'theme_currency_switcher_background_hover_dropdown',
	'theme_currency_switcher_text_hover_dropdown'
);

$currency_switcher_style_options = realhomes_get_options( $currency_switcher_styles_keys );

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher-form',
	'property' => 'background',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_background' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher #selected-currency',
	'property' => 'color',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_selected_text' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher.open #selected-currency',
	'property' => 'background',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_background_open' ],
);

$currency_switcher_array[] = array(
	'elements' => '.rh_currency_open_full #currency-switcher #selected-currency:hover',
	'property' => 'background',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_background_open' ],
);

$currency_switcher_array[] = array(
	'elements' => '.rh_currency_open_full #currency-switcher #selected-currency:hover',
	'property' => 'color',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_text_open' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher.open #selected-currency',
	'property' => 'color',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_text_open' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher-list li',
	'property' => 'background',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_background_dropdown' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher-list li',
	'property' => 'color',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_text_dropdown' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher-list li:hover',
	'property' => 'background',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_background_hover_dropdown' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher-list li:hover',
	'property' => 'color',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_text_hover_dropdown' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher ::-webkit-scrollbar',
	'property' => 'background-color',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_background_dropdown' ],
);

$currency_switcher_array[] = array(
	'elements' => '#currency-switcher ::-webkit-scrollbar-thumb',
	'property' => 'background-color',
	'value'    => $currency_switcher_style_options[ 'theme_currency_switcher_background_hover_dropdown' ],
);

return $currency_switcher_array;