<?php
/**
 * This file is responsible for deals list page.
 *
 * @since 4.4.5
 */

$page_type = 'deal';

// Prepare args and fetch items from the CRM class
$args           = Realhomes_Crm_Helper::prepare_listing_page_args( $page_type );
$deals          = Realhomes_Crm_Deals::fetch_deals( [ 'number' => $args['items_per_page'], 'keyword' => $args['searched_word'], 'offset' => $args['offset'] ] );
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );

if ( ! empty( $deals ) || isset( $_GET['posts_search'] ) ) {
	?>
	<!--Deals Stats-->
	<div id="rh-crm-deals-stats" class="flex justify-evenly item-center shadow-sm rounded-md py-4 bg-white my-10 divide-x">
		<canvas class="max-w-[70px]" id="rh-crm-deals-chart"></canvas>
	</div>

	<!--Deals Header-->
	<?php
	Realhomes_Crm_Helper::listing_header( $page_type, $args['searched_word'] );
	if ( $deals ) {
		?>
		<!--Deal Items-->
		<div id="rh-crm-<?php echo Realhomes_Crm_Helper::get_page_type_plurals()[$page_type]; ?>-items" class="py-4 sm:px-6 lg:px-8 bg-white min-w-full max-w-full overflow-x-auto overflow-y-hidden">
			<table class="min-w-full divide-y divide-gray-200">
				<thead>
				<tr>
					<th scope="col" class="py-6 pl-4 pr-3 w-[40px]">
						<?php Realhomes_Crm_Helper::items_select_checkbox(); ?>
					</th>
					<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900 sm:pl-0"><?php esc_html_e( 'ID', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Title', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Lead Contact', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Assigned Agent', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Last Step', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Next Step', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Stage', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Probability', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Estimated Value', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0">
						<span class="sr-only"><?php esc_html_e( 'Actions', RH_TEXT_DOMAIN ); ?></span>
					</th>
				</tr>
				</thead>
				<tbody class="divide-y divide-gray-200">
				<?php
				$stages_labels = Realhomes_Crm_Helper::get_setting( 'deal_stages', explode: true );
				$stages_colors = Realhomes_Crm_Helper::get_setting( 'deal_stages_colors', explode: true );
				$deal_stages   = array_combine( $stages_labels, $stages_colors );

				// Loop through each deal and output data in table rows
				$last_key = array_key_last( $deals );
				foreach ( $deals as $key => $deal ) {
					$lead_name = $lead_phone = $lead_email = $fallback_value;
					if ( $deal->lead_id ) {
						$lead       = Realhomes_Crm_Leads::fetch_lead( $deal->lead_id );
						$lead_name  = $lead->display_name ?? $fallback_value;
						$lead_phone = $lead->mobile ?? $fallback_value;
						$lead_email = $lead->email ?? $fallback_value;
					}

					?>
					<tr class="rh-crm-item-wrapper hover:bg-gray-50 transition duration-200">
						<td class="whitespace-nowrap py-8 pl-4 pr-3 text-sm">
							<?php Realhomes_Crm_Helper::item_select_checkbox( $page_type, $deal->id ); ?>
						</td>
						<td class="whitespace-nowrap py-8 pl-4 pr-3 text-sm sm:pl-0"><?php echo esc_html( $deal->id ); ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-700"><?php echo ! empty( $deal->title ) ? esc_html( wp_trim_words( $deal->title, 10 ) ) : $fallback_value; ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<div class="text-gray-500"><?php echo ! empty( $lead_name ) ? esc_html( $lead_name ) : $fallback_value; ?></div>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							$agent_name = get_the_title( $deal->agent_id );
							echo ! empty( $agent_name ) ? esc_html( $agent_name ) : $fallback_value;
							?>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<div class="text-gray-500"><?php echo ! empty( $deal->last_step ) ? esc_html( $deal->last_step ) : $fallback_value; ?></div>
							<span class="mt-4 inline-block text-gray-500 bg-gray-100 px-2 rounded text-xs"><?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $deal->last_step_date ) ); ?></span>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<div class="text-gray-500"><?php echo ! empty( $deal->next_step ) ? esc_html( $deal->next_step ) : $fallback_value; ?></div>
							<span class="mt-4 inline-block text-gray-500 bg-gray-100 px-2 rounded text-xs"><?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $deal->next_step_date ) ); ?></span>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500"><?php echo in_array( $deal->deal_stage,
								array_keys( $deal_stages ) ) ? '<span class="text-white text-xs inline-block min-w-[80px] text-center py-1 px-2 rounded" style="background-color:' . $deal_stages[ $deal->deal_stage ] . ';">' . esc_html( $deal->deal_stage ) . '</span>' : $fallback_value; ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500"><?php echo ! empty( $deal->probability ) ? esc_html( $deal->probability ) : $fallback_value; ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500"><?php echo ! empty( $deal->estimated_value ) ? ere_format_amount( $deal->estimated_value ) : $fallback_value; ?></td>
						<td class="whitespace-nowrap py-5 pl-3 pr-4 text-sm sm:pr-0">
							<?php Realhomes_Crm_Helper::the_item_actions( $deal->id, $page_type, $key === $last_key ); ?>
						</td>
					</tr>
				<?php } ?>

				</tbody>
			</table>
		</div>

		<!--Deals Footer & Action Buttons-->
		<?php
		Realhomes_Crm_Helper::listing_footer( $args['offset'], $args['current_page'], $args['items_per_page'], $args['total_items'], $page_type );
		Realhomes_Crm_Helper::selected_items_action_buttons( $page_type );
	} else {
		Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No deals found matching your query :(', RH_TEXT_DOMAIN ) );
	}
} else {
	Realhomes_Crm_Helper::no_item_found_note( $page_type );
}
?>