<?php
/**
 * This file contains the add/edit form for Deals in Realhomes CRM.
 *
 * @since 4.4.5
 */
use Realhomes\CRM\Helpers\Drawer_Helper;

$is_edit = ( $args['item_action'] === 'edit' );

$item_id        = $args['item_id'];
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );
$deal           = Realhomes_Crm_Deals::fetch_deal( $item_id );

Drawer_Helper::header( $args['item_action'], $deal, $args['item_type'] );
?>

    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'General Details', RH_TEXT_DOMAIN ); ?></h2>
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

            <div class="sm:col-span-6 sm:col-start-1">
                <label for="title" class="block text-sm/6 font-medium text-gray-900">
	                <i class="text-red-500 not-italic">*</i>
	                <?php esc_html_e( 'Title', RH_TEXT_DOMAIN ); ?>
                </label>
                <div class="mt-2">
                    <input type="text" name="title" id="title" autocomplete="title" value="<?php echo esc_attr( $is_edit ? $deal->title : '' ); ?>" class="rh-crm-input" required>
                </div>
            </div>

            <div class="sm:col-span-3">
                <label for="probability" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Probability', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
					<?php
					$probabilities = Realhomes_Crm_Helper::get_setting( 'deal_probabilities', explode: true ); ?>
                    <select id="probability" name="probability" autocomplete="probability" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $probabilities as $probability ) {
							echo '<option value="' . esc_attr( $probability ) . '" ' . selected( $probability, $is_edit ? $deal->probability : '' ) . '>' . esc_html( $probability ) . '</option>';
						}
						?>
                    </select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-3">
                <label for="estimated-value" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Estimated Value', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="estimated-value" id="estimated-value" autocomplete="estimated-value" min="0" value="<?php
					echo esc_attr( $is_edit ? $deal->estimated_value : '' ); ?>" class="rh-crm-input">
                </div>
            </div>

            <div class="sm:col-span-6">
                <label for="description" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Description', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <textarea name="description" id="description" autocomplete="description" class="rh-crm-input"><?php
						echo esc_attr( $is_edit ? $deal->description : '' ); ?></textarea>
                </div>
            </div>

        </div>
    </div>

    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'Assignment and Stage', RH_TEXT_DOMAIN ); ?></h2>
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

            <div class="sm:col-span-2">
                <label for="lead-id" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Lead Contact', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
					<?php
					$leads = Realhomes_Crm_Leads::fetch_leads( null, array( 'id', 'display_name' ) ); ?>
                    <select id="lead-id" name="lead-id" autocomplete="lead-id" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $leads as $lead ) {
							echo '<option value="' . esc_attr( $lead->id ) . '" ' . selected( $lead->id, $is_edit ? $deal->lead_id : '' ) . '>' . esc_html( $lead->display_name ?? $lead->first_name . ' ' . $lead->last_name ) . '</option>';
						}
						?>
                    </select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-2">
                <label for="agent-id" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Assigned Agent', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
					<?php
					$agents = get_posts( [ 'post_type' => 'agent', 'posts_per_page' => - 1 ] ); ?>
                    <select id="agent-id" name="agent-id" autocomplete="agent-id" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $agents as $agent ) {
							echo '<option value="' . esc_attr( $agent->ID ) . '" ' . selected( $agent->ID, $is_edit ? $deal->agent_id : '' ) . '>' . esc_html( $agent->post_title ) . '</option>';
						}
						?>
                    </select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-2">
                <label for="deal-stage" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Stage', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
					<?php
					$deal_stages = Realhomes_Crm_Helper::get_setting( 'deal_stages', explode: true ); ?>
                    <select id="deal-stage" name="deal-stage" autocomplete="deal-stage" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $deal_stages as $deal_stage ) {
							echo '<option value="' . esc_attr( $deal_stage ) . '" ' . selected( $deal_stage, $is_edit ? $deal->deal_stage : '' ) . '>' . esc_html( $deal_stage ) . '</option>';
						}
						?>
                    </select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

        </div>
    </div>

    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'Steps Information', RH_TEXT_DOMAIN ); ?></h2>
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">
            <div class="sm:col-span-3">
                <label for="last-step" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Last Step', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
					<?php
					$last_steps = Realhomes_Crm_Helper::get_setting( 'deal_last_steps', explode: true ); ?>
                    <select id="last-step" name="last-step" autocomplete="last-step" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $last_steps as $last_step ) {
							echo '<option value="' . esc_attr( $last_step ) . '" ' . selected( $last_step, $is_edit ? $deal->last_step : '' ) . '>' . esc_html( $last_step ) . '</option>';
						}
						?>
                    </select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-3">
                <label for="last-step-date" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Last Step Date', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="text" name="last-step-date" id="last-step-date" value="<?php echo esc_attr( $is_edit ? $deal->last_step_date : '' ); ?>" class="rh-crm-date-picker rh-crm-input">
                </div>
            </div>

            <div class="sm:col-span-3">
                <label for="next-step" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Next Step', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
					<?php
					$next_steps = Realhomes_Crm_Helper::get_setting( 'deal_next_steps', explode: true ); ?>
                    <select id="next-step" name="next-step" autocomplete="next-step" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $next_steps as $next_step ) {
							echo '<option value="' . esc_attr( $next_step ) . '" ' . selected( $next_step, $is_edit ? $deal->next_step : '' ) . '>' . esc_html( $next_step ) . '</option>';
						}
						?>
                    </select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-3">
                <label for="next-step-date" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Next Step Date', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="text" name="next-step-date" id="next-step-date" value="<?php echo esc_attr( $is_edit ? $deal->next_step_date : '' ); ?>" class="rh-crm-date-picker rh-crm-input">
                </div>
            </div>

        </div>
    </div>

<?php
Drawer_Helper::footer( $args['item_action'], $deal, $args['item_type'] ); ?>