<?php
/**
 * This file contains the detail drawer for a deal in Realhomes CRM.
 *
 * @since 4.4.5
 */
use RealHomes\CRM\Helpers\Drawer_Helper;

$item_id        = $args['item_id'];
$item_type      = $args['item_type'];
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );
$deal           = Realhomes_Crm_Deals::fetch_deal( $item_id );

// Prepare lead details
$lead_name = $lead_phone = $lead_email = $fallback_value;
if ( $deal->lead_id ) {
	$lead       = Realhomes_Crm_Leads::fetch_lead( $deal->lead_id );
	$lead_name  = $lead->display_name ?? $fallback_value;
	$lead_phone = $lead->mobile ?? $fallback_value;
	$lead_email = $lead->email ?? $fallback_value;
}

// Prepare agent details
$agent_name = $agent_phone = $agent_email = $fallback_value;
if ( $deal->agent_id ) {
	$agent_name  = get_the_title( $deal->agent_id );
	$agent_phone = get_post_meta( $deal->agent_id, 'REAL_HOMES_mobile_number', true ) ?? $fallback_value;
	$agent_email = get_post_meta( $deal->agent_id, 'REAL_HOMES_agent_email', true ) ?? $fallback_value;
}

Drawer_Helper::header( $args['item_action'], $deal, $args['item_type'] );
?>

	<div class="relative mt-6 flex-1 px-4 sm:p-8">

		<!-- Deals complete details -->
		<dl>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'stage', 'size-6 mr-4' );
					esc_html_e( 'Stage', RH_TEXT_DOMAIN );
					?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
                    <span class="px-4 py-1 bg-green-100 rounded text-green-700">
                        <span class="size-2 bg-green-700 rounded-full mr-4 align-middle inline-block"></span>
                        <?php
                        echo esc_html( $deal->deal_stage ); ?>
                    </span>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'clock', 'size-8 mr-2' );
					esc_html_e( 'Created At', RH_TEXT_DOMAIN );
					?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
					echo Realhomes_Crm_Helper::human_readable_date( $deal->created_at ); ?></dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'last_updated', 'size-6 mr-4' );
					esc_html_e( 'Last Updated', RH_TEXT_DOMAIN ); ?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
					echo Realhomes_Crm_Helper::human_readable_date( $deal->updated_at ); ?></dd>
			</div>
		</dl>

		<div class="border-t border-gray-100 text-sm mb-16">

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'General Details', RH_TEXT_DOMAIN ); ?></h3>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Title', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $deal->title ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Probability', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $deal->probability ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Estimated Value', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo ere_format_amount( $deal->estimated_value ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex"><?php
						esc_html_e( 'Description', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm/8 text-gray-700 sm:mt-0"><?php
						echo empty( $deal->description ) ? $fallback_value : esc_html( $deal->description ); ?></dd>
				</div>
			</dl>

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Lead Contact', RH_TEXT_DOMAIN ); ?></h3>

				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Name', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $lead_name ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Emails', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $lead_email ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Phone', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $lead_phone ); ?></dd>
				</div>
			</dl>

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Assigned Agent', RH_TEXT_DOMAIN ); ?></h3>

				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Name', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $agent_name ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Emails', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $agent_email ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Phone', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $agent_phone ); ?></dd>
				</div>
			</dl>

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Steps Information', RH_TEXT_DOMAIN ); ?></h3>

				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Last Step', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $deal->last_step ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Last Step Date', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
						<span class="mt-4 inline-block text-gray-500 bg-gray-100 px-2 rounded text-xs"><?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $deal->last_step_date ) ); ?></span>
					</dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Next Step', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( $deal->next_step ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Next Step Date', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
						<span class="mt-4 inline-block text-gray-500 bg-gray-100 px-2 rounded text-xs"><?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $deal->next_step_date ) ); ?></span>
					</dd>
				</div>
			</dl>

		</div>

		<!--Tabbed Information-->
		<div class="realhomes-crm-tabs-wrapper">
			<div class="rh-crm-tabs-links">
				<div class="border-t border-b border-gray-200">
					<nav class="-mb-px flex space-x-8" aria-label="Tabs">
						<a id="rh-crm-notes-tab-link" data-tab="tab1" class="rh-crm-tab-link active">
							<?php
							esc_html_e( 'Notes', RH_TEXT_DOMAIN ); ?>
							<span>
	                            <?php
	                            $notes = Realhomes_Crm_Notes::fetch_notes( $item_id, $item_type );
	                            echo count( $notes );
	                            ?>
	                        </span>
						</a>
					</nav>
				</div>
			</div><!-- Tabs Links -->

			<div class="rh-crm-tabs-contents">
				<div class="rh-crm-tab-content py-10" id="tab1">
					<?php
					get_template_part( 'common/dashboard/crm/common/notes', null, array( 'item_id' => $item_id, 'item_type' => $item_type, 'notes' => $notes ) ) ?>
				</div>
			</div><!-- CRM Tabs Contents -->

		</div><!-- CRM Tabs -->

	</div>

<?php
Drawer_Helper::footer( $args['item_action'] );