<?php
/**
 * This file contains the fields mapping import form for the Realhomes CRM import page.
 *
 * @since 4.4.5
 */

$import_type = Realhomes_Crm_Helper::get_import_type();
?>
	<div id="rh-crm-import-result" class="hidden">
		<div class="mb-10">
			<h3 class="text-lg font-[500] text-gray-700 mb-2"><?php esc_html_e( 'Import Done!', RH_TEXT_DOMAIN ); ?></h3>
			<p class="text-md text-gray-600 mb-0"><?php esc_html_e( 'Below are the details of the import result.', RH_TEXT_DOMAIN ); ?></p>
		</div>
		<div class="bg-gray-50 border border-gray-100 rounded-lg p-6 mb-10 leading-10 text-md divide-x divide-solid text-center grid grid-cols-3">
			<div class="flex flex-col col-span-1">
				<strong id="rh-crm-imported-result" class="text-lg text-green-600">0</strong>
				<span><?php esc_html_e( 'Imported' . ' ' . ucfirst( $import_type ), RH_TEXT_DOMAIN ); ?></span>
			</div>
			<div class="flex flex-col col-span-1">
				<strong id="rh-crm-duplicate-result" class="text-lg text-yellow-500">0</strong>
				<span><?php esc_html_e( 'Duplicate' . ' ' . ucfirst( $import_type ), RH_TEXT_DOMAIN ); ?></span>
			</div>
			<div class="flex flex-col col-span-1">
				<strong id="rh-crm-skipped-result" class="text-lg text-red-600">0</strong>
				<span><?php esc_html_e( 'Skipped' . ' ' . ucfirst( $import_type ), RH_TEXT_DOMAIN ); ?></span>
			</div>
		</div>
	</div>
<?php

$file_name  = sanitize_file_name( $_GET['fetch_file'] );
$upload_dir = wp_upload_dir();
$file_path  = trailingslashit( $upload_dir['basedir'] ) . 'realhomes-crm/csv-import/' . $file_name;

if ( ! empty( $file_name ) && file_exists( $file_path ) ) {
	$file       = fopen( $file_path, 'r' );
	$csv_fields = fgetcsv( $file, 0, ',', '"', '\\' ); // Fetch CSV header fields
	fclose( $file );

	$importable_fields = match ( $import_type ) {
		'inquiries' => [
			'inquiry_status',
			'inquiry_type',
			'min-beds',
			'max-beds',
			'min-baths',
			'max-baths',
			'min-garage',
			'max-garage',
			'min-area',
			'max-area',
			'min-price',
			'max-price',
			'property-status',
			'property-type',
			'property-city',
			'property-address',
			'property-zipcode',
			'message',
			'private_note'
		],
		'deals'     => [ 'title', 'description', 'deal_stage', 'probability', 'last_step', 'last_step_date', 'next_step', 'next_step_date', 'estimated_value' ],
		'tasks'     => [ 'title', 'description', 'priority', 'status', 'type', 'due_date' ],
		default     => [ 'name_prefix', 'display_name', 'first_name', 'last_name', 'email', 'mobile', 'home_phone', 'work_phone', 'address', 'city', 'state', 'country', 'zipcode', 'type', 'status', 'source', 'source_url', 'x_url', 'facebook_url', 'linkedin_url', 'private_note', 'message' ],
	};
	?>
	<div id="rh-crm-fields-mapping-wrapper">
		<div class="mb-10">
			<h3 class="text-lg font-[500] text-gray-700 mb-2"><?php esc_html_e( 'Map Properties', RH_TEXT_DOMAIN ); ?></h3>
			<p class="text-md text-gray-600 mb-0 leading-8"><?php esc_html_e( 'Ensure left side columns are matched correctly to the right side properties of your file:', RH_TEXT_DOMAIN ); ?> <strong><?php echo esc_html( $file_name ); ?></strong></p>
		</div>
		<form id="rh-crm-fields-mapping-form">
			<div class="grid grid-cols-8 gap-8 mb-12 text-gray-900">
				<div class="col-span-4"><?php echo esc_html__( 'Properties in', RH_TEXT_DOMAIN ) . ' ' . $import_type; ?></div>
				<div class="col-span-4"><?php esc_html_e( 'Columns in your file', RH_TEXT_DOMAIN ); ?></div>
				<?php
				foreach ( $importable_fields as $importable_field ) { ?>
					<div class="col-span-4 flex p-4 rounded-md bg-gray-100 border border-gray-200 items-center text-gray-700">
						<?php Realhomes_Crm_SVG::the_svg( 'fields', 'size-6 mr-4' ); ?>
						<span><?php echo esc_html( Realhomes_Crm_Helper::format_label( $importable_field ) ); ?></span>
					</div>
					<div class="col-span-4">
						<div class="mt-2 grid grid-cols-1">
							<select name="<?php echo esc_html( 'fields_mapping[' . esc_attr( $importable_field ) . ']' ) ?>" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">

								<option value=""><?php esc_html_e( 'Select CSV Field', RH_TEXT_DOMAIN ); ?></option>
								<?php
								if ( is_array( $csv_fields ) ) {
									foreach ( $csv_fields as $csv_field ) {
										?>
										<option value="<?php echo esc_attr( $csv_field ); ?>"><?php echo esc_html( $csv_field ); ?></option><?php
									}
								}
								?>
							</select>
							<?php Realhomes_Crm_SVG::the_svg( 'chevron', 'size-5' ); ?>
						</div>
					</div>
				<?php } ?>
			</div>

			<input type="hidden" id="rh-crm-csv-file-name" name="csv_file_name" value="<?php echo esc_attr( $file_name ) ?>">
			<input type="hidden" id="rh-crm-import-type" name="import_type" value="<?php echo esc_attr( $import_type ) ?>">
			<div class="flex justify-between items-center border-t border-gray-200 pt-10">
				<a href="<?php echo esc_url( realhomes_get_dashboard_page_url( 'properties-crm' ) . '&submodule=crm/' ) . Realhomes_Crm_Helper::get_import_type(); ?>"><?php esc_html_e( 'Cancel', RH_TEXT_DOMAIN ); ?></a>

				<button id="rh-crm-import-csv-file" class="w-full max-w-[110px] inline-flex items-center gap-x-1.5 rounded-md bg-[var(--dashboard-primary-color)] px-6 py-3 text-sm text-white shadow-sm hover:bg-slate-700 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-teal-600">
					<?php
					Realhomes_Crm_SVG::the_svg( 'loader', 'size-5 mr-2 hidden' );
					Realhomes_Crm_SVG::the_svg( 'import', 'fill-white size-5 mr-2' );
					?><?php esc_html_e( 'Import', RH_TEXT_DOMAIN ) ?>
				</button>
			</div>

		</form>
	</div>
	<?php
} else {
	?>
	<div class="border-l-4 border-yellow-400 bg-yellow-50 p-4 mb-8">
		<div class="flex">
			<div class="shrink-0">
				<?php RealHomes_Crm_SVG::the_svg( 'warning', 'size-7 text-yellow-600' ); ?>
			</div>
			<div class="ml-3">
				<p class="text-md  text-yellow-700 mb-0">
					<?php echo sprintf( "The file %s doesn't exist physically. Please upload again.", '<strong class="font-medium text-yellow-700 underline hover:text-yellow-600">' . esc_html( $file_name ) . '</strong>' ); ?>
				</p>
			</div>
		</div>
	</div>
	<?php
	get_template_part( 'common/dashboard/crm/import/csv-file-upload-form' );
}
?>