<?php
/**
 * This file contains the import type tabs for the Realhomes CRM import page.
 *
 * @since 4.4.5
 */
$import_type     = Realhomes_Crm_Helper::get_import_type();
$default_classes = 'text-gray-500 hover:bg-gray-50 hover:text-gray-700 cursor-pointer';
$active_classes  = 'text-gray-900 hover:text-gray-900';
$import_url      = realhomes_get_dashboard_page_url( 'properties-crm' ) . '&submodule=crm/import&import=';
?>
<nav class="isolate flex divide-x divide-gray-200 rounded-t-md" aria-label="Tabs">
    <a href="<?php echo esc_url( $import_url ) . 'leads' ?>" class="group relative min-w-0 flex-1 overflow-hidden rounded-tl-lg bg-white px-4 py-4 text-center text-sm font-medium focus:z-10 <?php echo ( 'leads' === $import_type ) ? $active_classes : $default_classes; ?>">
        <span><?php esc_html_e('Leads', RH_TEXT_DOMAIN); ?></span>
        <span aria-hidden="true" class="absolute inset-x-0 bottom-0 h-0.5 <?php echo ( 'leads' === $import_type ) ? 'bg-[var(--dashboard-primary-color)]' : 'bg-gray-200'; ?>"></span>
    </a>
    <a href="<?php echo esc_url( $import_url ) . 'inquiries' ?>" class="group relative min-w-0 flex-1 overflow-hidden bg-white px-4 py-4 text-center text-sm font-medium focus:z-10 <?php echo ( 'inquiries' === $import_type ) ? $active_classes : $default_classes; ?>">
        <span><?php esc_html_e('Inquiries', RH_TEXT_DOMAIN); ?></span>
        <span aria-hidden="true" class="absolute inset-x-0 bottom-0 h-0.5 <?php echo ( 'inquiries' === $import_type ) ? 'bg-[var(--dashboard-primary-color)]' : 'bg-gray-200'; ?>"></span>
    </a>
    <a href="<?php echo esc_url( $import_url ) . 'deals' ?>" class="group relative min-w-0 flex-1 overflow-hidden bg-white px-4 py-4 text-center text-sm font-medium focus:z-10 <?php echo ( 'deals' === $import_type ) ? $active_classes : $default_classes; ?>" aria-current="page">
        <span><?php esc_html_e('Deals', RH_TEXT_DOMAIN); ?></span>
        <span aria-hidden="true" class="absolute inset-x-0 bottom-0 h-0.5 <?php echo ( 'deals' === $import_type ) ? 'bg-[var(--dashboard-primary-color)]' : 'bg-gray-200'; ?>"></span>
    </a>
    <a href="<?php echo esc_url( $import_url ) . 'tasks' ?>" class="group relative min-w-0 flex-1 overflow-hidden rounded-tr-md bg-white px-4 py-4 text-center text-sm font-medium focus:z-10 <?php echo ( 'tasks' === $import_type ) ? $active_classes : $default_classes; ?>">
        <span><?php esc_html_e('Tasks', RH_TEXT_DOMAIN); ?></span>
        <span aria-hidden="true" class="absolute inset-x-0 bottom-0 h-0.5 <?php echo ( 'tasks' === $import_type ) ? 'bg-[var(--dashboard-primary-color)]' : 'bg-gray-200'; ?>"></span>
    </a>
</nav>