<?php
/**
 * This file is responsible for rendering the add/edit inquiry drawer.
 *
 * @since 4.4.5
 */
use Realhomes\CRM\Helpers\Drawer_Helper;

$is_edit        = ( 'edit' === $args['item_action'] );
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );
$draw_heading = '';

// Fetch the lead data only if editing
if ( $is_edit ) {
    $inquiry = Realhomes_Crm_Inquiries::fetch_inquiry( $args['item_id'] );

    $lead_name = $fallback_value;
    if ( ! empty( $inquiry->lead_id ) ) {
        $lead      = Realhomes_Crm_Leads::fetch_lead( (int) $inquiry->lead_id );
        $lead_name = ! empty( $lead->display_name ) ? $lead->display_name : $lead->first_name . ' ' . $lead->lead_name;
    }

    $query = maybe_unserialize( $inquiry->query );

    $draw_heading = ! empty( $lead_name ) ? esc_html( $lead_name ) . esc_html__( "'s ", RH_TEXT_DOMAIN ) : '';
    $draw_heading = esc_html__( 'Edit', RH_TEXT_DOMAIN ) . ' ' . $draw_heading . ' ' . esc_html__( 'Inquiry', RH_TEXT_DOMAIN );
}

$leads = Realhomes_Crm_Leads::fetch_leads( array( 'number' => 10 ), array( 'id', 'display_name' ) );

Drawer_Helper::header( $args['item_action'], $inquiry ?? null, $args['item_type'], $draw_heading );
?>

    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <h2 class="text-base/7 font-semibold text-gray-900"><?php
            esc_html_e( 'Inquiry States', RH_TEXT_DOMAIN ); ?></h2>
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

            <div class="sm:col-span-3 sm:col-start-1">
                <label for="type" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Inquiry Type', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
                    <?php
                    $inquiry_types = Realhomes_Crm_Helper::get_setting( 'inquiry_types', explode: true ); ?>
                    <select id="type" name="type" autocomplete="type" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <?php
                        foreach ( $inquiry_types as $inquiry_type ) {
                            echo '<option value="' . esc_attr( $inquiry_type ) . '" ' . selected( $inquiry_type, $is_edit ? $inquiry->type : '' ) . '>' . esc_html( $inquiry_type ) . '</option>';
                        }
                        ?>
                    </select>
                    <?php
                    Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-3">
                <label for="status" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Inquiry Status', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
                    <?php
                    $inquiry_statuses = Realhomes_Crm_Helper::get_setting( 'inquiry_statuses', explode: true ); ?>
                    <select id="status" name="status" autocomplete="status" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <?php
                        foreach ( $inquiry_statuses as $inquiry_status ) {
                            echo '<option value="' . esc_attr( $inquiry_status ) . '" ' . selected( $inquiry_status, $is_edit ? $inquiry->status : '' ) . '>' . esc_html( $inquiry_status ) . '</option>';
                        }
                        ?>
                    </select>
                    <?php
                    Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

        </div>
    </div>
    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <h2 class="text-base/7 font-semibold text-gray-900"><?php
            esc_html_e( 'Inquiry Query Information', RH_TEXT_DOMAIN ); ?></h2>
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-8">
            <div class="sm:col-span-4">
                <label for="lead-id" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Lead Contact', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
                    <select id="lead-id" name="lead-id" autocomplete="lead-id" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <?php
                        foreach ( $leads as $lead ) {
                            echo '<option value="' . esc_attr( $lead->id ) . '" ' . selected( $lead->id, $is_edit ? $inquiry->lead_id : '' ) . '>' . esc_html( $lead->display_name ) . '</option>';
                        }
                        ?>
                    </select>
                    <?php
                    Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-4">
                <label for="property-city" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Property City', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
                    <?php
                    $cities = get_terms( [ 'taxonomy' => 'property-city' ] ); ?>
                    <select id="property-city" name="property-city" autocomplete="property-city" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <?php
                        foreach ( $cities as $city ) {
                            echo '<option value="' . esc_attr( $city->slug ) . '" ' . selected( $city->slug, $is_edit ? $query['property-city'][0] : '' ) . '>' . esc_html( $city->name ) . '</option>';
                        }
                        ?>
                    </select>
                    <?php
                    Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-4">
                <label for="property-status" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Property Status', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
                    <?php
                    $property_statuses = get_terms( [ 'taxonomy' => 'property-status' ] ); ?>
                    <select id="property-status" name="property-status" autocomplete="property-status" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <?php
                        foreach ( $property_statuses as $property_type ) {
                            echo '<option value="' . esc_attr( $property_type->slug ) . '" ' . selected( $property_type->slug, $is_edit ? $query['property-type'][0] : '' ) . '>' . esc_html( $property_type->name ) . '</option>';
                        }
                        ?>
                    </select>
                    <?php
                    Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>

            <div class="sm:col-span-4">
                <label for="property-type" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Property Type', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2 grid grid-cols-1">
                    <?php
                    $property_types = get_terms( [ 'taxonomy' => 'property-type' ] ); ?>
                    <select id="property-type" name="property-type" autocomplete="property-type" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <?php
                        foreach ( $property_types as $property_type ) {
                            echo '<option value="' . esc_attr( $property_type->slug ) . '" ' . selected( $property_type->slug, $is_edit ? $query['property-type'][0] : '' ) . '>' . esc_html( $property_type->name ) . '</option>';
                        }
                        ?>
                    </select>
                    <?php
                    Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-8">

            <div class="sm:col-span-2">
                <label for="min-beds" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Min Beds', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="min-beds" id="min-beds" autocomplete="min-beds" min="0" value="<?php echo esc_attr( $is_edit ? $query['min-beds'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>
            <div class="sm:col-span-2">
                <label for="max-beds" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Max Beds', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="max-beds" id="max-beds" autocomplete="max-beds" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['max-beds'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>

            <div class="sm:col-span-2">
                <label for="min-baths" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Min Baths', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="min-baths" id="min-baths" autocomplete="min-baths" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['min-baths'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>
            <div class="sm:col-span-2">
                <label for="max-baths" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Max Baths', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="max-baths" id="max-baths" autocomplete="max-baths" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['max-baths'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>

            <div class="sm:col-span-2">
                <label for="min-garage" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Min Garages', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="min-garage" id="min-garage" autocomplete="min-garage" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['min-garage'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>
            <div class="sm:col-span-2">
                <label for="max-garage" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Max Garages', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="max-garage" id="max-garage" autocomplete="max-garage" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['max-garage'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>

            <div class="sm:col-span-2">
                <label for="min-area" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Min Area', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="min-area" id="min-area" autocomplete="min-area" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['min-area'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>
            <div class="sm:col-span-2">
                <label for="max-garage" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Max Area', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="max-area" id="max-area" autocomplete="max-area" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['max-area'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>

        </div>
    </div>

    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-8">

            <div class="sm:col-span-4">
                <label for="min-price" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Min Price', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="min-price" id="min-price" autocomplete="min-price" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['min-price'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>
            <div class="sm:col-span-4">
                <label for="max-garage" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Max Price', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="max-price" id="max-price" autocomplete="max-price" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['max-price'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>

            <div class="sm:col-span-6">
                <label for="property-address" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Property Address', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="text" name="property-address" id="property-address" autocomplete="property-address" value="<?php
                    echo esc_attr( $is_edit ? $query['property-address'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>
            <div class="sm:col-span-2">
                <label for="property-zipcode" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Property Zip Code', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <input type="number" name="property-zipcode" id="property-zipcode" autocomplete="property-zipcode" min="0" value="<?php
                    echo esc_attr( $is_edit ? $query['property-zipcode'] : '' ); ?>" class="rh-crm-input">
                </div>
            </div>

        </div>
    </div>

    <div class="border-b border-gray-900/10 pb-12 mb-12">
        <h2 class="text-base/7 font-semibold text-gray-900"><?php
            esc_html_e( 'Inquiry Message & Private Note', RH_TEXT_DOMAIN ); ?></h2>
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">
            <div class="sm:col-span-6 sm:col-start-1">
                <label for="message" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Message', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <textarea name="message" id="message" autocomplete="message" class="rh-crm-input"><?php
                        echo esc_attr( $is_edit ? $inquiry->message : '' ); ?></textarea>
                </div>
            </div>

            <div class="sm:col-span-6">
                <label for="private-note" class="block text-sm/6 font-medium text-gray-900"><?php
                    esc_html_e( 'Private Note', RH_TEXT_DOMAIN ); ?></label>
                <div class="mt-2">
                    <textarea name="private-note" id="private-note" autocomplete="private-note" class="rh-crm-input"><?php
                        echo esc_attr( $is_edit ? $inquiry->private_note : '' ); ?></textarea>
                </div>
            </div>
        </div>
    </div>

<?php
Drawer_Helper::footer( $args['item_action'], $inquiry ?? null, $args['item_type'] ); ?>