<?php
/**
 * This file is responsible for tasks list page.
 *
 * @since 4.4.5
 */

$page_type = 'task';

// Prepare args and fetch items from the CRM class
$args           = Realhomes_Crm_Helper::prepare_listing_page_args( $page_type );
$tasks          = Realhomes_Crm_Tasks::fetch_tasks( [ 'number' => $args['items_per_page'], 'keyword' => $args['searched_word'], 'offset' => $args['offset'] ] );
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );

if ( ! empty( $tasks ) || isset( $_GET['posts_search'] ) ) {
	?>
	<!--Tasks Header-->
	<?php
	Realhomes_Crm_Helper::listing_header( $page_type, $args['searched_word'] );
	if ( $tasks ) {
		?>
		<!--Task Items-->
		<div id="rh-crm-<?php echo Realhomes_Crm_Helper::get_page_type_plurals()[ $page_type ]; ?>-items" class="py-4 sm:px-6 lg:px-8 bg-white min-w-full max-w-full overflow-x-auto overflow-y-hidden">
			<table class="min-w-full divide-y divide-gray-200">
				<thead>
				<tr>
					<th scope="col" class="py-6 pl-4 pr-3 w-[40px]">
						<?php Realhomes_Crm_Helper::items_select_checkbox(); ?>
					</th>
					<th scope="col" class="w-[15%] px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Task', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="w-[30%] px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Description', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Type', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Priority', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Due Date', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0">
						<span class="sr-only"><?php esc_html_e( 'Actions', RH_TEXT_DOMAIN ); ?></span>
					</th>
				</tr>
				</thead>
				<tbody class="divide-y divide-gray-200">
				<?php

				// Loop through each deal and output data in table rows
				$last_key = array_key_last( $tasks );
				foreach ( $tasks as $key => $task ) {
					?>
					<tr class="rh-crm-item-wrapper hover:bg-gray-50 transition duration-200">
						<td class="py-8 pl-4 pr-3 text-sm">
							<?php Realhomes_Crm_Helper::item_select_checkbox( $page_type, $task->id ); ?>
						</td>
						<td class="px-3 py-5 text-sm text-gray-700"><?php echo esc_html( wp_trim_words( $task->title, 10 ) ); ?></td>
						<td class="px-3 py-5 text-sm text-gray-500"><?php echo ! empty( $task->description ) ? esc_html( wp_trim_words( $task->description, 15 ) ) : $fallback_value; ?></td>
						<td class="px-3 py-5 text-sm text-gray-500"><?php echo esc_html( $task->status ); ?></td>
						<td class="px-3 py-5 text-sm text-gray-500"><?php echo esc_html( $task->type ); ?></td>
						<td class="px-3 py-5 text-sm text-gray-500"><?php echo esc_html( $task->priority ); ?></td>
						<td class="px-3 py-5 text-sm text-gray-500 whitespace-nowrap"><?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $task->due_date ) ); ?></td>
						<td class="py-5 pl-3 pr-4 text-sm sm:pr-0">
							<?php Realhomes_Crm_Helper::the_item_actions( $task->id, $page_type, $key === $last_key ); ?>
						</td>
					</tr>
				<?php } ?>

				</tbody>
			</table>
		</div>

		<!--Tasks Footer & Action Buttons-->
		<?php
		Realhomes_Crm_Helper::listing_footer( $args['offset'], $args['current_page'], $args['items_per_page'], $args['total_items'], $page_type );
		Realhomes_Crm_Helper::selected_items_action_buttons( $page_type );
	} else {
		Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No tasks found matching your query :(', RH_TEXT_DOMAIN ) );
	}
} else {
	Realhomes_Crm_Helper::no_item_found_note( $page_type );
}
?>