<?php
/**
 * This file is responsible for rendering the add/edit task drawer.
 *
 * @since 4.4.5
 */

use Realhomes\CRM\Helpers\Drawer_Helper;

$is_edit = ( $args['item_action'] === 'edit' );

$item_id        = $args['item_id'];
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );
$task           = $item_id ? Realhomes_Crm_Tasks::fetch_task( $item_id ) : null;

Drawer_Helper::header( $args['item_action'], $task, 'task' );
?>

	<div class="border-b border-gray-900/10 pb-12 mb-12">
		<div class="grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

			<div class="sm:col-span-6 sm:col-start-1">
				<label for="title" class="block text-sm/6 font-medium text-gray-900">
					<i class="text-red-500 not-italic">*</i>
					<?php esc_html_e( 'Title', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2">
					<input type="text" name="title" id="title" autocomplete="title" value="<?php echo esc_attr( $is_edit ? $task->title : '' ); ?>" class="rh-crm-input" required>
				</div>
			</div>

			<div class="sm:col-span-6">
				<label for="description" class="block text-sm/6 font-medium text-gray-900">
					<?php esc_html_e( 'Description', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2">
                    <textarea name="description" id="description" autocomplete="description" class="rh-crm-input">
	                    <?php echo esc_attr( $is_edit ? $task->description : '' ); ?>
                    </textarea>
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="status" class="block text-sm/6 font-medium text-gray-900">
					<?php esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2 grid grid-cols-1">
					<?php
					$statuses = Realhomes_Crm_Helper::get_setting( 'task_statuses', explode: true ); ?>
					<select id="status" name="status" autocomplete="status" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $statuses as $status ) {
							echo '<option value="' . esc_attr( $status ) . '" ' . selected( $status, $is_edit ? $task->status : '' ) . '>' . esc_html( $status ) . '</option>';
						}
						?>
					</select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="type" class="block text-sm/6 font-medium text-gray-900">
					<?php esc_html_e( 'Type', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2 grid grid-cols-1">
					<?php
					$types = Realhomes_Crm_Helper::get_setting( 'task_types', explode: true ); ?>
					<select id="type" name="type" autocomplete="type" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $types as $type ) {
							echo '<option value="' . esc_attr( $type ) . '" ' . selected( $type, $is_edit ? $task->type : '' ) . '>' . esc_html( $type ) . '</option>';
						}
						?>
					</select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="priority" class="block text-sm/6 font-medium text-gray-900">
					<?php esc_html_e( 'Priority', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2 grid grid-cols-1">
					<?php
					$priorities = Realhomes_Crm_Helper::get_setting( 'task_priorities', explode: true ); ?>
					<select id="priority" name="priority" autocomplete="priority" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $priorities as $priority ) {
							echo '<option value="' . esc_attr( $priority ) . '" ' . selected( $priority, $is_edit ? $task->priority : '' ) . '>' . esc_html( $priority ) . '</option>';
						}
						?>
					</select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="due-date" class="block text-sm/6 font-medium text-gray-900">
					<?php esc_html_e( 'Due Date', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2">
					<input type="text" name="due-date" value="<?php echo esc_attr( $is_edit ? $task->due_date : '' ); ?>" class="rh-crm-date-picker rh-crm-input">
				</div>
			</div>

		</div>
	</div>

<?php
Drawer_Helper::footer( $args['item_action'], $task, $args['item_type'] );
?>