<?php
/**
 * This file is responsible for displaying the task details in CRM drawer.
 *
 * @since 4.4.5
 */

use Realhomes\CRM\Helpers\Drawer_Helper;

$item_id        = $args['item_id'];
$item_type      = $args['item_type'];
$task           = Realhomes_Crm_Tasks::fetch_task( $item_id );
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );


Drawer_Helper::header( $args['item_action'], $task, $item_type );

?>
	<div class="relative mt-6 flex-1 px-4 sm:p-8">

		<dl class="pt-14">
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'document', 'size-6 mr-4' );
					esc_html_e( 'Task Type', RH_TEXT_DOMAIN );
					?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
                    <span class="px-4 py-1 bg-orange-100 rounded text-orange-700">
                        <span class="size-2 bg-orange-700 rounded-full mr-4 align-middle inline-block"></span>
                        <?php echo esc_html( $task->type ); ?>
                    </span>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'stage', 'size-6 mr-4' );
					esc_html_e( 'Status', RH_TEXT_DOMAIN );
					?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
                    <span class="px-4 py-1 bg-green-100 rounded text-green-700">
                        <span class="size-2 bg-green-700 rounded-full mr-4 align-middle inline-block"></span>
                        <?php echo esc_html( $task->status ); ?>
                    </span>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'flag', 'size-6 mr-4' );
					esc_html_e( 'Priority', RH_TEXT_DOMAIN );
					?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
                    <span class="px-4 py-1 bg-indigo-100 rounded text-indigo-700">
                        <span class="size-2 bg-indigo-700 rounded-full mr-4 align-middle inline-block"></span>
                        <?php echo esc_html( $task->priority ); ?>
                    </span>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'calendar', 'size-6 mr-4' );
					esc_html_e( 'Due Date', RH_TEXT_DOMAIN ); ?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
					<?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $task->due_date ) ); ?>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'clock', 'size-6 mr-4' );
					esc_html_e( 'Created At', RH_TEXT_DOMAIN );
					?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
					<?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $task->created_at ) ); ?>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'last_updated', 'size-6 mr-4' );
					esc_html_e( 'Last Updated', RH_TEXT_DOMAIN );
					?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
					<?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $task->updated_at ) ); ?>
				</dd>
			</div>
		</dl>

		<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6">
			<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php esc_html_e( 'Title', RH_TEXT_DOMAIN ); ?></dt>
			<dd class="mt-1 text-sm text-gray-700 sm:mt-0"><?php echo empty( $task->title ) ? $fallback_value : esc_html( $task->title ); ?></dd>
		</div>
		<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6">
			<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php esc_html_e( 'Description', RH_TEXT_DOMAIN ); ?></dt>
			<dd class="mt-1 text-sm/8 text-gray-700 sm:mt-0"><?php echo empty( $task->description ) ? $fallback_value : esc_html( $task->description ); ?></dd>
		</div>

		<!--Tabbed Information-->
		<div class="realhomes-crm-tabs-wrapper">
			<div class="rh-crm-tabs-links">
				<div class="border-t border-b border-gray-200">
					<nav class="-mb-px flex space-x-8" aria-label="Tabs">
						<a id="rh-crm-notes-tab-link" data-tab="tab1" class="rh-crm-tab-link active">
							<?php esc_html_e( 'Notes', RH_TEXT_DOMAIN ); ?>
							<span>
	                            <?php
	                            $notes = Realhomes_Crm_Notes::fetch_notes( $item_id, $item_type );
	                            echo count( $notes );
	                            ?>
	                        </span>
						</a>
					</nav>
				</div>
			</div><!-- Tabs Links -->

			<div class="rh-crm-tabs-contents">
				<div class="rh-crm-tab-content py-10" id="tab1">
					<?php get_template_part( 'common/dashboard/crm/common/notes', null, array( 'item_id' => $item_id, 'item_type' => $item_type, 'notes' => $notes ) ) ?>
				</div>
			</div><!-- CRM Tabs Contents -->

		</div><!-- CRM Tabs -->

	</div>
<?php
Drawer_Helper::footer( $args['item_action'] );