<?php
/**
 * Field: Price Prefix
 *
 * @since 	3.12
 * @package realhomes/dashboard
 */
global $edit_property_id;

$property_price_prefix_label = get_option( 'realhomes_submit_property_price_prefix_label' );
if ( empty( $property_price_prefix_label ) ) {
	$property_price_prefix_label = esc_html__( 'Price Prefix Text', RH_TEXT_DOMAIN );
}
?>
<p>
	<label for="price-prefix"><?php echo esc_html( $property_price_prefix_label ); ?> <span><?php esc_html_e( 'Example: Starting Form', RH_TEXT_DOMAIN ); ?></span></label>
	<input id="price-prefix" name="price-prefix" type="text" value="<?php echo esc_attr( realhomes_get_price_prefix( $edit_property_id ) ); ?>" <?php echo realhomes_dashboard_get_required_attribute( 'price-prefix' ); ?> />
</p>