<?php
/**
 * Field: Property Owner
 *
 * @since   4.4.2
 * @package realhomes/dashboard
 */


// Setting property owner field label.
$property_owner_label = get_option( 'realhomes_submit_property_owner_label', esc_html__( 'Property Owner', RH_TEXT_DOMAIN ) );

// Check if editing a property and get saved owner.
$current_owner = '';
if ( realhomes_dashboard_edit_property() ) {
	global $post_meta_data;
	if ( isset( $post_meta_data['REAL_HOMES_property_owner'][0] ) ) {
		$current_owner = $post_meta_data['REAL_HOMES_property_owner'][0];
	}
}

// If not set, fallback to current user if they are an owner.
if ( empty( $current_owner ) ) {
	$current_user = wp_get_current_user();
	if ( in_array( 'owner', (array)$current_user->roles, true ) ) {
		$current_owner = $current_user->ID;
	}
}
?>

<p>
    <label for="rvr_property_owner"><?php esc_html_e( 'Owner', RH_TEXT_DOMAIN ); ?></label>
    <select name="rvr_property_owner" id="rvr_property_owner" class="inspiry_select_picker_trigger show-tick" title="<?php esc_attr_e( 'None', RH_TEXT_DOMAIN ) ?>">
		<?php generate_posts_list( 'owner', $current_owner ); ?>
    </select>
</p>