<?php
/**
 * Field: Property Type
 *
 * @since    3.0.0
 */
$property_type_label = get_option( 'realhomes_submit_property_type_label' );
if ( empty( $property_type_label ) ) {
	$property_type_label = esc_html__( 'Type', RH_TEXT_DOMAIN );
}
?>
<p>
    <label for="type"><?php echo esc_html( $property_type_label ); ?></label>
    <select name="type[]"
            id="type"
            class="inspiry_select_picker_trigger show-tick"
            data-size="5"
            data-actions-box="true"
		    <?php $selection_method = get_option( 'realhomes_taxonomy_selection_method', 'single' );
		    if ( 'multiselect' === $selection_method ) {
                ?>
                data-selected-text-format="count > 2"
                multiple="multiple"
                data-count-selected-text="{0} <?php esc_attr_e( ' Types Selected ', RH_TEXT_DOMAIN ); ?>"
                <?php
		    }
		    ?>
            title="<?php esc_attr_e( 'None', RH_TEXT_DOMAIN ); ?>">
		    <?php
		    if ( realhomes_dashboard_edit_property() ) {
			    global $target_property;
			    realhomes_edit_form_hierarchical_options( $target_property->ID, 'property-type' );
		    } else {
                if ( 'single' == $selection_method ) {
                    ?><option selected="selected" value="-1"><?php esc_html_e( 'None', RH_TEXT_DOMAIN ); ?></option><?php
                }

                $target_terms = -1;
                if ( isset( $_GET['type'] ) && ! empty( $_GET['type'] ) ) {
                    $target_terms = $_GET['type'];
                }

                if ( class_exists( 'ERE_Data' ) ) {
                    realhomes_id_based_hierarchical_options( ERE_Data::get_hierarchical_property_types(), $target_terms );
                }
		    }
		?>
    </select>
</p>