<?php

$search_data        = (array)$args['search_data'];
$search_page_url    = inspiry_get_search_page_url();
$search_query_str   = $search_data['search_query_str'];
$search_view_url    = $search_page_url . '?' . $search_query_str;
$search_args        = $search_data['search_wp_query_args'];
$search_args        = unserialize( base64_decode( $search_args ) );
$separator          = $args['separator'];
$rvr_geolocation    = ! empty( $search_args['geolocation-address'] ) ? $search_args['geolocation-address'] : '';
$rvr_checkin        = ! empty( $search_args['check-in'] ) ? $search_args['check-in'] : '';
$rvr_checkout       = ! empty( $search_args['check-out'] ) ? $search_args['check-out'] : '';
$geolocation_radius = ! empty( $search_args['geolocation-radius'] ) ? $search_args['geolocation-radius'] : '';
?>
<div class="post-column-wrap search-item-wrap" data-search-item="<?php echo esc_attr( $search_data['id'] ); ?>">

	<!-- Search Information -->
	<div class="saved-search-column-wrap">
		<div class="column search-query">
		<?php
		if ( ! empty( $search_args['s'] ) ) {
			echo '<strong>' . esc_html__( 'Keyword', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $search_args['s'] ) . $separator;
		}

		if ( ! empty( $rvr_geolocation ) ) {
			echo '<strong>' . esc_html__( 'Location', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $rvr_geolocation ) . $separator;
		}

		if ( ! empty( $rvr_checkin ) ) {
			echo '<strong>' . esc_html__( 'Check-in', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $rvr_checkin ) . $separator;
		}

		if ( ! empty( $rvr_checkout ) ) {
			echo '<strong>' . esc_html__( 'Check-out', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $rvr_checkout ) . $separator;
		}

		if ( ! empty( $geolocation_radius ) ) {
			echo '<strong>' . esc_html__( 'Radius', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $geolocation_radius ) . $separator;
		}

		if ( isset( $search_args['tax_query'] ) ) {

			$feature_terms = array();

			foreach ( $search_args['tax_query'] as $key => $value ) {

				if ( isset( $value['taxonomy'] ) && isset( $value['terms'] ) && 'property-city' === $value['taxonomy'] ) {
					$property_city = inspiry_tax_terms_string( $value['terms'], 'property-city' );
					if ( ! empty( $property_city ) ) {
						echo '<strong>' . esc_html__( 'City', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $property_city ) . $separator;
					}
				}

				if ( isset( $value['taxonomy'] ) && isset( $value['terms'] ) && 'property-status' === $value['taxonomy'] ) {
					$property_status = inspiry_tax_terms_string( $value['terms'], 'property-status' );
					if ( ! empty( $property_status ) ) {
						echo '<strong>' . esc_html__( 'Status', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $property_status ) . $separator;
					}
				}

				if ( isset( $value['taxonomy'] ) && isset( $value['terms'] ) && 'property-type' === $value['taxonomy'] ) {
					$property_type = inspiry_tax_terms_string( $value['terms'], 'property-type' );
					if ( ! empty( $property_type ) ) {
						echo '<strong>' . esc_html__( 'Type', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $property_type ) . $separator;
					}
				}

				if ( isset( $value['taxonomy'] ) && isset( $value['terms'] ) && 'property-feature' === $value['taxonomy'] ) {
					$feature_terms[] = $value['terms'];
				}
			}

			if ( is_array( $feature_terms ) && ! empty( $feature_terms ) ) {
				$property_feature = inspiry_tax_terms_string( $feature_terms, 'property-feature' );
				if ( ! empty( $property_feature ) ) {
					echo '<strong>' . esc_html__( 'Feature', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $property_feature ) . $separator;
				}
			}
		}

		if ( isset( $search_args['meta_query'] ) ) {
			foreach( $search_args['meta_query'] as $key => $value ) {
				if ( isset( $value['key'] ) && ! empty( $value['key'] ) ) {

					if ( 'REAL_HOMES_property_id' === $value['key'] ) {
						echo '<strong>' . esc_html__( 'Property ID', RH_TEXT_DOMAIN ) . ':</strong> ' . esc_html( $value['value'] ) . $separator;
					}

					if ( 'REAL_HOMES_property_bathrooms' === $value['key'] ) {
						echo '<strong>' . esc_html__( 'Bathrooms', RH_TEXT_DOMAIN ) . ':</strong>' . esc_html( $value['value'] ) . $separator;
					}

					if ( 'REAL_HOMES_property_bedrooms' === $value['key'] ) {
						echo '<strong>' . esc_html__( 'Bedrooms', RH_TEXT_DOMAIN ) . ':</strong>' . esc_html( $value['value'] ) . $separator;
					}

					if ( 'REAL_HOMES_property_garage' === $value['key'] ) {
						echo '<strong>' . esc_html__( 'Garages', RH_TEXT_DOMAIN ) . ':</strong>' . esc_html( $value['value'] ) . $separator;
					}

					if ( 'rvr_guests_capacity' === $value['key'] ) {
						echo '<strong>' . esc_html__( 'Guests Capacity', RH_TEXT_DOMAIN ) . ':</strong>' . esc_html( $value['value'] ) . $separator;
					}

					if ( 'REAL_HOMES_property_price' === $value['key'] ) {
						echo '<strong>' . esc_html__( 'Price', RH_TEXT_DOMAIN ) . ':</strong>';

						if ( is_array( $value['value'] ) ) {
							echo esc_html( $value['value'][0] ) . ' - ' . esc_html( $value['value'][1] ) . $separator;
						} else {
							echo esc_html( $value['value'] ) . $separator;
						}
					}

					if ( 'REAL_HOMES_agents' === $value['key'] && is_array( $value['value'] ) ) {
						echo '<strong>' . esc_html__( 'Agent', RH_TEXT_DOMAIN ) . ':</strong>';
						$count = 1;
						foreach ( $value['value'] as $agent_id ) {
							echo ( $count > 1 ) ? ', ' : '';
							echo esc_html( get_the_title( $agent_id ) );
							$count++;
						}

						echo $separator;
					}

					// Additional Fields.
					$additional_fields = get_option( 'inspiry_property_additional_fields' );

					if ( ! empty( $additional_fields['inspiry_additional_fields_list'] ) ) {
						foreach ( $additional_fields['inspiry_additional_fields_list'] as $field ) {
							$field_key = sanitize_key( 'inspiry_' . strtolower( preg_replace( '/\s+/', '_', $field['field_name'] ) ) );

							if ( $value['key'] === $field_key ) {
								echo '<strong>' . esc_html( $field['field_name'] ) . ':</strong>' . esc_html( $value['value'] ) . $separator;
							}
						}
					}
				}
			}
		}
		?>
		</div>
	</div>

	<!-- Actions -->
	<div class="post-actions-wrapper search-actions">
		<a class="preview-search" target="_blank" href="<?php echo esc_url( $search_view_url ); ?>">
			<i class="fas fa-eye"></i>
			<?php esc_html_e( 'View', RH_TEXT_DOMAIN ); ?>
		</a>
		<a class="delete-search" href="#">
			<i class="fas fa-trash"></i>
			<?php esc_html_e( 'Delete', RH_TEXT_DOMAIN ); ?>
		</a>
	</div>
</div>
