<?php
/**
 * Agents Customizer Settings
 *
 * @package realhomes/customizer
 */

if ( ! function_exists( 'inspiry_agents_customizer' ) ) :
	function inspiry_agents_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Agents Section
		 */
		$wp_customize->add_section( 'inspiry_agents_pages', array(
			'title'    => esc_html__( 'Agents Pages', RH_TEXT_DOMAIN ),
			'priority' => 125,
		) );

		if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
			/* Header Banner or None */
			$wp_customize->add_setting( 'inspiry_agents_header_variation', array(
				'type'              => 'option',
				'default'           => 'banner',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_agents_header_variation', array(
				'label'       => esc_html__( 'Header Variation', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Header variation to display on agent pages.', RH_TEXT_DOMAIN ),
				'type'        => 'radio',
				'section'     => 'inspiry_agents_pages',
				'choices'     => array(
					'banner' => esc_html__( 'Banner', RH_TEXT_DOMAIN ),
					'none'   => esc_html__( 'None', RH_TEXT_DOMAIN ),
				),
			) );
		}

		/* Number of Agents  */
		$wp_customize->add_setting( 'theme_number_posts_agent', array(
			'type'              => 'option',
			'default'           => '3',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'theme_number_posts_agent', array(
			'label'       => esc_html__( 'Number of Agents', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Select the maximum number of agents to display on an agents list page.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_agents_pages',
			'choices'     => array(
				'1'  => 1,
				'2'  => 2,
				'3'  => 3,
				'4'  => 4,
				'5'  => 5,
				'6'  => 6,
				'7'  => 7,
				'8'  => 8,
				'9'  => 9,
				'10' => 10,
				'11' => 11,
				'12' => 12,
				'13' => 13,
				'14' => 14,
				'15' => 15,
				'16' => 16,
				'17' => 17,
				'18' => 18,
				'19' => 19,
				'20' => 20,
			),
		) );
		if ( 'ultra' === INSPIRY_DESIGN_VARIATION ) {
			$wp_customize->add_setting( 'realhomes_single_agent_page_description', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_control( 'realhomes_single_agent_page_description', array(
				'label'   => esc_html__( 'Agent Single Page Description', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_agents_pages',
			) );
			// Custom Agent Detail Page Template
			$wp_customize->add_setting( 'realhomes_elementor_agent_single_template', array(
				'type'              => 'option',
				'default'           => 'default',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_elementor_agent_single_template', array(
				'label'       => esc_html__( 'Agent Single Elementor Template', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Select Agent Single Template designed using Elementor Page Builder. This option will be overridden if Elementor Pro version is being used to design Single Agent.', RH_TEXT_DOMAIN ),
				'type'        => 'select',
				'section'     => 'inspiry_agents_pages',
				'choices'     => realhomes_get_elementor_library(),
			) );

			$wp_customize->add_setting(
				'realhomes_sample_agent_id', array(
					'type'              => 'option',
					'sanitize_callback' => 'sanitize_text_field',
				)
			);
			$wp_customize->add_control(
				'realhomes_sample_agent_id', array(
					'label'       => esc_html__( 'Sample Agent ID For Elementor Editor', RH_TEXT_DOMAIN ),
					'description' => esc_html__( 'Only for Elementor Editor to design Single Agent Template', RH_TEXT_DOMAIN ),
					'type'        => 'text',
					'section'     => 'inspiry_agents_pages',
				)
			);

			$wp_customize->add_setting( 'realhomes_elementor_agent_archive_template', array(
				'type'              => 'option',
				'default'           => 'default',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'realhomes_elementor_agent_archive_template', array(
				'label'       => esc_html__( 'Agents Archive Elementor Template', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Archive Template designed using Elementor Page Builder. This option will be overridden if Elementor Pro version is being used to design Archive.', RH_TEXT_DOMAIN ),
				'type'        => 'select',
				'section'     => 'inspiry_agents_pages',
				'choices'     => realhomes_get_elementor_library(),
			) );


		}

		if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {

			$wp_customize->add_setting( 'realhomes_agent_search', array(
				'type'              => 'option',
				'default'           => 'no',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_agent_search', array(
				'label'   => esc_html__( 'Enable Agent Search', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_agents_pages',
				'choices' => array(
					'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RH_TEXT_DOMAIN ),
				),
			) );

			$wp_customize->add_setting( 'realhomes_agent_keyword_placeholder', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => esc_html__( 'Name/Bio', RH_TEXT_DOMAIN ),
			) );
			$wp_customize->add_control( 'realhomes_agent_keyword_placeholder', array(
				'label'   => esc_html__( 'Placeholder Text for Name/Bio Field', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_agents_pages',
			) );
			$wp_customize->add_setting( 'realhomes_agent_number_of_properties_placeholder', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => esc_html__( 'Number Of Properties', RH_TEXT_DOMAIN ),
			) );
			$wp_customize->add_control( 'realhomes_agent_number_of_properties_placeholder', array(
				'label'   => esc_html__( 'Placeholder Text for Number Of Properties Field', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_agents_pages',
			) );
			$wp_customize->add_setting( 'realhomes_number_of_properties_values', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => '1,2,3,4,5,6,7,8,9,10',
			) );
			$wp_customize->add_control( 'realhomes_number_of_properties_values', array(
				'label'       => esc_html__( 'Number Of Properties Values', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers.', RH_TEXT_DOMAIN ),
				'type'        => 'textarea',
				'section'     => 'inspiry_agents_pages',
			) );
			$wp_customize->add_setting( 'realhomes_agent_locations_placeholder', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => esc_html__( 'Locations', RH_TEXT_DOMAIN ),
			) );
			$wp_customize->add_control( 'realhomes_agent_locations_placeholder', array(
				'label'   => esc_html__( 'Placeholder Text for Location', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_agents_pages',
			) );
			$wp_customize->add_setting( 'realhomes_agent_verified_placeholder', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => esc_html__( 'Verified Agents', RH_TEXT_DOMAIN ),
			) );
			$wp_customize->add_control( 'realhomes_agent_verified_placeholder', array(
				'label'   => esc_html__( 'Placeholder Text for Verified Agents Field', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_agents_pages',
			) );

		}

		/* Agents Sorting */
		$wp_customize->add_setting( 'inspiry_agents_sorting', array(
			'type'              => 'option',
			'default'           => 'hide',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_agents_sorting', array(
			'label'   => esc_html__( 'Agents Sort Control', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_agents_pages',
			'choices' => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		/* Agent Stats Charts on detail page */
		$wp_customize->add_setting( 'realhomes_agent_single_stats_charts', array(
			'type'              => 'option',
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_agent_single_stats_charts', array(
			'label'   => esc_html__( 'Properties Stats on Detail Page', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_agents_pages',
			'choices' => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			)
		) );

		// Agent charts section title
		$wp_customize->add_setting( 'realhomes_agent_stats_section_title', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Progress & Stats', RH_TEXT_DOMAIN ),
		) );
		$wp_customize->add_control( 'realhomes_agent_stats_section_title', array(
			'label'   => esc_html__( 'Agent Stats Section Title', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_agents_pages',
		) );

		// Agent stats break point
		$wp_customize->add_setting( 'realhomes_agent_stats_break_point', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => 3
		) );
		$wp_customize->add_control( 'realhomes_agent_stats_break_point', array(
			'label'       => esc_html__( 'Stats Count Break Point', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Break point after which all other status will be combined in others.', RH_TEXT_DOMAIN ),
			'type'        => 'number',
			'section'     => 'inspiry_agents_pages',
		) );

		/* Agent Properties on Agent Single */
		$wp_customize->add_setting( 'inspiry_agent_single_properties', array(
			'type'              => 'option',
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_agent_single_properties', array(
			'label'   => esc_html__( 'Properties on Agent Detail Page', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_agents_pages',
			'choices' => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		if ( 'classic' !== INSPIRY_DESIGN_VARIATION ) {
			// Show/Hide Agent Listed Properties
			$wp_customize->add_setting( 'inspiry_agent_properties_count', array(
				'type'              => 'option',
				'default'           => 'show',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_agent_properties_count', array(
				'label'   => esc_html__( 'Agents Properties Count', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_agents_pages',
				'choices' => array(
					'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
					'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
				),
			) );

			// Show/Hide Agent Listed Properties
			$wp_customize->add_setting( 'realhomes_agent_view_listing_link', array(
				'type'              => 'option',
				'default'           => 'show',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_agent_view_listing_link', array(
				'label'   => esc_html__( 'Agent "View My Listings" Link/Button', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_agents_pages',
				'choices' => array(
					'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
					'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
				),
			) );
		}

		/* Number of Agents  */
		$wp_customize->add_setting( 'theme_number_of_properties_agent', array(
			'type'              => 'option',
			'default'           => '6',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'theme_number_of_properties_agent', array(
			'label'       => esc_html__( 'Number of Properties on Agent Detail Page', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Select the maximum number of properties to display on agent detail page.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_agents_pages',
			'choices'     => array(
				'1'  => 1,
				'2'  => 2,
				'3'  => 3,
				'4'  => 4,
				'5'  => 5,
				'6'  => 6,
				'7'  => 7,
				'8'  => 8,
				'9'  => 9,
				'10' => 10,
				'11' => 11,
				'12' => 12,
				'13' => 13,
				'14' => 14,
				'15' => 15,
				'16' => 16,
				'17' => 17,
				'18' => 18,
				'19' => 19,
				'20' => 20,
			),
		) );

		/* Enable/Disable User Sync with Agents/Agencies */
		$wp_customize->add_setting( 'realhomes_agent_verification_migrate_options_notice' );
		$wp_customize->add_control(
			new Realhomes_Customizer_Notice_Control( $wp_customize, 'realhomes_agent_verification_migrate_options_notice',
				array(
					'label'             => esc_html__( 'Notice:', RH_TEXT_DOMAIN ),
					'description'       => sprintf( esc_html__( 'Agent verification related option is moved to %s', RH_TEXT_DOMAIN ), '<a class="customizer-link" target="_blank" href=' . admin_url() . 'admin.php?page=ere-settings&tab=post_types' . '>' . esc_html__( 'Post Type Verification tab.', RH_TEXT_DOMAIN ) . '</a>' ),
					'section'           => 'inspiry_agents_pages',
					'sanitize_callback' => 'wp_kses_post'
				) )
		);

		/* Agent Ratings */
		$wp_customize->add_setting(
			'realhomes_agent_ratings', array(
				'type'              => 'option',
				'default'           => 'false',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'realhomes_agent_ratings', array(
				'label'   => esc_html__( 'Agent Ratings', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_agents_pages',
				'choices' => array(
					'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
				),
			)
		);

		$wp_customize->add_setting( 'theme_custom_agent_contact_form', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'theme_custom_agent_contact_form', array(
			'label'       => esc_html__( 'Shortcode to Replace Default Agent Form', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Default agent form can be replaced with custom form using contact form 7 or WPForms plugin shortcode.', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'inspiry_agents_pages',
		) );
	}

	add_action( 'customize_register', 'inspiry_agents_customizer' );
endif;

if ( ! function_exists( 'inspiry_agents_defaults' ) ) :
	/**
	 * Set default values for agents settings
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	function inspiry_agents_defaults( WP_Customize_Manager $wp_customize ) {
		$agents_settings_ids = array(
			'inspiry_agents_header_variation',
			'theme_number_posts_agent',
			'theme_number_of_properties_agent',
		);
		inspiry_initialize_defaults( $wp_customize, $agents_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_agents_defaults' );
endif;
