<?php
/**
 * Dashboard Settings
 *
 * @package realhomes/customizer
 */
if ( ! function_exists( 'inspiry_dashboard_customizer' ) ) {
	function inspiry_dashboard_customizer( WP_Customize_Manager $wp_customize ) {

		$wp_customize->add_panel( 'inspiry_dashboard_panel', array(
			'title'    => esc_html__( 'Dashboard', RH_TEXT_DOMAIN ),
			'priority' => 128,
		) );

		// Dashboard Basic
		$wp_customize->add_section( 'inspiry_dashboard_basic', array(
			'title' => esc_html__( 'Basic', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// Dashboard Page
		$wp_customize->add_setting( 'inspiry_dashboard_page', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'inspiry_dashboard_page', array(
			'label'       => esc_html__( 'Select Dashboard Page', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Selected page should have Dashboard Template assigned to it.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_dashboard_basic',
			'choices'     => RH_Data::get_pages_array(),
		) );

		// Restrict Admin Dashboard Access.
		$wp_customize->add_setting( 'theme_restricted_level', array(
			'type'              => 'option',
			'default'           => '0',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'theme_restricted_level', array(
			'label'       => esc_html__( 'Restrict Admin Side Access', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Restrict admin side access to any user level equal to or below the selected user level.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_dashboard_basic',
			'choices'     => array(
				'0' => esc_html__( 'Subscriber ( Level 0 )', RH_TEXT_DOMAIN ),
				'1' => esc_html__( 'Contributor ( Level 1 )', RH_TEXT_DOMAIN ),
				'2' => esc_html__( 'Author ( Level 2 )', RH_TEXT_DOMAIN ),
			),
		) );

		// Logged-in User Greeting Text
		$wp_customize->add_setting( 'inspiry_user_greeting_text', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Hello', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_user_greeting_text', array(
			'label'   => esc_html__( 'Greeting Text for Logged-in User', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_dashboard_basic',
		) );

		// Dashboard Logo Link Behaviour
		$wp_customize->add_setting( 'realhomes_dashboard_logo_link', array(
			'type'              => 'option',
			'default'           => 'dashboard',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_logo_link', array(
			'label'   => esc_html__( 'Dashboard Logo Link', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_dashboard_basic',
			'choices' => array(
				'dashboard' => esc_html__( 'Dashboard Overview Page', RH_TEXT_DOMAIN ),
				'homepage'  => esc_html__( 'Website Homepage', RH_TEXT_DOMAIN ),
			),
		) );

		// Dashboard header search form control
		$wp_customize->add_setting( 'realhomes_dashboard_header_search', array(
			'type'              => 'option',
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_header_search', array(
			'label'   => esc_html__( 'Dashboard Header Search', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_dashboard_basic',
			'choices' => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		// Front Page Button Display
		$wp_customize->add_setting( 'realhomes_dashboard_frontpage_button', array(
			'type'              => 'option',
			'default'           => 'false',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_frontpage_button', array(
			'label'   => esc_html__( 'Front Page Button in Header', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_dashboard_basic',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// Front Page Button Type
		$wp_customize->add_setting( 'realhomes_dashboard_frontpage_button_type', array(
			'type'              => 'option',
			'default'           => 'icon',
			'sanitize_callback' => 'inspiry_sanitize_radio'
		) );
		$wp_customize->add_control( 'realhomes_dashboard_frontpage_button_type', array(
			'label'   => esc_html__( 'Front Page Button Type', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_dashboard_basic',
			'choices' => array(
				'icon'  => esc_html__( 'Home Icon', RH_TEXT_DOMAIN ),
				'label' => esc_html__( 'Label', RH_TEXT_DOMAIN )
			)
		) );

		// Front Page Button Label
		$wp_customize->add_setting( 'realhomes_dashboard_frontpage_button_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Front Page', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_frontpage_button_label', array(
			'label'           => esc_html__( 'Front Page Button Label', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'inspiry_dashboard_basic',
			'active_callback' => function () {
				return ( 'true' === get_option( 'realhomes_dashboard_frontpage_button', 'false' ) );
			}
		) );

		// Dashboard Module Display
		$wp_customize->add_setting( 'inspiry_dashboard_page_display', array(
			'type'              => 'option',
			'default'           => 'true',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_dashboard_page_display', array(
			'label'   => esc_html__( 'Summarized Info on Dashboard', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_dashboard_basic',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// Properties Action Buttons Style
		$wp_customize->add_setting( 'realhomes_dashboard_action_buttons_style', array(
			'type'              => 'option',
			'default'           => 'button',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_action_buttons_style', array(
			'label'   => esc_html__( 'Properties Action Links Style', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_dashboard_basic',
			'choices' => array(
				'link'   => esc_html__( 'Links', RH_TEXT_DOMAIN ),
				'button' => esc_html__( 'Buttons', RH_TEXT_DOMAIN )
			),
		) );

		// Properties Action Buttons Text
		$wp_customize->add_setting( 'realhomes_dashboard_action_buttons_text_hide', array(
			'type'              => 'option',
			'default'           => 'no',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_action_buttons_text_hide', array(
			'label'           => esc_html__( 'Hide Action Buttons Text', RH_TEXT_DOMAIN ),
			'type'            => 'radio',
			'section'         => 'inspiry_dashboard_basic',
			'choices'         => array(
				'no'  => esc_html__( 'No', RH_TEXT_DOMAIN ),
				'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN )
			),
			'active_callback' => fn() => 'button' === get_option( 'realhomes_dashboard_action_buttons_style', 'button' ),
		));

		// Properties Action Buttons Hover Text Display
		$wp_customize->add_setting( 'realhomes_dashboard_action_buttons_text_hover', array(
			'type'              => 'option',
			'default'           => 'yes',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_action_buttons_text_hover', array(
			'label'   => esc_html__( 'Show Action Buttons Text on Hover', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_dashboard_basic',
			'choices' => array(
				'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
				'no'  => esc_html__( 'No', RH_TEXT_DOMAIN )
			),
			'active_callback' => fn() => 'yes' === get_option( 'realhomes_dashboard_action_buttons_text_hide', 'no' ),
		) );

		// Posts Per Page
		$posts_per_page_list = realhomes_dashboard_posts_per_page_list();
		if ( is_array( $posts_per_page_list ) && ! empty( $posts_per_page_list ) ) {
			$wp_customize->add_setting( 'inspiry_dashboard_posts_per_page', array(
				'type'              => 'option',
				'default'           => '10',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'inspiry_dashboard_posts_per_page', array(
				'label'   => esc_html__( 'Posts Per Page', RH_TEXT_DOMAIN ),
				'type'    => 'select',
				'section' => 'inspiry_dashboard_basic',
				'choices' => $posts_per_page_list
			) );
		}

		// Dashboard Analytics
		$wp_customize->add_section( 'realhomes_dashboard_analytics', array(
			'title' => esc_html__( 'Analytics', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// Properties Analytics Show/Hide Field
		$wp_customize->add_setting( 'realhomes_dashboard_analytics_module', array(
			'type'              => 'option',
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_analytics_module', array(
			'label'   => esc_html__( 'Dashboard Analytics Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_dashboard_analytics',
			'choices' => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN )
			)
		) );

		/* Notification to enable analytics from ERE settings */
		$wp_customize->add_setting( 'realhomes_property_analytics_notice' );
		$wp_customize->add_control(
			new Realhomes_Customizer_Notice_Control( $wp_customize, 'realhomes_property_analytics_notice',
				array(
					'label'             => esc_html__( 'Notice:', RH_TEXT_DOMAIN ),
					'description'       => sprintf( esc_html__( 'Make sure that analytics collection option is enabled in %s options.', RH_TEXT_DOMAIN ), '<a class="customizer-link" target="_blank" href=' . admin_url() . 'admin.php?page=ere-settings&tab=property-analytics' . '>' . esc_html__( 'ERE Property Analytics', RH_TEXT_DOMAIN ) . '</a>' ),
					'section'           => 'realhomes_dashboard_analytics',
					'sanitize_callback' => 'wp_kses_post',
					'active_callback'   => function ( $control ) {

						// If analytics are hidden on dashboard then no need to show this one
						if ( $control->manager->get_setting( 'realhomes_dashboard_analytics_module' )->value() === 'hide' ) {
							return false;
						}

						// If the property analytics collection option is disabled in user settings then it will show notice
						return 'enabled' !== get_option( 'inspiry_property_analytics_status', 'enabled' );
					}
				)
			)
		);

		// Submit Property
		$wp_customize->add_section( 'inspiry_members_submit', array(
			'title' => esc_html__( 'Submit Property', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// Submit Property Module
		$wp_customize->add_setting( 'inspiry_submit_property_module_display', array(
			'type'              => 'option',
			'default'           => 'true',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_submit_property_module_display', array(
			'label'   => esc_html__( 'Submit Property Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_submit',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'inspiry_dashboard_submit_page_layout', array(
			'type'              => 'option',
			'default'           => 'steps',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'inspiry_dashboard_submit_page_layout', array(
			'label'   => esc_html__( 'Page Layout', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'inspiry_members_submit',
			'choices' => array(
				'steps' => esc_html__( 'Multi Steps', RH_TEXT_DOMAIN ),
				'step'  => esc_html__( 'Single Step', RH_TEXT_DOMAIN ),
			),
		) );

		/* Show submit button when user login */
		$show_submit_on_login_default = 'true';
		if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
			$show_submit_on_login_default = 'false';
		}
		$wp_customize->add_setting( 'inspiry_show_submit_on_login', array(
			'type'              => 'option',
			'default'           => $show_submit_on_login_default,
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_show_submit_on_login', array(
			'label'   => esc_html__( 'Submit Button in Header', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_submit',
			'choices' => array(
				'true'  => esc_html__( 'Show to Logged In Users Only', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Show to All Users', RH_TEXT_DOMAIN ),
				'hide'  => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		/* Submit button text */
		$wp_customize->add_setting( 'theme_submit_button_text', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Submit', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'theme_submit_button_text', array(
			'label'           => esc_html__( 'Submit Button Text', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'inspiry_members_submit',
			'active_callback' => function () {
				return ( 'hide' !== get_option( 'inspiry_show_submit_on_login', 'true' ) );
			},
		) );

		/* Guest Property Submission */
		$wp_customize->add_setting( 'inspiry_guest_submission', array(
			'type'              => 'option',
			'default'           => 'false',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_guest_submission', array(
			'label'   => esc_html__( 'Guest Property Submission', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_submit',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// Submit Property Form Fields
		$submit_property_form_fields = array(
			'title'              => esc_html__( 'Property Title', RH_TEXT_DOMAIN ),
			'address-and-map'    => esc_html__( 'Property Address and Map', RH_TEXT_DOMAIN ),
			'description'        => esc_html__( 'Property Description', RH_TEXT_DOMAIN ),
			'price'              => esc_html__( 'Price', RH_TEXT_DOMAIN ),
			'price-prefix'       => esc_html__( 'Price Prefix', RH_TEXT_DOMAIN ),
			'price-postfix'      => esc_html__( 'Price Postfix', RH_TEXT_DOMAIN ),
			'old-price'          => esc_html__( 'Old Price', RH_TEXT_DOMAIN ),
			'property-id'        => esc_html__( 'Property ID', RH_TEXT_DOMAIN ),
			'parent'             => esc_html__( 'Parent Property', RH_TEXT_DOMAIN ),
			'property-type'      => esc_html__( 'Type', RH_TEXT_DOMAIN ),
			'property-status'    => esc_html__( 'Status', RH_TEXT_DOMAIN ),
			'locations'          => esc_html__( 'Location', RH_TEXT_DOMAIN ),
			'bedrooms'           => esc_html__( 'Bedrooms', RH_TEXT_DOMAIN ),
			'bathrooms'          => esc_html__( 'Bathrooms', RH_TEXT_DOMAIN ),
			'garages'            => esc_html__( 'Garages', RH_TEXT_DOMAIN ),
			'area'               => esc_html__( 'Area', RH_TEXT_DOMAIN ),
			'area-postfix'       => esc_html__( 'Area Postfix', RH_TEXT_DOMAIN ),
			'lot-size'           => esc_html__( 'Lot Size', RH_TEXT_DOMAIN ),
			'lot-size-postfix'   => esc_html__( 'Lot Size Postfix', RH_TEXT_DOMAIN ),
			'year-built'         => esc_html__( 'Year Built', RH_TEXT_DOMAIN ),
			'video'              => esc_html__( 'Video', RH_TEXT_DOMAIN ),
			'virtual-tour'       => esc_html__( '360 Virtual Tour', RH_TEXT_DOMAIN ),
			'mortgage-fields'    => esc_html__( 'Mortgage Calculator Fields', RH_TEXT_DOMAIN ),
			'featured'           => esc_html__( 'Mark as Featured', RH_TEXT_DOMAIN ),
			'gallery-type'       => esc_html__( 'Gallery Type', RH_TEXT_DOMAIN ),
			'images'             => esc_html__( 'Property Images', RH_TEXT_DOMAIN ),
			'attachments'        => esc_html__( 'Property Attachments', RH_TEXT_DOMAIN ),
			'slider-image'       => esc_html__( 'Homepage Slider Image', RH_TEXT_DOMAIN ),
			'floor-plans'        => esc_html__( 'Floor Plans', RH_TEXT_DOMAIN ),
			'additional-details' => esc_html__( 'Additional Details', RH_TEXT_DOMAIN ),
			'features'           => esc_html__( 'Features', RH_TEXT_DOMAIN ),
			'label-and-color'    => esc_html__( 'Label and Color', RH_TEXT_DOMAIN ),
			'energy-performance' => esc_html__( 'Energy Performance', RH_TEXT_DOMAIN ),
			'agent'              => esc_html__( 'Agent', RH_TEXT_DOMAIN ),
			'owner'              => esc_html__( 'Property Owner', RH_TEXT_DOMAIN ),
			'owner-information'  => esc_html__( 'Owner Information', RH_TEXT_DOMAIN ),
			'reviewer-message'   => esc_html__( 'Message to Reviewer', RH_TEXT_DOMAIN ),
			'terms-conditions'   => esc_html__( 'Terms & Conditions', RH_TEXT_DOMAIN )
		);

		if ( inspiry_is_rvr_enabled() && rvr_is_wc_payment_enabled() ) {
			$rvr_settings = get_option( 'rvr_settings' );
			if ( ! empty( $rvr_settings['rvr_wc_payments_scope'] ) && 'property' === $rvr_settings['rvr_wc_payments_scope'] ) {
				$submit_property_form_fields['rvr-booking-scope'] = esc_html__( 'Booking Scope', RH_TEXT_DOMAIN );
			}
		}

		$wp_customize->add_setting( 'inspiry_submit_property_fields', array(
			'type'              => 'option',
			'default'           => array_keys( $submit_property_form_fields ),
			'sanitize_callback' => 'inspiry_sanitize_multiple_checkboxes',
		) );
		$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control( $wp_customize, 'inspiry_submit_property_fields',
			array(
				'section' => 'inspiry_members_submit',
				'label'   => esc_html__( 'Enable/Disable Submit Property Form Fields?', RH_TEXT_DOMAIN ),
				'choices' => $submit_property_form_fields
			)
		) );

		$required_fields = $submit_property_form_fields;

		unset(
			$required_fields['agent'],
			$required_fields['parent'],
			$required_fields['images'],
			$required_fields['floor-plans'],
			$required_fields['features'],
			$required_fields['attachments'],
			$required_fields['locations'],
			$required_fields['description'],
			$required_fields['address-and-map'],
			$required_fields['gallery-type'],
			$required_fields['slider-image'],
			$required_fields['property-type'],
			$required_fields['property-status'],
			$required_fields['label-and-color'],
			$required_fields['additional-details'],
			$required_fields['mortgage-fields'],
			$required_fields['video'],
		);

		$wp_customize->add_setting( 'realhomes_submit_form_required_fields', array(
			'type'              => 'option',
			'default'           => array( 'title', 'address-and-map', 'terms-conditions' ),
			'sanitize_callback' => 'inspiry_sanitize_multiple_checkboxes',
		) );
		$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control( $wp_customize, 'realhomes_submit_form_required_fields',
			array(
				'section' => 'inspiry_members_submit',
				'label'   => esc_html__( 'Mark Fields as Required in Submit Form', RH_TEXT_DOMAIN ),
				'choices' => $required_fields
			)
		) );

		$wp_customize->add_setting( 'realhomes_auto_user_agent_assignment', array(
			'type'              => 'option',
			'default'           => 'none',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_auto_user_agent_assignment', array(
			'label'           => esc_html__( 'Control auto assignment of user/agent if related section is disabled', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'If agent is selected, but user agent sync is not enabled then user will be assigned instead. Display option will be similar to this setting as well.', RH_TEXT_DOMAIN ),
			'type'            => 'radio',
			'section'         => 'inspiry_members_submit',
			'choices'         => array(
				'none'  => esc_html__( 'None', RH_TEXT_DOMAIN ),
				'user'  => esc_html__( 'User', RH_TEXT_DOMAIN ),
				'agent' => esc_html__( 'Agent', RH_TEXT_DOMAIN ),
			),
			'active_callback' => 'realhomes_display_auto_user_agent_assignment', // <-- Added this line
		) );

		// Option for taxonomy selection method in frontend Dashboard
		$wp_customize->add_setting( 'realhomes_taxonomy_selection_method', array(
			'type'              => 'option',
			'default'           => 'single',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_taxonomy_selection_method', array(
			'label'       => esc_html__( 'Choose Taxonomy Selection Method', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Choose how users can select taxonomy terms (e.g. Property Type or Property Status).', RH_TEXT_DOMAIN ),
			'type'        => 'radio',
			'section'     => 'inspiry_members_submit',
			'choices'     => array(
				'single'      => esc_html__( 'Single Select (Only one value allowed)', RH_TEXT_DOMAIN ),
				'multiselect' => esc_html__( 'Multi-Select (Allow selecting multiple values)', RH_TEXT_DOMAIN ),
			),
		) );

		// Agents Assignment Option
		$choices = array(
			'default'      => esc_html__( 'Display All Agents (Default)', RH_TEXT_DOMAIN ),
			'current_user' => esc_html__( 'Assign Current User/Agent', RH_TEXT_DOMAIN ),
		);
		if ( inspiry_is_user_sync_enabled() ) {
			$choices['agency_agent_only'] = esc_html__( 'Display Agency Agents Only', RH_TEXT_DOMAIN );
		}
		$wp_customize->add_setting( 'realhomes_agent_assignment_option', array(
			'type'              => 'option',
			'default'           => 'default',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_agent_assignment_option', array(
			'label'       => esc_html__( 'Agents Assignment Option', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'This option allow the selection and assignment of agent based on different criteria on "Submit and Edit Property" page.', RH_TEXT_DOMAIN ),
			'type'        => 'radio',
			'section'     => 'inspiry_members_submit',
			'choices'     => $choices
		) );

		// Default agent option for user/agent area
		$wp_customize->add_setting( 'realhomes_default_selected_agent', array(
			'type'              => 'option',
			'default'           => 0,
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_default_selected_agent', array(
			'label'           => esc_html__( 'Select Default Agent For Agent Area', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Choose an agent to be automatically pre-selected on the "Submit Property" page within the "Agent & Reviewer" section.', RH_TEXT_DOMAIN ),
			'type'            => 'select',
			'section'         => 'inspiry_members_submit',
			'choices'         => RH_Data::get_posts_array( 'agent' ),
			'active_callback' => 'realhomes_is_default_agent_assignment'
		) );

		// Default agent option for user/agent area of backend
		$wp_customize->add_setting( 'realhomes_default_selected_agent_backend', array(
			'type'              => 'option',
			'default'           => 0,
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_default_selected_agent_backend', array(
			'label'           => esc_html__( 'Select Default Agent For Backend New Property', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Choose an agent to be automatically pre-selected for "New Property" in the WordPress backend dashboard. This option does not belong to dashboard section but suites here to centralise it.', RH_TEXT_DOMAIN ),
			'type'            => 'select',
			'section'         => 'inspiry_members_submit',
			'choices'         => RH_Data::get_posts_array( 'agent' ),
			'active_callback' => 'realhomes_is_default_agent_assignment'
		) );

		// terms & conditions field note
		$wp_customize->add_setting( 'inspiry_submit_property_terms_text', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Accept Terms & Conditions before property submission.', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'inspiry_submit_property_terms_text', array(
			'label'           => esc_html__( 'Terms & Conditions Note', RH_TEXT_DOMAIN ),
			'description'     => '<strong>' . esc_html__( 'Important:', RH_TEXT_DOMAIN ) . ' </strong>' . esc_html__( 'Please use {link text} pattern in your note text as it will be linked to the Terms & Conditions page.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'inspiry_members_submit',
			'active_callback' => 'inspiry_is_submit_property_field_terms'
		) );

		// terms and conditions detail page
		$wp_customize->add_setting( 'inspiry_submit_property_terms_page', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'inspiry_submit_property_terms_page', array(
			'label'           => esc_html__( 'Select Terms & Conditions Page', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Selected page should have terms & conditions details.', RH_TEXT_DOMAIN ),
			'type'            => 'select',
			'section'         => 'inspiry_members_submit',
			'choices'         => RH_Data::get_pages_array(),
			'active_callback' => 'inspiry_is_submit_property_field_terms'
		) );

		/* Submitted Property Status */
		$wp_customize->add_setting( 'theme_submitted_status', array(
			'type'              => 'option',
			'default'           => 'pending',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'theme_submitted_status', array(
			'label'   => esc_html__( 'Default Status for Submitted Property', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'inspiry_members_submit',
			'choices' => array(
				'pending' => esc_html__( 'Pending ( Recommended )', RH_TEXT_DOMAIN ),
				'publish' => esc_html__( 'Publish', RH_TEXT_DOMAIN ),
			),
		) );

		/* Updated Property Status */
		$wp_customize->add_setting( 'inspiry_updated_property_status', array(
			'type'              => 'option',
			'default'           => 'publish',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'inspiry_updated_property_status', array(
			'label'   => esc_html__( 'Default Status for Updated Property', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'inspiry_members_submit',
			'choices' => array(
				'publish' => esc_html__( 'Publish', RH_TEXT_DOMAIN ),
				'pending' => esc_html__( 'Pending ( Recommended )', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'realhomes_enable_edit_property_notices', array(
			'type'              => 'option',
			'default'           => 'false',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_enable_edit_property_notices', array(
			'label'   => esc_html__( 'Enable Email Notifications for Property Edits', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_submit',
			'choices' => array(
				'true'  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'No', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'inspiry_submit_max_number_images', array(
			'type'              => 'option',
			'default'           => 48,
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_submit_max_number_images', array(
			'label'   => esc_html__( 'Max Number of Images to Upload', RH_TEXT_DOMAIN ),
			'type'    => 'number',
			'section' => 'inspiry_members_submit',
		) );

		$wp_customize->add_setting( 'inspiry_allowed_max_attachments', array(
			'type'              => 'option',
			'default'           => 15,
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_allowed_max_attachments', array(
			'label'   => esc_html__( 'Max Number of Attachments to Upload', RH_TEXT_DOMAIN ),
			'type'    => 'number',
			'section' => 'inspiry_members_submit',
		) );

		/*  Property default additional details */
		$wp_customize->add_setting( 'inspiry_property_additional_details', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'inspiry_property_additional_details', array(
			'label'       => esc_html__( 'Default Additional Details', RH_TEXT_DOMAIN ),
			'description' => wp_kses( __( 'Add title and value \'colon\' separated and fields \'comma\' separated. <br><br><strong>For Example</strong>: <pre>Plot Size:300,Built Year:2017</pre>', RH_TEXT_DOMAIN ), array(
				'br'     => array(),
				'strong' => array(),
				'pre'    => array(),
			) ),
			'type'        => 'textarea',
			'section'     => 'inspiry_members_submit',
		) );

		/* Message after Submit */
		$wp_customize->add_setting( 'theme_submit_message', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Thanks for Submitting Property!', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'inspiry_sanitize_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'theme_submit_message', array(
			'label'       => esc_html__( 'Message After Successful Submit', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'a, strong, em and i HTML tags are allowed in the message.', RH_TEXT_DOMAIN ),
			'type'        => 'textarea',
			'section'     => 'inspiry_members_submit',
		) );

		/* After Property Submit Redirect Page */
		$wp_customize->add_setting( 'inspiry_property_submit_redirect_page', array(
			'type'              => 'option',
			'sanitize_callback' => 'inspiry_sanitize_select',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'inspiry_property_submit_redirect_page', array(
			'label'       => esc_html__( 'Redirect to Selected Page After Submission', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'This not applies on guest submission.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_members_submit',
			'choices'     => RH_Data::get_pages_array(),
		) );

		/* Submit Notice */
		$wp_customize->add_setting( 'theme_submit_notice_email', array(
			'type'              => 'option',
			'default'           => get_option( 'admin_email' ),
			'sanitize_callback' => 'sanitize_email',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'theme_submit_notice_email', array(
			'label'   => esc_html__( 'Email Address to Receive Submission Notices', RH_TEXT_DOMAIN ),
			'type'    => 'email',
			'section' => 'inspiry_members_submit',
		) );

		// Submit Property Labels
		$wp_customize->add_section( 'realhomes_submit_property_labels', array(
			'title' => esc_html__( 'Submit Property Labels', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// Property Title Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_title_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property Title', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_title_label', array(
			'label'       => esc_html__( 'Property Title', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Title Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Address Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_address_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Address', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_address_label', array(
			'label'       => esc_html__( 'Property Address', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Address Field in the MAP section', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Find Address Button Label
		$wp_customize->add_setting( 'realhomes_submit_property_find_address_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Find Address', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_find_address_label', array(
			'label'       => esc_html__( 'Find Address', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Find Address Button in the map section', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Description Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_description_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property Description', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_description_label', array(
			'label'       => esc_html__( 'Property Description', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Description Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Price Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_price_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Sale or Rent Price', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_price_label', array(
			'label'       => esc_html__( 'Property Price', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Price Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Old Price Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_old_price_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Old Price', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_old_price_label', array(
			'label'       => esc_html__( 'Property Old Price', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Old Price Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Price Prefix Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_price_prefix_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Price Prefix Text', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_price_prefix_label', array(
			'label'       => esc_html__( 'Property Price Prefix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Price Prefix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Price Postfix Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_price_postfix_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Price Postfix Text', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_price_postfix_label', array(
			'label'       => esc_html__( 'Property Price Postfix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Price Postfix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property ID Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_id_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property ID', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_id_label', array(
			'label'       => esc_html__( 'Property ID', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property ID Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Parent Property Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_parent_property_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Parent Property', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_parent_property_label', array(
			'label'       => esc_html__( 'Parent Property', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Parent Property Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Type Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_type_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Type', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_type_label', array(
			'label'       => esc_html__( 'Property Type', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Type Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Status Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_status_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Status', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_status_label', array(
			'label'       => esc_html__( 'Property Status', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Status Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Bedroom Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_bedroom_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Bedroom', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_bedroom_label', array(
			'label'       => esc_html__( 'Property Bedroom', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Bedroom Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Bathroom Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_bathroom_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Bathroom', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_bathroom_label', array(
			'label'       => esc_html__( 'Property Bathroom', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Bathroom Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Garage Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_garage_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Garages or Parking Spaces', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_garage_label', array(
			'label'       => esc_html__( 'Property Garage', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Garage Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Area Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_area_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Area', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_area_label', array(
			'label'       => esc_html__( 'Property Area', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Area Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Area Postfix Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_area_postfix_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Area Postfix', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_area_postfix_label', array(
			'label'       => esc_html__( 'Property Area Postfix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Area Postfix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Lot Size Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_lot_size_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Lot Size', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_lot_size_label', array(
			'label'       => esc_html__( 'Property Lot Size', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Lot Size Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Lot Size Postfix Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_lot_size_postfix_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Lot Size Postfix Text', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_lot_size_postfix_label', array(
			'label'       => esc_html__( 'Property Lot Size Postfix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Lot Size Postfix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Year Built Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_year_built_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Year Built', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_year_built_label', array(
			'label'       => esc_html__( 'Property Year Built', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Year Built Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Owner Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_owner_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property Owner', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_owner_label', array(
			'label'       => esc_html__( 'Property Owner', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label text for property owner field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Images Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_images_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property Images', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_images_label', array(
			'label'       => esc_html__( 'Property Images', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Images Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Gallery Type Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_gallery_type_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Change Gallery Type', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_gallery_type_label', array(
			'label'       => esc_html__( 'Change Gallery Type', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Change Gallery Type Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Attachments Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_attachments_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property Attachments', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_attachments_label', array(
			'label'       => esc_html__( 'Property Attachments', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Attachments Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Homepage Slider Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_homepage_slider_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Do you want to add this property in Homepage Slider?', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_homepage_slider_label', array(
			'label'       => esc_html__( 'Homepage Slider', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Homepage Slider Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plans Section Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_plans_section_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Floor Plans', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_plans_section_label', array(
			'label'       => esc_html__( 'Section Floor Plans', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Plans section', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );


		// Property Floor Plan Name Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_name_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Floor Name', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_name_label', array(
			'label'       => esc_html__( 'Floor Name', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Name Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Image Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_image_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Floor Plan Image', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_image_label', array(
			'label'       => esc_html__( 'Floor Plan Image', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Plan Image Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Description Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_description_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Description', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_description_label', array(
			'label'       => esc_html__( 'Floor Plan Description', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Plan Description Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Price Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_price_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Floor Price', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_price_label', array(
			'label'       => esc_html__( 'Floor Price', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Price Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Price Postfix Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_price_postfix_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Price Postfix', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_price_postfix_label', array(
			'label'       => esc_html__( 'Floor Price Postfix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Price Postfix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Size Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_size_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Floor Size', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_size_label', array(
			'label'       => esc_html__( 'Floor Size', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Size Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Size Postfix Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_size_postfix_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Size Postfix', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_size_postfix_label', array(
			'label'       => esc_html__( 'Floor Size Postfix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Size Postfix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Bedrooms Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_beds_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Bedrooms', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_beds_label', array(
			'label'       => esc_html__( 'Floor Bedrooms Postfix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Bedrooms Postfix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Floor Plan Bathrooms Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_floor_baths_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Bathrooms', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_floor_baths_label', array(
			'label'       => esc_html__( 'Floor Bathrooms Postfix', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Floor Bathrooms Postfix Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// 360 Virtual Tour Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_virtual_tour_label', array(
			'type'              => 'option',
			'default'           => esc_html__( '360 Virtual Tour', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_virtual_tour_label', array(
			'label'       => esc_html__( 'Property 360 Virtual Tour', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property 360 Virtual Tour Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Additional Details Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_additional_details_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Additional Details', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_additional_details_label', array(
			'label'       => esc_html__( 'Property Additional Details', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Additional Details Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Features Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_features_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Features', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_features_label', array(
			'label'       => esc_html__( 'Property Features', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Features Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Label Text Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_label_text', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property Label Text', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_label_text', array(
			'label'       => esc_html__( 'Property Label Text', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Label Text Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Label Text Sub Heading Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_label_text_sub', array(
			'type'              => 'option',
			'default'           => esc_html__( 'You can add a property label to display on property thumbnails. Example: Hot Deal', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_label_text_sub', array(
			'label'       => esc_html__( 'Property Label Text Sub Heading', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Label Text Sub Heading', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Label Background Color Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_label_bg_color', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Label Background Color', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_label_bg_color', array(
			'label'       => esc_html__( 'Label Background Color', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Label Background Color Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Background Color Sub Heading Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_label_bg_sub', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Set a label background color. Otherwise label text will be displayed with transparent background.', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_label_bg_sub', array(
			'label'       => esc_html__( 'Background Color Sub Heading', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Sub Heading for Label Background Color', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Energy Performance Section Label
		$wp_customize->add_setting( 'realhomes_submit_property_ep_section_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Energy Performance', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_ep_section_label', array(
			'label'       => esc_html__( 'Property Energy Performance Section', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Energy Performance Section', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Energy Class Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_energy_class_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Energy Class', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_energy_class_label', array(
			'label'       => esc_html__( 'Property Energy Class', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Energy Class Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Energy Performance Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_energy_performance_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Energy Performance', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_energy_performance_label', array(
			'label'       => esc_html__( 'Property Energy Performance', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Energy Performance Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// EPC Current Rating Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_epc_current_rating_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'EPC Current Rating', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_epc_current_rating_label', array(
			'label'       => esc_html__( 'Property EPC Current Rating', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property EPC Current Rating Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// EPC Potential Rating Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_epc_potential_rating_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'EPC Potential Rating', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_epc_potential_rating_label', array(
			'label'       => esc_html__( 'Property EPC Potential Rating', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property EPC Potential Rating Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Agent Display Label
		$wp_customize->add_setting( 'realhomes_submit_property_agent_info_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'What to display in agent information box?', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_agent_info_label', array(
			'label'       => esc_html__( 'What to display in agent information box?', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Agent Information section', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Agent Display Option One Label
		$wp_customize->add_setting( 'realhomes_submit_property_agent_option_one_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'None ( Agent information box will not be displayed )', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_agent_option_one_label', array(
			'label'       => esc_html__( 'First Agent Field Options', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for First Agent Field Option', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Agent Display Option Two Label
		$wp_customize->add_setting( 'realhomes_submit_property_agent_option_two_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'My profile information.', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_agent_option_two_label', array(
			'label'       => esc_html__( 'Second Agent Field Options', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Second Agent Field Option', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Agent Display Option Two Sub Label
		$wp_customize->add_setting( 'realhomes_submit_property_agent_option_two_sub_label', array(
			'type'              => 'option',
			'default'           => esc_html__( '( Edit Profile Information )', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_agent_option_two_sub_label', array(
			'label'       => esc_html__( '( Edit Profile Information )', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Agent Field Options', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Agent Display Option Three Label
		$wp_customize->add_setting( 'realhomes_submit_property_agent_option_three_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Display agent(s) information.', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_agent_option_three_label', array(
			'label'       => esc_html__( 'Third Agent Field Options', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Third Agent Field Option', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Owner Name Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_owner_name_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Property Owner Name', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_owner_name_label', array(
			'label'       => esc_html__( 'Property Owner Name Field', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Property Owner Name Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Owner Contact Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_owner_contact_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Owner Contact', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_owner_contact_label', array(
			'label'       => esc_html__( 'Owner Contact Field', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Owner Contact Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Property Owner Address Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_owner_address_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Owner Address', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_owner_address_label', array(
			'label'       => esc_html__( 'Owner Address Field', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Owner Address Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// Message to the Reviewer Field Label
		$wp_customize->add_setting( 'realhomes_submit_property_message_to_the_reviewer_label', array(
			'type'              => 'option',
			'default'           => esc_html__( 'Message to the Reviewer', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_submit_property_message_to_the_reviewer_label', array(
			'label'       => esc_html__( 'Message to the Reviewer Field', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Label Text for Message to the Reviewer Field', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'realhomes_submit_property_labels',
		) );

		// My Properties
		$wp_customize->add_section( 'inspiry_members_properties', array(
			'title' => esc_html__( 'My Properties', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// My Properties Module
		$wp_customize->add_setting( 'inspiry_properties_module_display', array(
			'type'              => 'option',
			'default'           => 'true',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_properties_module_display', array(
			'label'   => esc_html__( 'My Properties Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_properties',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		if ( ! inspiry_is_membership_enabled() ) {
			// Property Activate/Deactivate
			$wp_customize->add_setting( 'realhomes_property_activate_controls', array(
				'type'              => 'option',
				'default'           => 'false',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_property_activate_controls', array(
				'label'   => esc_html__( 'Property Activate/Deactivate Control', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_members_properties',
				'choices' => array(
					'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
				)
			) );
		}

		if ( function_exists( 'rvr_is_enabled' ) && rvr_is_enabled() ) {
			// Bookings Section
			$wp_customize->add_section( 'realhomes_dashboard_bookings', array(
				'title' => esc_html__( 'Bookings & Reservations', RH_TEXT_DOMAIN ),
				'panel' => 'inspiry_dashboard_panel',
			) );

			// Bookings Module
			$wp_customize->add_setting( 'realhomes_bookings_module_display', array(
				'type'              => 'option',
				'default'           => 'true',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_bookings_module_display', array(
				'label'   => esc_html__( 'Bookings Module', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'realhomes_dashboard_bookings',
				'choices' => array(
					'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
				),
			) );

			// Reservations Module
			$wp_customize->add_setting( 'realhomes_reservations_module_display', array(
				'type'              => 'option',
				'default'           => 'true',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_reservations_module_display', array(
				'label'   => esc_html__( 'Reservations Module', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'realhomes_dashboard_bookings',
				'choices' => array(
					'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
				),
			) );

			// Invoices Module
			$wp_customize->add_setting( 'realhomes_invoices_module_display', array(
				'type'              => 'option',
				'default'           => 'true',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_invoices_module_display', array(
				'label'   => esc_html__( 'Invoices Module', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'realhomes_dashboard_bookings',
				'choices' => array(
					'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
				),
			) );
		}

		// Agents Section
		$wp_customize->add_section( 'realhomes_dashboard_agents_section', array(
			'title' => esc_html__( 'Agents', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// Agencies Section
		$wp_customize->add_section( 'realhomes_dashboard_agencies_section', array(
			'title' => esc_html__( 'Agencies', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// Agencies Module
		$wp_customize->add_setting( 'realhomes_agencies_module_display', array(
			'type'              => 'option',
			'default'           => 'false',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_agencies_module_display', array(
			'label'   => esc_html__( 'Agencies Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_dashboard_agencies_section',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'realhomes_add_agency_module_display', array(
			'type'              => 'option',
			'default'           => 'false',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_add_agency_module_display', array(
			'label'   => esc_html__( 'Add New Agency Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_dashboard_agencies_section',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// Submitted agency status
		$wp_customize->add_setting( 'realhomes_submitted_agency_status', array(
			'type'              => 'option',
			'default'           => 'pending',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_submitted_agency_status', array(
			'label'   => esc_html__( 'Default Status for Submitted Agency', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'realhomes_dashboard_agencies_section',
			'choices' => array(
				'pending' => esc_html__( 'Pending ( Recommended )', RH_TEXT_DOMAIN ),
				'publish' => esc_html__( 'Publish', RH_TEXT_DOMAIN ),
			),
		) );

		// Updated agency status
		$wp_customize->add_setting( 'realhomes_updated_agency_status', array(
			'type'              => 'option',
			'default'           => 'publish',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_updated_agency_status', array(
			'label'   => esc_html__( 'Default Status for Updated Agency', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'realhomes_dashboard_agencies_section',
			'choices' => array(
				'publish' => esc_html__( 'Publish', RH_TEXT_DOMAIN ),
				'pending' => esc_html__( 'Pending ( Recommended )', RH_TEXT_DOMAIN ),
			),
		) );

		// After agency submit redirect Page
		$wp_customize->add_setting( 'realhomes_after_agency_submit_redirect_page', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_after_agency_submit_redirect_page', array(
			'label'       => esc_html__( 'Redirect to Selected Page After Submission', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Choose a page to redirect users to it after successful submission an agency. Keeping it on the default page is recommended for better user experience.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'realhomes_dashboard_agencies_section',
			'choices'     => RH_Data::get_pages_array(),
		) );

		$wp_customize->add_setting( 'realhomes_agency_submit_notice_email', array(
			'type'              => 'option',
			'default'           => get_option( 'admin_email' ),
			'sanitize_callback' => 'sanitize_email',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_agency_submit_notice_email', array(
			'label'   => esc_html__( 'Email Address to Receive Submission Notices', RH_TEXT_DOMAIN ),
			'type'    => 'email',
			'section' => 'realhomes_dashboard_agencies_section',
		) );

		// Agents Module
		$wp_customize->add_setting( 'realhomes_agents_module_display', array(
			'type'              => 'option',
			'default'           => 'false',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_agents_module_display', array(
			'label'   => esc_html__( 'Agents Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_dashboard_agents_section',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'realhomes_add_agent_module_display', array(
			'type'              => 'option',
			'default'           => 'false',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_add_agent_module_display', array(
			'label'   => esc_html__( 'Add New Agent Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_dashboard_agents_section',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// Submitted agent status
		$wp_customize->add_setting( 'realhomes_submitted_agent_status', array(
			'type'              => 'option',
			'default'           => 'pending',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_submitted_agent_status', array(
			'label'   => esc_html__( 'Default Status for Submitted Agent', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'realhomes_dashboard_agents_section',
			'choices' => array(
				'pending' => esc_html__( 'Pending ( Recommended )', RH_TEXT_DOMAIN ),
				'publish' => esc_html__( 'Publish', RH_TEXT_DOMAIN ),
			),
		) );

		// Updated agent status
		$wp_customize->add_setting( 'realhomes_updated_agent_status', array(
			'type'              => 'option',
			'default'           => 'publish',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_updated_agent_status', array(
			'label'   => esc_html__( 'Default Status for Updated Agent', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'realhomes_dashboard_agents_section',
			'choices' => array(
				'publish' => esc_html__( 'Publish', RH_TEXT_DOMAIN ),
				'pending' => esc_html__( 'Pending ( Recommended )', RH_TEXT_DOMAIN ),
			),
		) );

		// After agent submit redirect Page
		$wp_customize->add_setting( 'realhomes_after_agent_submit_redirect_page', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_after_agent_submit_redirect_page', array(
			'label'       => esc_html__( 'Redirect to Selected Page After Submission', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Choose a page to redirect users to it after successful submission an agent. Keeping it on the default page is recommended for better user experience.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'realhomes_dashboard_agents_section',
			'choices'     => RH_Data::get_pages_array(),
		) );

		$wp_customize->add_setting( 'realhomes_agent_submit_notice_email', array(
			'type'              => 'option',
			'default'           => get_option( 'admin_email' ),
			'sanitize_callback' => 'sanitize_email',
			'transport'         => 'postMessage',
		) );
		$wp_customize->add_control( 'realhomes_agent_submit_notice_email', array(
			'label'   => esc_html__( 'Email Address to Receive Submission Notices', RH_TEXT_DOMAIN ),
			'type'    => 'email',
			'section' => 'realhomes_dashboard_agents_section',
		) );

		// My profile
		$wp_customize->add_section( 'inspiry_members_profile', array(
			'title' => esc_html__( 'My Profile', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// My profile module
		$wp_customize->add_setting( 'inspiry_profile_module_display', array(
			'type'              => 'option',
			'default'           => 'true',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_profile_module_display', array(
			'label'   => esc_html__( 'My Profile Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_profile',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// My favorites
		$wp_customize->add_section( 'inspiry_members_favorites', array(
			'title' => esc_html__( 'My Favorites', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		// My favorites module
		$wp_customize->add_setting( 'inspiry_favorites_module_display', array(
			'type'              => 'option',
			'default'           => 'true',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_favorites_module_display', array(
			'label'   => esc_html__( 'My Favorites Module', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_favorites',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// Allow sharing favorites list
		$wp_customize->add_setting( 'realhomes_dashboard_allow_favorites_list_share', array(
			'type'              => 'option',
			'default'           => 'true',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_allow_favorites_list_share', array(
			'label'   => esc_html__( 'Allow Sharing Favorites List', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_favorites',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		// Enable/Disable add to favorites
		$wp_customize->add_setting( 'theme_enable_fav_button', array(
			'type'              => 'option',
			'default'           => 'true',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'theme_enable_fav_button', array(
			'label'   => esc_html__( 'Add to Favorites Button on Property Detail Page', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_favorites',
			'choices' => array(
				'true'  => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		// Require login to favorite properties
		$wp_customize->add_setting( 'inspiry_login_on_fav', array(
			'type'              => 'option',
			'default'           => 'no',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_login_on_fav', array(
			'label'   => esc_html__( 'Require Login for Add to Favorites.', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_favorites',
			'choices' => array(
				'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
				'no'  => esc_html__( 'No', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_section(
			'realhomes_saved_searches',
			array(
				'title' => esc_html__( 'Saved Searches', RH_TEXT_DOMAIN ),
				'panel' => 'inspiry_dashboard_panel',
			)
		);

		$wp_customize->add_setting(
			'realhomes_saved_searches_enabled', array(
				'type'              => 'option',
				'default'           => 'yes',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			)
		);

		$wp_customize->add_control(
			'realhomes_saved_searches_enabled',
			array(
				'label'       => esc_html__( 'Enable Saved Searches? ', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Enabling this feature will display a "Save Search" button at the top of search results. It will also add a "Saved Searches" menu item to the user menu.', RH_TEXT_DOMAIN ),
				'type'        => 'radio',
				'section'     => 'realhomes_saved_searches',
				'choices'     => array(
					'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RH_TEXT_DOMAIN ),
				),
			)
		);

		$wp_customize->add_setting(
			'realhomes_search_emails_frequency', array(
				'type'              => 'option',
				'default'           => 'daily',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			)
		);

		$wp_customize->add_control(
			'realhomes_search_emails_frequency',
			array(
				'label'   => esc_html__( 'Search Emails Frequency', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'realhomes_saved_searches',
				'choices' => array(
					'daily'  => esc_html__( 'Daily', RH_TEXT_DOMAIN ),
					'weekly' => esc_html__( 'Weekly', RH_TEXT_DOMAIN ),
				),
			)
		);

		// Saved searches for non-logged in users
		$wp_customize->add_setting(
			'realhomes_saved_searches_required_login', array(
				'type'              => 'option',
				'default'           => 'yes',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			)
		);

		$wp_customize->add_control(
			'realhomes_saved_searches_required_login',
			array(
				'label'   => esc_html__( 'Required Login For Saved Searches', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'realhomes_saved_searches',
				'choices'     => array(
					'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RH_TEXT_DOMAIN ),
				)
			)
		);

		$wp_customize->add_setting(
			'realhomes_saved_searches_labels_separator',
			array(
				'sanitize_callback' => 'inspiry_sanitize',
				'transport'         => 'postMessage',
			)
		);
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'realhomes_saved_searches_labels_separator',
				array(
					'section' => 'realhomes_saved_searches',
				)
			)
		);

		$wp_customize->add_setting(
			'realhomes_save_search_btn_label',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'Save Search', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			'realhomes_save_search_btn_label',
			array(
				'label'   => esc_html__( 'Save Search Button Label', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'realhomes_saved_searches',
			)
		);

		$wp_customize->add_setting(
			'realhomes_search_saved_btn_label',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'Search Saved', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			'realhomes_search_saved_btn_label',
			array(
				'label'   => esc_html__( 'Search Saved Button Label', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'realhomes_saved_searches',
			)
		);

		$wp_customize->add_setting(
			'realhomes_save_search_btn_tooltip',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'Receive email notification for the latest properties matching your search criteria.', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'realhomes_save_search_btn_tooltip',
			array(
				'label'   => esc_html__( 'Save Search Button Tooltip Text', RH_TEXT_DOMAIN ),
				'type'    => 'textarea',
				'section' => 'realhomes_saved_searches',
			)
		);

		$wp_customize->add_setting(
			'realhomes_saved_searches_label',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'My Saved Searches', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'realhomes_saved_searches_label',
			array(
				'label'   => esc_html__( '"My Saved Searches" Menu Button and Page Name', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'realhomes_saved_searches',
			)
		);

		$wp_customize->add_setting(
			'realhomes_saved_searches_all_users_label',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'All Users Saved Searches', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'realhomes_saved_searches_all_users_label',
			array(
				'label'       => esc_html__( '"All Users Saved Searches" Sub Menu Button and Page Name', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Sub Menu will be displayed only for "Administrator" ', RH_TEXT_DOMAIN ),
				'type'        => 'text',
				'section'     => 'realhomes_saved_searches',
			)
		);

		/**
		 * Saved Search Email Template Setting
		 */
		$wp_customize->add_setting(
			'realhomes_saved_searches_email_separator',
			array(
				'sanitize_callback' => 'inspiry_sanitize',
				'transport'         => 'postMessage',
			)
		);
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'realhomes_saved_searches_email_separator',
				array(
					'section' => 'realhomes_saved_searches',
				)
			)
		);

		// Email subject.
		$wp_customize->add_setting(
			'realhomes_saved_search_email_subject',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'Check Out Latest Properties Matching Your Saved Search Criteria', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'realhomes_saved_search_email_subject',
			array(
				'label'   => esc_html__( 'Saved Search Email Subject', RH_TEXT_DOMAIN ),
				'type'    => 'textarea',
				'section' => 'realhomes_saved_searches',
			)
		);

		// Email header text.
		$wp_customize->add_setting(
			'realhomes_saved_search_email_header',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'Following new properties are listed matching your search criteria. You can check the [search results here].', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'realhomes_saved_search_email_header',
			array(
				'label'       => esc_html__( 'Saved Search Email Header Text', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Wrapped text within square brackets [] will be linked to the saved search results page.', RH_TEXT_DOMAIN ),
				'type'        => 'textarea',
				'section'     => 'realhomes_saved_searches',
			)
		);

		// Email footer text.
		$wp_customize->add_setting(
			'realhomes_saved_search_email_footer',
			array(
				'type'              => 'option',
				'default'           => esc_html__( 'To stop getting such emails, Simply remove related saved search from your account.', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			'realhomes_saved_search_email_footer',
			array(
				'label'   => esc_html__( 'Saved Search Email Footer Text', RH_TEXT_DOMAIN ),
				'type'    => 'textarea',
				'section' => 'realhomes_saved_searches',
			)
		);

		// User & Agent/Agency Sync
		$wp_customize->add_section(
			'inspiry_members_user_sync',
			array(
				'title' => esc_html__( 'User & Agent/Agency Sync', RH_TEXT_DOMAIN ),
				'panel' => 'inspiry_dashboard_panel',
			)
		);

		/* Enable/Disable User Sync with Agents/Agencies */
		$wp_customize->add_setting( 'realhomes_users_options_notice' );
		$wp_customize->add_control(
			new Realhomes_Customizer_Notice_Control( $wp_customize, 'realhomes_users_options_notice',
				array(
					'label'             => esc_html__( 'Notice:', RH_TEXT_DOMAIN ),
					'description'       => sprintf( esc_html__( 'All users synchronization with post types (agent, agency, etc) related option are moved to %s', RH_TEXT_DOMAIN ), '<a class="customizer-link" target="_blank" href=' . admin_url() . 'admin.php?page=ere-settings&tab=users' . '>' . esc_html__( 'ERE User options.', RH_TEXT_DOMAIN ) . '</a>' ),
					'section'           => 'inspiry_members_user_sync',
					'sanitize_callback' => 'wp_kses_post'
				) )
		);

		/**
		 * Dashboard customizer settings for membership plugin pages.
		 * @since  3.12
		 */
		if ( class_exists( 'IMS_Helper_Functions' ) ) {

			// Membership Section
			$wp_customize->add_section( 'inspiry_membership_section', array(
				'title' => esc_html__( 'Membership', RH_TEXT_DOMAIN ),
				'panel' => 'inspiry_dashboard_panel',
			) );

			$wp_customize->add_setting( 'inspiry_disable_submit_property', array(
				'type'              => 'option',
				'default'           => 'true',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_disable_submit_property', array(
				'label'   => esc_html__( 'Disable Submit Property Functionality for Users without Membership Package?', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_membership_section',
				'choices' => array(
					'true'  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'No', RH_TEXT_DOMAIN )
				),
			) );

			$wp_customize->add_setting( 'inspiry_text_before_price', array(
				'type'              => 'option',
				'default'           => esc_html__( 'Starting at', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_control( 'inspiry_text_before_price', array(
				'label'   => esc_html__( 'Membership Package Text Before Price', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_membership_section',
			) );

			$wp_customize->add_setting( 'inspiry_package_btn_text', array(
				'type'              => 'option',
				'default'           => esc_html__( 'Get Started', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_control( 'inspiry_package_btn_text', array(
				'label'   => esc_html__( 'Membership Package Button Text', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_membership_section',
			) );

			$wp_customize->add_setting( 'inspiry_current_package_btn_text', array(
				'type'              => 'option',
				'default'           => esc_html__( 'Current Package', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_control( 'inspiry_current_package_btn_text', array(
				'label'   => esc_html__( 'Membership Current Package Button Text', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_membership_section',
			) );

			$wp_customize->add_setting( 'inspiry_checkout_badges_display', array(
				'type'              => 'option',
				'default'           => 'show',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_checkout_badges_display', array(
				'label'   => esc_html__( 'Checkout Page Payment Methods Badges', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_membership_section',
				'choices' => array(
					'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
					'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN )
				),
			) );

			$wp_customize->add_setting( 'inspiry_order_dialog_heading', array(
				'type'              => 'option',
				'default'           => esc_html__( 'Thank you!', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_control( 'inspiry_order_dialog_heading', array(
				'label'   => esc_html__( 'Order Page Dialog Box Heading', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_membership_section',
			) );

			$wp_customize->add_setting( 'realhomes_order_dialog_description', array(
				'type'              => 'option',
				'default'           => esc_html__( 'For payment instructions please check your email.', RH_TEXT_DOMAIN ),
				'transport'         => 'postMessage',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_control( 'realhomes_order_dialog_description', array(
				'label'   => esc_html__( 'Order Page Dialog Box Description', RH_TEXT_DOMAIN ),
				'type'    => 'text',
				'section' => 'inspiry_membership_section',
			) );
		}

		/**
		 * Customizer settings generated using default menu labels to get custom labels for dashboard sidebar menu.
		 * @since  4.1.0
		 */
		$menu_default_labels = realhomes_dashboard_menu_items_default_labels();
		if ( is_array( $menu_default_labels ) && ! empty( $menu_default_labels ) ) {

			$wp_customize->add_section( 'realhomes_dashboard_menu_custom_labels', array(
				'title' => esc_html__( 'Dashboard Menu Custom Labels', RH_TEXT_DOMAIN ),
				'panel' => 'inspiry_dashboard_panel',
			) );

			foreach ( $menu_default_labels as $menu_item => $default_labels ) {

				if ( isset( $default_labels['0'] ) ) {
					$menu_title = $default_labels['0'];

					// Menu heading
					$heading = 'realhomes_dashboard_' . $menu_item . '_section_heading';
					$wp_customize->add_setting( $heading, array( 'sanitize_callback' => 'sanitize_text_field', ) );
					$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, $heading,
						array(
							'label'   => $menu_title,
							'section' => 'realhomes_dashboard_menu_custom_labels',
						)
					) );

					// Menu title setting
					$menu_id = 'realhomes_dashboard_' . $menu_item . '_menu_label';
					$wp_customize->add_setting( $menu_id, array(
						'type'              => 'option',
						'default'           => $menu_title,
						'sanitize_callback' => 'sanitize_text_field',
					) );
					$wp_customize->add_control( $menu_id, array(
						'label'   => esc_html__( 'Menu Title', RH_TEXT_DOMAIN ),
						'section' => 'realhomes_dashboard_menu_custom_labels',
					) );

					if ( isset( $default_labels['1'] ) ) {
						// Page title setting
						$page_id = 'realhomes_dashboard_' . $menu_item . '_page_label';
						$wp_customize->add_setting( $page_id, array(
							'type'              => 'option',
							'default'           => $default_labels['1'],
							'transport'         => 'postMessage',
							'sanitize_callback' => 'sanitize_text_field',
						) );
						$wp_customize->add_control( $page_id, array(
							'label'   => esc_html__( 'Page Title', RH_TEXT_DOMAIN ),
							'section' => 'realhomes_dashboard_menu_custom_labels',
						) );
					}
				}
			}
		}

		/**
		 * Dashboard styles customizer settings.
		 * @since  3.12
		 */
		$wp_customize->add_section( 'inspiry_dashboard_styles', array(
			'title' => esc_html__( 'Styles', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_dashboard_panel',
		) );

		$wp_customize->add_setting( 'realhomes_dashboard_color_scheme', array(
			'type'              => 'option',
			'default'           => 'default',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_dashboard_color_scheme', array(
			'label'   => esc_html__( 'Color Scheme', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'inspiry_dashboard_styles',
			'choices' => realhomes_dashboard_color_schemes_list(),
		) );

		$color_settings = realhomes_dashboard_color_settings();
		if ( is_array( $color_settings ) && ! empty( $color_settings ) ) {
			foreach ( $color_settings as $setting ) {
				$id = 'inspiry_dashboard_' . $setting['id'];
				$wp_customize->add_setting( $id, array(
					'type'              => 'option',
					'default'           => $setting['default'],
					'sanitize_callback' => 'sanitize_hex_color',
				) );
				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $id,
					array(
						'label'           => $setting['label'],
						'section'         => 'inspiry_dashboard_styles',
						'active_callback' => 'realhomes_is_dashboard_custom_color_scheme'
					)
				) );
			}
		}
	}

	add_action( 'customize_register', 'inspiry_dashboard_customizer' );
}

if ( ! function_exists( 'inspiry_dashboard_defaults' ) ) {
	/**
	 * Set default values for dashboard settings
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	function inspiry_dashboard_defaults( WP_Customize_Manager $wp_customize ) {
		$dashboard_settings_ids = array(
			'theme_restricted_level',
			'theme_submitted_status',
			'theme_submit_default_address',
			'theme_submit_default_location',
			'theme_submit_message',
			'theme_submit_notice_email',
			'theme_enable_fav_button',
			'theme_submit_button_text',
			'inspiry_guest_submission',
			'inspiry_submit_property_fields',
			'inspiry_submit_property_terms_text',
			'inspiry_updated_property_status',
			'inspiry_user_greeting_text',
			'inspiry_dashboard_page_display',
			'realhomes_dashboard_header_search',
			'inspiry_dashboard_posts_per_page',
			'inspiry_submit_property_module_display',
			'inspiry_dashboard_submit_page_layout',
			'inspiry_show_submit_on_login',
			'inspiry_submit_property_terms_require',
			'inspiry_submit_max_number_images',
			'inspiry_allowed_max_attachments',
			'inspiry_properties_module_display',
			'inspiry_profile_module_display',
			'inspiry_favorites_module_display',
			'inspiry_login_on_fav',
			'inspiry_user_sync',
			'inspiry_user_sync_avatar_fallback',
			'inspiry_disable_submit_property',
			'inspiry_text_before_price',
			'inspiry_package_btn_text',
			'inspiry_checkout_badges_display',
			'inspiry_order_dialog_heading',
		);
		inspiry_initialize_defaults( $wp_customize, $dashboard_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_dashboard_defaults' );
}

if ( ! function_exists( 'inspiry_is_submit_property_field_terms' ) ) {
	/**
	 * Check if terms and condidtions field is enabled on the property submit page.
	 *
	 * @return bool|int
	 */
	function inspiry_is_submit_property_field_terms() {

		$term_field_check = get_option( 'inspiry_submit_property_fields' );

		return ( false != strpos( implode( ' ', $term_field_check ), 'terms-conditions' ) ) ? true : false;
	}
}

if ( ! function_exists( 'inspiry_user_sync' ) ) {
	/**
	 * Check if User Sync function is enabled.
	 *
	 * @param object $control complete setting control.
	 *
	 * @return bool
	 */
	function inspiry_user_sync( $control ) {
		if ( 'true' === $control->manager->get_setting( 'inspiry_user_sync' )->value() ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'realhomes_is_dashboard_custom_color_scheme' ) ) {
	/**
	 * Check for the dashboard custom color scheme.
	 *
	 * @since 4.0.0
	 *
	 * @return bool
	 */
	function realhomes_is_dashboard_custom_color_scheme() {

		if ( 'custom' === get_option( 'realhomes_dashboard_color_scheme', 'default' ) ) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'realhomes_is_default_agent_assignment' ) ) {
	/**
	 * Checks if the agent assignment option is set to 'default'.
	 *
	 * This function retrieves the 'realhomes_agent_assignment_option' value from
	 * WordPress options and verifies if it is set to 'default'.
	 *
	 * @since 4.0.0
	 *
	 * @return bool Returns true if agent assignment option is 'default', false otherwise.
	 */
	function realhomes_is_default_agent_assignment() {
		return ( 'default' === get_option( 'realhomes_agent_assignment_option', 'default' ) );
	}
}

if ( ! function_exists( 'realhomes_display_auto_user_agent_assignment' ) ) {
	/**
	 * Determines if the Auto User/Agent Assignment option should be shown.
	 *
	 * @since 4.4.0
	 *
	 * @return bool
	 */
	function realhomes_display_auto_user_agent_assignment() {
		$enabled_fields = get_option( 'inspiry_submit_property_fields', array() );

		if ( is_array( $enabled_fields ) && in_array( 'agent', $enabled_fields, true ) ) {
			// If 'agent' is selected, DO NOT show the auto assignment option
			return false;
		}

		// 'agent' is not selected, so show the auto assignment option
		return true;
	}
}
