<?php
/**
 * Properties Templates and Archive Pages Settings
 *
 * @package realhomes/customizer
 */

if ( ! function_exists( 'inspiry_templates_and_archive_customizer' ) ) :
	function inspiry_templates_and_archive_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Properties Templates and Taxonomy Archives Section
		 */
		$wp_customize->add_section( 'inspiry_properties_templates_and_archive', array(
			'title'    => esc_html__( 'Properties Templates & Archive', RH_TEXT_DOMAIN ),
			'priority' => 124,
		) );

		if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
			/* Header Banner or None */
			$wp_customize->add_setting( 'inspiry_listing_header_variation', array(
				'type'              => 'option',
				'default'           => 'banner',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_listing_header_variation', array(
				'label'       => esc_html__( 'Header Variation', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'For properties templates and taxonomy archive pages.', RH_TEXT_DOMAIN ),
				'type'        => 'radio',
				'section'     => 'inspiry_properties_templates_and_archive',
				'choices'     => array(
					'banner' => esc_html__( 'Banner', RH_TEXT_DOMAIN ),
					'none'   => esc_html__( 'None', RH_TEXT_DOMAIN ),
				),
			) );
		}
		if ( 'ultra' === INSPIRY_DESIGN_VARIATION ) {
			$wp_customize->add_setting( 'realhomes_elementor_property_archive_template', array(
				'type'              => 'option',
				'default'           => 'default',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'realhomes_elementor_property_archive_template', array(
				'label'       => esc_html__( 'Property Archive & Taxonomy Elementor Template', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Property Archive & Taxonomy Template created using Elementor Page Builder. This option will be overridden if Elementor Pro version is being used to design Archive & Taxonomy.', RH_TEXT_DOMAIN ),
				'type'        => 'select',
				'section'     => 'inspiry_properties_templates_and_archive',
				'choices'     => realhomes_get_elementor_library(),
			) );
		}

		// Taxonomy name control on taxonomy templates
		$wp_customize->add_setting( 'realhomes_taxonomy_name_before_title', array(
			'type'              => 'option',
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_taxonomy_name_before_title', array(
			'label'       => esc_html__( 'Taxonomy Name With Term Title', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Show taxonomy name with term title on taxonomy listing template', RH_TEXT_DOMAIN ),
			'type'        => 'radio',
			'section'     => 'inspiry_properties_templates_and_archive',
			'choices'     => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			)
		) );

		/* Module Below Header  */
		$wp_customize->add_setting( 'theme_listing_module', array(
			'type'              => 'option',
			'default'           => 'simple-banner',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );

		if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
			$wp_customize->add_control( 'theme_listing_module', array(
				'label'       => esc_html__( 'Module Below Header', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'What to display in area below header on properties templates and taxonomy archive pages?', RH_TEXT_DOMAIN ),
				'type'        => 'radio',
				'section'     => 'inspiry_properties_templates_and_archive',
				'choices'     => array(
					'properties-map' => esc_html__( 'Map With Properties Markers', RH_TEXT_DOMAIN ),
					'simple-banner'  => esc_html__( 'Image Banner', RH_TEXT_DOMAIN ),
				),
			) );
		} else {
			$wp_customize->add_control( 'theme_listing_module', array(
				'label'       => esc_html__( 'Module Below Header', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'What to display in area below header on properties templates and taxonomy archive pages?', RH_TEXT_DOMAIN ),
				'type'        => 'radio',
				'section'     => 'inspiry_properties_templates_and_archive',
				'choices'     => array(
					'properties-map' => esc_html__( 'Map with Properties Markers', RH_TEXT_DOMAIN ),
					'simple-banner'  => esc_html__( 'None', RH_TEXT_DOMAIN ),
				),
			) );
		}

		$map_type = inspiry_get_maps_type();
		if ( 'google-maps' == $map_type ) {

			/* Google Map Type */
			$wp_customize->add_setting( 'inspiry_list_tax_map_type', array(
				'type'              => 'option',
				'default'           => 'global',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'inspiry_list_tax_map_type', array(
				'label'           => esc_html__( 'Google Map Type', RH_TEXT_DOMAIN ),
				'type'            => 'select',
				'section'         => 'inspiry_properties_templates_and_archive',
				'choices'         => array(
					'global'    => esc_html__( 'Global Default', RH_TEXT_DOMAIN ),
					'roadmap'   => esc_html__( 'RoadMap', RH_TEXT_DOMAIN ),
					'satellite' => esc_html__( 'Satellite', RH_TEXT_DOMAIN ),
					'hybrid'    => esc_html__( 'Hybrid', RH_TEXT_DOMAIN ),
					'terrain'   => esc_html__( 'Terrain', RH_TEXT_DOMAIN ),
				),
				'active_callback' => 'inspiry_listing_map_enabled',
			) );
		}

		// Skip Sticky Properties Option.
		$wp_customize->add_setting( 'inspiry_listing_skip_sticky', array(
			'type'              => 'option',
			'default'           => false,
			'sanitize_callback' => 'inspiry_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'inspiry_listing_skip_sticky', array(
			'label'   => esc_html__( 'Check to Skip Sticky Properties on Properties Templates. (Not Recommended)', RH_TEXT_DOMAIN ),
			'section' => 'inspiry_properties_templates_and_archive',
			'type'    => 'checkbox',
		) );

		// Global Ajax Pagination
		if ( 'classic' !== INSPIRY_DESIGN_VARIATION ) {
			$wp_customize->add_setting( 'realhomes_global_ajax_pagination', array(
				'type'              => 'option',
				'default'           => false,
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_global_ajax_pagination', array(
				'label'   => esc_html__( 'Enable AJAX Pagination Globally', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_properties_templates_and_archive',
				'choices' => array(
					true  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
					false => esc_html__( 'No', RH_TEXT_DOMAIN ),
				),
			) );

			$wp_customize->add_setting( 'realhomes_pagination_navigation_type', array(
				'type'              => 'option',
				'default'           => 'labels',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_pagination_navigation_type', array(
				'label'   => esc_html__( 'Pagination Navigation Type', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_properties_templates_and_archive',
				'choices' => array(
					'labels'  => esc_html__( 'Labels', RH_TEXT_DOMAIN ),
					'arrows'  => esc_html__( 'Arrows', RH_TEXT_DOMAIN ),
				)
			) );
		}

		$wp_customize->add_setting( 'realhomes_no_result_found_text', array(
			'type'              => 'option',
			'default'           => esc_html__( 'No Results Found!', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_no_result_found_text', array(
			'label'   => esc_html__( 'No Result Found Text', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_properties_templates_and_archive',
		) );

		if ( 'classic' !== INSPIRY_DESIGN_VARIATION ) {

			$wp_customize->add_setting( 'inspiry_section_label_properties_cards', array( 'sanitize_callback' => 'sanitize_text_field', ) );
			$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'inspiry_section_label_properties_cards', array(
					'label'   => esc_html__( 'Property Card', RH_TEXT_DOMAIN ),
					'section' => 'inspiry_properties_templates_and_archive',
				)
			) );

			if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
				$wp_customize->add_setting( 'inspiry_property_card_variation', array(
					'type'              => 'option',
					'default'           => '1',
					'sanitize_callback' => 'inspiry_sanitize_select',
				) );
				$wp_customize->add_control( 'inspiry_property_card_variation', array(
					'section' => 'inspiry_properties_templates_and_archive',
					'type'    => 'select',
					'label'   => esc_html__( 'Property Grid Card Global Design', RH_TEXT_DOMAIN ),
					'choices' => array(
						'1' => esc_html__( 'One', RH_TEXT_DOMAIN ),
						'2' => esc_html__( 'Two', RH_TEXT_DOMAIN ),
						'3' => esc_html__( 'Three', RH_TEXT_DOMAIN ),
						'4' => esc_html__( 'Four', RH_TEXT_DOMAIN ),
						'5' => esc_html__( 'Five', RH_TEXT_DOMAIN ),
					),
				) );
			} else {
				$wp_customize->add_setting( 'realhomes_property_card_variation', array(
					'type'              => 'option',
					'default'           => '1',
					'sanitize_callback' => 'inspiry_sanitize_select',
				) );
				$wp_customize->add_control( 'realhomes_property_card_variation', array(
					'section' => 'inspiry_properties_templates_and_archive',
					'type'    => 'select',
					'label'   => esc_html__( 'Global Property Grid Card Design', RH_TEXT_DOMAIN ),
					'choices' => array(
						'1' => esc_html__( 'One', RH_TEXT_DOMAIN ),
						'2' => esc_html__( 'Two', RH_TEXT_DOMAIN ),
					),
				) );
			}
		}

		if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {

			$wp_customize->add_setting( 'theme_listing_excerpt_length', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_text_field',
			) );

			$wp_customize->add_control( 'theme_listing_excerpt_length', array(
				'label'           => esc_html__( 'Excerpt Length for Property Card', RH_TEXT_DOMAIN ),
				'description'     => esc_html__( 'Leave empty for default behaviour.', RH_TEXT_DOMAIN ),
				'type'            => 'number',
				'section'         => 'inspiry_properties_templates_and_archive',
				'settings'        => 'theme_listing_excerpt_length',
				'active_callback' => function() {
					return ( '1' === get_option( 'inspiry_property_card_variation', '1' ) );
				},
			) );

			$wp_customize->add_setting( 'inspiry_property_date_format', array(
				'type'              => 'option',
				'default'           => 'dashboard',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'inspiry_property_date_format', array(
				'section'         => 'inspiry_properties_templates_and_archive',
				'type'            => 'select',
				'label'           => esc_html__( 'Select Date Format', RH_TEXT_DOMAIN ),
				'choices'         => array(
					'dashboard' => esc_html__( 'Default ( Dashboard > Settings > General )', RH_TEXT_DOMAIN ),
					'human'     => esc_html__( 'Human Readable', RH_TEXT_DOMAIN ),
				),
				'active_callback' => function() {
					return in_array( get_option( 'inspiry_property_card_variation', '1' ), array( '2', '3' ) );
				},
			) );

			$wp_customize->add_setting( 'inspiry_hide_property_address', array(
				'type'              => 'option',
				'default'           => 'no',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_hide_property_address', array(
				'label'           => esc_html__( 'Hide Property Address', RH_TEXT_DOMAIN ),
				'type'            => 'radio',
				'section'         => 'inspiry_properties_templates_and_archive',
				'choices'         => array(
					'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RH_TEXT_DOMAIN ),
				),
				'active_callback' => function() {
					return in_array( get_option( 'inspiry_property_card_variation', '1' ), array( '2', '3' ) );
				},
			) );

			$wp_customize->add_setting(
				'inspiry_address_lightbox_enable',
				array(
					'type'              => 'option',
					'default'           => 'enable',
					'sanitize_callback' => 'inspiry_sanitize_radio',
				)
			);
			$wp_customize->add_control(
				'inspiry_address_lightbox_enable', array(
					'label'           => esc_html__( 'Enable Map Lightbox On Address Click', RH_TEXT_DOMAIN ),
					'section'         => 'inspiry_properties_templates_and_archive',
					'type'            => 'radio',
					'choices'         => array(
						'enable'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
						'disable' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
					),
					'active_callback' => function() {
						return in_array( get_option( 'inspiry_property_card_variation', '1' ), array( '2', '3' ) );
					},
				)
			);

			$wp_customize->add_setting( 'inspiry_section_label_grid_templates', array( 'sanitize_callback' => 'sanitize_text_field', ) );
			$wp_customize->add_control( new Inspiry_Heading_Customize_Control(
				$wp_customize,
				'inspiry_section_label_grid_templates',
				array(
					'label'   => esc_html__( 'Grid Templates', RH_TEXT_DOMAIN ),
					'section' => 'inspiry_properties_templates_and_archive',
				)
			) );

			// Columns on Grid Template
			$wp_customize->add_setting( 'realhomes_grid_template_column', array(
				'type'              => 'option',
				'default'           => '2',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'realhomes_grid_template_column', array(
				'label'   => esc_html__( 'Number of Columns on Grid Template', RH_TEXT_DOMAIN ),
				'type'    => 'select',
				'section' => 'inspiry_properties_templates_and_archive',
				'choices' => array(
					'1' => 1,
					'2' => 2,
					'3' => 3,
				),
			) );

			// Columns on Grid Full-width Template
			$wp_customize->add_setting( 'realhomes_grid_fullwidth_template_column', array(
				'type'              => 'option',
				'default'           => '3',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'realhomes_grid_fullwidth_template_column', array(
				'label'   => esc_html__( 'Number of Columns on Grid Full-width Template', RH_TEXT_DOMAIN ),
				'type'    => 'select',
				'section' => 'inspiry_properties_templates_and_archive',
				'choices' => array(
					'2' => 2,
					'3' => 3,
					'4' => 4,
				),
			) );

		}

		if ( 'classic' !== INSPIRY_DESIGN_VARIATION ) {
			$get_stored_order = get_option( 'inspiry_property_card_meta' );

			$meta_fields = array(
				'bedrooms'   => esc_html__( 'Bedrooms', RH_TEXT_DOMAIN ),
				'bathrooms'  => esc_html__( 'Bathrooms', RH_TEXT_DOMAIN ),
				'area'       => esc_html__( 'Area', RH_TEXT_DOMAIN ),
				'garage'     => esc_html__( 'Garages/Parking', RH_TEXT_DOMAIN ),
				'year-built' => esc_html__( 'Year Built', RH_TEXT_DOMAIN ),
				'lot-size'   => esc_html__( 'Lot Size', RH_TEXT_DOMAIN ),
			);

			$default_meta_labels = array( 'bedrooms', 'bathrooms', 'area' );

			if ( inspiry_is_rvr_enabled() ) {
				$meta_fields['guests']   = esc_html__( 'Guests Capacity', RH_TEXT_DOMAIN );
				$meta_fields['min-stay'] = esc_html__( 'Min Stay', RH_TEXT_DOMAIN );
				$default_meta_labels[]   = 'guests';
			}

			$meta_fields = apply_filters( 'inspiry_sort_meta_label', $meta_fields );

			if ( ! empty( $get_stored_order ) && is_array( $get_stored_order ) ) {
				$unique_fields = array_intersect_key( array_flip( $get_stored_order ), $meta_fields );
				$meta_fields   = array_merge( $unique_fields, $meta_fields );
			}

			$wp_customize->add_setting(
				'inspiry_property_card_meta',
				array(
					'type'              => 'option',
					'default'           => $default_meta_labels,
					'sanitize_callback' => 'inspiry_sanitize_multiple_checkboxes',
				)
			);
			$wp_customize->add_control(
				new Inspiry_Multiple_Checkbox_Customize_Control_sortable(
					$wp_customize,
					'inspiry_property_card_meta',
					array(
						'section' => 'inspiry_properties_templates_and_archive',
						'label'   => esc_html__( 'Select & Sort Property Card Meta', RH_TEXT_DOMAIN ),
						'choices' => $meta_fields,
					)
				)
			);
		}

		$wp_customize->add_setting( 'inspiry_section_label_properties_archives', array( 'sanitize_callback' => 'sanitize_text_field', ) );
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control(
			$wp_customize,
			'inspiry_section_label_properties_archives',
			array(
				'label'   => esc_html__( 'Archive Pages', RH_TEXT_DOMAIN ),
				'section' => 'inspiry_properties_templates_and_archive',
			)
		) );

		// Layout
		$wp_customize->add_setting( 'theme_listing_layout', array(
			'type'              => 'option',
			'default'           => 'list',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'theme_listing_layout', array(
			'label'   => esc_html__( 'Default Layout for Archive Pages', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'inspiry_properties_templates_and_archive',
			'choices' => array(
				'list' => esc_html__( 'List', RH_TEXT_DOMAIN ),
				'grid' => esc_html__( 'Grid', RH_TEXT_DOMAIN ),
			),
		) );

		// Number of Properties
		$wp_customize->add_setting( 'theme_number_of_properties', array(
			'type'              => 'option',
			'default'           => '6',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'theme_number_of_properties', array(
			'label'       => esc_html__( 'Max Number of Properties on a Page', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Can be overridden for templates through page metabox.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_properties_templates_and_archive',
			'choices'     => array(
				'1'  => 1,
				'2'  => 2,
				'3'  => 3,
				'4'  => 4,
				'5'  => 5,
				'6'  => 6,
				'7'  => 7,
				'8'  => 8,
				'9'  => 9,
				'10' => 10,
				'11' => 11,
				'12' => 12,
				'13' => 13,
				'14' => 14,
				'15' => 15,
				'16' => 16,
				'17' => 17,
				'18' => 18,
				'19' => 19,
				'20' => 20,
			),
		) );

		// Sorting options
		$sorting_option_fields = realhomes_sorting_options_list();
		$wp_customize->add_setting(
			'realhomes_available_sorting_options',
			array(
				'type'              => 'option',
				'default'           => array( 'price-asc', 'price-desc', 'date-asc', 'date-desc' ),
				'sanitize_callback' => 'inspiry_sanitize_multiple_checkboxes',
			)
		);
		$wp_customize->add_control(
			new Inspiry_Multiple_Checkbox_Customize_Control_sortable(
				$wp_customize,
				'realhomes_available_sorting_options',
				array(
					'section'     => 'inspiry_properties_templates_and_archive',
					'label'       => esc_html__( 'Sorting Options to Show on the Frontend', RH_TEXT_DOMAIN ),
					'description' => esc_html__( 'Select which options you want to see on the property listing pages.', RH_TEXT_DOMAIN ),
					'choices'     => $sorting_option_fields,
				)
			)
		);

		// Default Sort Order
		$wp_customize->add_setting( 'theme_listing_default_sort', array(
			'type'              => 'option',
			'default'           => 'date-desc',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'theme_listing_default_sort', array(
			'label'       => esc_html__( 'Default Sort Order', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'For Search Results, Properties Templates and Taxonomy Archive pages. Make sure that your selection is enabled in previous option.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_properties_templates_and_archive',
			'choices'     => array_merge( array(
				'title-asc'   => esc_html__( 'Property Title - A to Z', RH_TEXT_DOMAIN ),
				'title-desc'  => esc_html__( 'Property Title - Z to A', RH_TEXT_DOMAIN )
			), $sorting_option_fields )
		) );

		// Views Counter
		$wp_customize->add_setting( 'realhomes_listing_views_counter', array(
			'type'              => 'option',
			'default'           => 'hide',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_listing_views_counter', array(
			'label'       => esc_html__( 'Show Listing Views Counter', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Show property views counter on property listing cards.', RH_TEXT_DOMAIN ),
			'type'        => 'radio',
			'section'     => 'inspiry_properties_templates_and_archive',
			'choices'     => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		// Term Description
		$wp_customize->add_setting( 'inspiry_term_description', array(
			'type'              => 'option',
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_term_description', array(
			'label'   => esc_html__( 'Taxonomy Term Description', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_properties_templates_and_archive',
			'choices' => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		// number of properties to display on map
		$wp_customize->add_setting(
			'inspiry_properties_list_tax_on_map',
			array(
				'type'              => 'option',
				'default'           => 'all',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'inspiry_properties_list_tax_on_map', array(
				'label'   => esc_html__( 'Number of Properties to Mark on Map?', RH_TEXT_DOMAIN ),
				'section' => 'inspiry_properties_templates_and_archive',
				'type'    => 'radio',
				'choices' => array(
					'all'            => esc_html__( 'All Found', RH_TEXT_DOMAIN ),
					'as_on_one_page' => esc_html__( 'As on One Page', RH_TEXT_DOMAIN ),
				),
			)
		);

		if ( 'ultra' === INSPIRY_DESIGN_VARIATION ) {
			// Property Price Separator
			$wp_customize->add_setting( 'realhomes_property_price_separator', array(
				'type'              => 'option',
				'default'           => 'hide',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_property_price_separator', array(
				'label'   => esc_html__( 'Show separator ("/") after price ', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_properties_templates_and_archive',
				'choices' => array(
					'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
					'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				),
			) );
		}
	}

	add_action( 'customize_register', 'inspiry_templates_and_archive_customizer' );
endif;


if ( ! function_exists( 'inspiry_templates_and_archive_defaults' ) ) :
	/**
	 * Set default values for properties templates and taxonomy settings
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	function inspiry_templates_and_archive_defaults( WP_Customize_Manager $wp_customize ) {
		$templates_and_archive_settings_ids = array(
			'inspiry_listing_header_variation',
			'theme_listing_module',
			'theme_listing_layout',
			'theme_number_of_properties',
			'theme_listing_default_sort',
		);
		inspiry_initialize_defaults( $wp_customize, $templates_and_archive_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_templates_and_archive_defaults' );
endif;

if ( ! function_exists( 'inspiry_listing_map_enabled' ) ) {
	/**
	 * Check if Listing & Taxonomy pages map is enabled
	 *
	 * @param $control
	 *
	 * @return bool
	 */
	function inspiry_listing_map_enabled( $control ) {
		if ( 'properties-map' === $control->manager->get_setting( 'theme_listing_module' )->value() ) {
			return true;
		} else {
			return false;
		}
	}
}