<?php
/**
 * Property meta custom icons settings file.
 *
 * @since   4.3.0
 *
 * @package realhomes/customizer
 */
if ( ! function_exists( 'realhomes_property_meta_custom_icons_customizer' ) ) {
	/**
	 * Generates the property meta custom icons customizer settings.
	 *
	 * @since 4.3.0
	 */
	function realhomes_property_meta_custom_icons_customizer( WP_Customize_Manager $wp_customize ) {

		$wp_customize->add_section( 'property_meta_custom_icons_section', array(
			'title'    => esc_html__( 'Custom Icons', RH_TEXT_DOMAIN ),
			'priority' => 124,
		) );

		$wp_customize->add_setting( 'realhomes_custom_property_meta_icons', array(
			'type'              => 'option',
			'default'           => 'false',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_custom_property_meta_icons', array(
			'label'   => esc_html__( 'Custom Icons', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'property_meta_custom_icons_section',
			'choices' => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'realhomes_allow_svg_upload', array(
			'type'              => 'option',
			'default'           => 'false',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_allow_svg_upload', array(
			'label'           => esc_html__( 'Enable SVG File Upload', RH_TEXT_DOMAIN ),
			'description'     => sprintf( '<ul class="notice notice-error"><li><strong>%s</strong></li><li>%s</li><li>%s</li></ul>',
				esc_html__( 'Important Note', RH_TEXT_DOMAIN ),
				esc_html__( 'Make sure that the SVG files are sanitized or you trust their source as SVG files can contain malicious code.', RH_TEXT_DOMAIN ),
				esc_html__( 'Please refresh the customizer window after changing this setting.', RH_TEXT_DOMAIN ) ),
			'type'            => 'radio',
			'section'         => 'property_meta_custom_icons_section',
			'choices'         => array(
				'true'  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'No', RH_TEXT_DOMAIN ),
			),
			'active_callback' => 'realhomes_is_custom_property_meta_icons'
		) );

		// Custom Action Buttons
		$wp_customize->add_setting( 'realhomes_custom_meta_icons',
			array( 'sanitize_callback' => 'sanitize_text_field', )
		);
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_custom_meta_icons',
			array(
				'label'           => esc_html__( 'Meta Icons', RH_TEXT_DOMAIN ),
				'section'         => 'property_meta_custom_icons_section',
				'active_callback' => 'realhomes_is_custom_property_meta_icons'
			)
		) );

		$property_meta_fields = realhomes_property_meta_fields();
		if ( is_array( $property_meta_fields ) && ! empty( $property_meta_fields ) ) {
			foreach ( $property_meta_fields as $property_meta_field ) {
				$id = 'realhomes_' . $property_meta_field['id'] . '_property_meta_icon';
				$wp_customize->add_setting( $id, array(
					'type'              => 'option',
					'sanitize_callback' => 'esc_url_raw',
				) );
				$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $id, array(
					'label'           => sprintf( esc_html__( '%s Icon', RH_TEXT_DOMAIN ), $property_meta_field['label'] ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				) ) );
			}
		}

		// Custom Action Buttons
		$wp_customize->add_setting( 'realhomes_custom_action_buttons',
			array( 'sanitize_callback' => 'sanitize_text_field', )
		);
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_custom_action_buttons',
			array(
				'label'           => esc_html__( 'Action Buttons', RH_TEXT_DOMAIN ),
				'section'         => 'property_meta_custom_icons_section',
				'active_callback' => 'realhomes_is_custom_property_meta_icons'
			)
		) );

		$wp_customize->add_setting( 'realhomes_favourite_button_icon', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
				'realhomes_favourite_button_icon',
				array(
					'label'           => esc_html__( 'Favourite Button Icon', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_compare_button_icon', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
				'realhomes_compare_button_icon',
				array(
					'label'           => esc_html__( 'Compare Button Icon', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_video_button_icon', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
				'realhomes_video_button_icon',
				array(
					'label'           => esc_html__( 'Video Button Icon', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_image_button_icon', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
				'realhomes_image_button_icon',
				array(
					'label'           => esc_html__( 'Image Button Icon', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_print_button_icon', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
				'realhomes_print_button_icon',
				array(
					'label'           => esc_html__( 'Single Property Print Button Icon', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_share_button_icon', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
				'realhomes_share_button_icon',
				array(
					'label'           => esc_html__( 'Single Property Share Button Icon', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_report_button_icon', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
				'realhomes_report_button_icon',
				array(
					'label'           => esc_html__( 'Single Property Report Button Icon', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Upload the icon.', RH_TEXT_DOMAIN ),
					'section'         => 'property_meta_custom_icons_section',
					'active_callback' => 'realhomes_is_custom_property_meta_icons'
				)
			)
		);

	}

	add_action( 'customize_register', 'realhomes_property_meta_custom_icons_customizer' );
}