<?php
/**
 * Section:  `Basics`
 * Panel:    `Header`
 *
 * @since 3.15.2
 */

if ( ! function_exists( 'inspiry_header_basics_customizer' ) ) {
	/**
	 * Header Basics Customizer
	 *
	 * @since  2.6.3
	 *
	 * @param WP_Customize_Manager $wp_customize
	 *
	 */
	function inspiry_header_basics_customizer( WP_Customize_Manager $wp_customize ) {

		// Header Basics
		$wp_customize->add_section( 'inspiry_header_basics', array(
			'title' => esc_html__( 'Basics', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_header_panel',
		) );

		if ( class_exists( 'RHEA_Elementor_Header_Footer' ) ) {
			$wp_customize->add_setting( 'realhomes_custom_header', array(
				'sanitize_callback' => 'inspiry_sanitize_select',
				'type'              => 'option',
				'default'           => 'default',
			) );
			$wp_customize->add_control( 'realhomes_custom_header', array(
				'settings' => 'realhomes_custom_header',
				'label'    => esc_html__( 'Custom Header Template', RH_TEXT_DOMAIN ),
				'type'     => 'select',
				'section'  => 'inspiry_header_basics',
				'choices'  => realhomes_get_elementor_library(),
			) );

			$wp_customize->add_setting( 'realhomes_custom_responsive_header', array(
				'sanitize_callback' => 'inspiry_sanitize_select',
				'type'              => 'option',
				'default'           => 'default',
			) );
			$wp_customize->add_control( 'realhomes_custom_responsive_header', array(
				'settings'        => 'realhomes_custom_responsive_header',
				'label'           => esc_html__( 'Custom Mobile Header Template', RH_TEXT_DOMAIN ),
				'type'            => 'select',
				'section'         => 'inspiry_header_basics',
				'choices'         => array(
					'default' => esc_html__( 'Default', RH_TEXT_DOMAIN ),
					'custom'  => esc_html__( 'Custom Elementor', RH_TEXT_DOMAIN ),
				),
				'active_callback' => 'realhomes_custom_header_not_default'
			) );

			$wp_customize->add_setting( 'inspiry_custom_header_position', array(
				'type'              => 'option',
				'default'           => 'relative',
				'sanitize_callback' => 'inspiry_sanitize_radio'
			) );
			$wp_customize->add_control( 'inspiry_custom_header_position', array(
				'label'           => esc_html__( 'Custom Header Position', RH_TEXT_DOMAIN ),
				'type'            => 'radio',
				'section'         => 'inspiry_header_basics',
				'choices'         => array(
					'relative' => esc_html__( 'Relative', RH_TEXT_DOMAIN ),
					'absolute' => esc_html__( 'Absolute', RH_TEXT_DOMAIN ),
				),
				'active_callback' => 'realhomes_custom_header_not_default'
			) );

		}

		if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
			// Header Variation
			$wp_customize->add_setting(
				'inspiry_header_mod_variation_option', array(
				'type'              => 'option',
				'default'           => 'one',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( new Inspiry_Custom_Radio_Image_Control( $wp_customize, 'inspiry_header_mod_variation_option',
				array(
					'section'         => 'inspiry_header_basics',
					'label'           => esc_html__( 'Header Variations', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Choose your desired header style.', RH_TEXT_DOMAIN ),
					'settings'        => 'inspiry_header_mod_variation_option',
					'choices'         => array(
						'one'   => get_template_directory_uri() . '/assets/modern/images/header-one.png',
						'two'   => get_template_directory_uri() . '/assets/modern/images/header-two.png',
						'three' => get_template_directory_uri() . '/assets/modern/images/header-three.png',
						'four'  => get_template_directory_uri() . '/assets/modern/images/header-four.jpg',
					),
					'active_callback' => 'realhomes_custom_header_is_default'
				)
			) );

			$wp_customize->add_setting( 'realhomes_header_layout', array(
				'type'              => 'option',
				'default'           => 'default',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_header_layout', array(
				'label'           => esc_html__( 'Header Layout', RH_TEXT_DOMAIN ),
				'type'            => 'radio',
				'section'         => 'inspiry_header_basics',
				'choices'         => array(
					'default'   => esc_html__( 'Default (Boxed)', RH_TEXT_DOMAIN ),
					'fullwidth' => esc_html__( 'Full Width', RH_TEXT_DOMAIN ),
				),
				'active_callback' => 'realhomes_custom_header_is_default'
			) );

			$wp_customize->add_setting(
				'inspiry_responsive_header_option', array(
					'type'              => 'option',
					'default'           => 'solid',
					'sanitize_callback' => 'inspiry_sanitize_radio',
				)
			);
			$wp_customize->add_control(
				'inspiry_responsive_header_option', array(
					'label'           => esc_html__( 'Header Display on Mobile Devices', RH_TEXT_DOMAIN ),
					'type'            => 'radio',
					'section'         => 'inspiry_header_basics',
					'choices'         => array(
						'transparent' => esc_html__( 'Transparent', RH_TEXT_DOMAIN ),
						'solid'       => esc_html__( 'Solid', RH_TEXT_DOMAIN ),
					),
					'active_callback' => 'realhomes_custom_responsive_header_default'
				)
			);
		}

		if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
			$wp_customize->add_setting( 'inspiry_header_variation', array(
				'type'              => 'option',
				'default'           => 'default',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_header_variation', array(
				'label'           => esc_html__( 'Choose Header Variation', RH_TEXT_DOMAIN ),
				'type'            => 'radio',
				'section'         => 'inspiry_header_basics',
				'choices'         => array(
					'default' => esc_html__( 'Default', RH_TEXT_DOMAIN ),
					'center'  => esc_html__( 'Center', RH_TEXT_DOMAIN ),
				),
				'active_callback' => 'realhomes_custom_header_is_default'
			) );
		}

		// Sticky Header
		$wp_customize->add_setting( 'theme_sticky_header', array(
			'type'              => 'option',
			'default'           => 'false',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'theme_sticky_header', array(
			'label'   => esc_html__( 'Desktop Sticky Header', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_header_basics',
			'choices' => array(
				'true'  => 'Enable',
				'false' => 'Disable',
			),
		) );

		// Sticky Header Logo
		$wp_customize->add_setting( 'realhomes_sticky_header_logo', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'realhomes_sticky_header_logo', array(
			'label'           => esc_html__( 'Sticky Header Logo', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Logo for sticky header. Site Logo will be used if no image selected.', RH_TEXT_DOMAIN ),
			'section'         => 'inspiry_header_basics',
			'active_callback' => 'realhomes_is_sticky_header_enabled'
		) ) );

		// Sticky Header Retina Logo
		$wp_customize->add_setting( 'realhomes_sticky_header_retina_logo', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'realhomes_sticky_header_retina_logo', array(
			'label'           => esc_html__( 'Sticky Header Retina Logo', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Upload a 2x size logo for Retina displays. For best results, image should be exactly double the size of your regular sticky header logo.', RH_TEXT_DOMAIN ),
			'section'         => 'inspiry_header_basics',
			'active_callback' => 'realhomes_is_sticky_header_enabled'
		) ) );

		$wp_customize->add_setting( 'inspiry_update_sticky_header_nav_links', array(
			'type'              => 'option',
			'default'           => 'false',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_update_sticky_header_nav_links', array(
			'label'           => esc_html__( 'Automatically Highlight Desktop Sticky Header Navigation links for related section.', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Works only with hash navigation if the related section exists on the page.', RH_TEXT_DOMAIN ),
			'type'            => 'radio',
			'section'         => 'inspiry_header_basics',
			'choices'         => array(
				'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
			'active_callback' => 'realhomes_is_sticky_header_enabled'
		) );

		if ( class_exists( 'RHEA_Elementor_Header_Footer' ) ) {
			$wp_customize->add_setting( 'realhomes_custom_sticky_header', array(
				'sanitize_callback' => 'inspiry_sanitize_select',
				'type'              => 'option',
				'default'           => 'default',
			) );
			$wp_customize->add_control( 'realhomes_custom_sticky_header', array(
				'label'           => esc_html__( 'Desktop Custom Sticky Header Template', RH_TEXT_DOMAIN ),
				'type'            => 'select',
				'section'         => 'inspiry_header_basics',
				'choices'         => realhomes_get_elementor_library(),
				'active_callback' => function () {
					return ( 'classic' !== INSPIRY_DESIGN_VARIATION && 'true' === get_option( 'theme_sticky_header', 'false' ) );
				}
			) );
		}

		// Mobile Sticky Header
		$wp_customize->add_setting( 'realhomes_mobile_sticky_header', array(
			'type'              => 'option',
			'default'           => 'false',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_mobile_sticky_header', array(
			'label'   => esc_html__( 'Mobile Sticky Header', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_header_basics',
			'choices' => array(
				'true'  => 'Enable',
				'false' => 'Disable',
			),
		) );

		if ( class_exists( 'RHEA_Elementor_Header_Footer' ) ) {
			$wp_customize->add_setting( 'realhomes_mobile_custom_sticky_header', array(
				'sanitize_callback' => 'inspiry_sanitize_select',
				'type'              => 'option',
				'default'           => 'default',
			) );
			$wp_customize->add_control( 'realhomes_mobile_custom_sticky_header', array(
				'label'           => esc_html__( 'Mobile Custom Sticky Header Template', RH_TEXT_DOMAIN ),
				'type'            => 'select',
				'section'         => 'inspiry_header_basics',
				'choices'         => realhomes_get_elementor_library(),
				'active_callback' => function () {
					return ( 'classic' !== INSPIRY_DESIGN_VARIATION && 'true' === get_option( 'realhomes_mobile_sticky_header', 'false' ) );
				}
			) );
		}

		if ( 'classic' !== INSPIRY_DESIGN_VARIATION ) {
			$wp_customize->add_setting( 'realhomes_mega_menu', array(
				'type'              => 'option',
				'default'           => 'disable',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_mega_menu', array(
				'label'   => esc_html__( 'Mega Menu', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_header_basics',
				'choices' => array(
					'enable'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
					'disable' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
				),
			) );
		}
	}

	add_action( 'customize_register', 'inspiry_header_basics_customizer' );
}

if ( ! function_exists( 'inspiry_header_basics_defaults' ) ) {
	/**
	 * inspiry_header_basics_defaults.
	 *
	 * @since  2.6.3
	 */
	function inspiry_header_basics_defaults( WP_Customize_Manager $wp_customize ) {
		$header_basics_settings_ids = array(
			'theme_sticky_header',
			'inspiry_header_variation',
		);
		inspiry_initialize_defaults( $wp_customize, $header_basics_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_header_basics_defaults' );
}

if ( ! function_exists( 'realhomes_custom_header_is_default' ) ) {
	/**
	 * Return True if Custom Header is set as Default
	 *
	 * @since RealHomes 3.18.0
	 *
	 * @return bool
	 */
	function realhomes_custom_header_is_default() {
		if ( class_exists( 'RHEA_Elementor_Header_Footer' ) ) {
			$realhomes_custom_header = get_option( 'realhomes_custom_header' );
			if ( $realhomes_custom_header && 'default' !== $realhomes_custom_header ) {
				return false;
			}
		}

		return true;
	}
}

if ( ! function_exists( 'realhomes_custom_header_not_default' ) ) {
	/**
	 * Check if Custom Header is not set as Default
	 *
	 * @since RealHomes 3.18.0
	 *
	 * @return bool
	 */
	function realhomes_custom_header_not_default() {
		if ( class_exists( 'RHEA_Elementor_Header_Footer' ) ) {
			$realhomes_custom_header = get_option( 'realhomes_custom_header' );
			if ( $realhomes_custom_header && 'default' !== $realhomes_custom_header ) {
				return true;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'realhomes_custom_responsive_header_default' ) ) {
	/**
	 * Check if Custom Responsive Header is set as Default
	 *
	 * @since RealHomes 3.18.0
	 *
	 * @return bool
	 */
	function realhomes_custom_responsive_header_default() {

		if ( class_exists( 'RHEA_Elementor_Header_Footer' ) ) {
			$realhomes_custom_responsive_header = get_option( 'realhomes_custom_responsive_header' );
			if ( $realhomes_custom_responsive_header && 'default' !== $realhomes_custom_responsive_header && true !== realhomes_custom_header_is_default() ) {
				return false;
			}
		}

		return true;
	}
}

if ( ! function_exists( 'realhomes_is_sticky_header_enabled' ) ) {
	/**
	 * Check if sticky header is enabled for non-classic design variations.
	 *
	 * @since 4.4.3
	 * @return bool
	 */
	function realhomes_is_sticky_header_enabled() {
		return ( 'classic' !== INSPIRY_DESIGN_VARIATION && 'true' === get_option( 'theme_sticky_header', 'false' ) && 'default' === get_option( 'realhomes_custom_sticky_header', 'default' ) );
	}
}