<?php
if ( ! function_exists( 'inspiry_login_register_customizer' ) ) :

	function inspiry_login_register_customizer( WP_Customize_Manager $wp_customize ) {

		// Basics section
		$wp_customize->add_section( 'inspiry_members_login', array(
			'title' => esc_html__( 'Login & Register', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_header_panel',
		) );

		$wp_customize->add_setting( 'realhomes_login_register_basics_label',
			array( 'sanitize_callback' => 'sanitize_text_field', )
		);
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_login_register_basics_label',
			array(
				'label'   => esc_html__( 'Basics', RH_TEXT_DOMAIN ),
				'section' => 'inspiry_members_login',
			)
		) );

		// Show/Hide user related stuff in header
		$wp_customize->add_setting( 'theme_enable_user_nav', array(
			'type'              => 'option',
			'default'           => 'true',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'theme_enable_user_nav', array(
			'label'   => esc_html__( 'User related stuff in header?', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_login',
			'choices' => array(
				'true'  => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			)
		) );

		// Login redirect page setting
		$wp_customize->add_setting( 'inspiry_login_redirect_page', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'inspiry_login_redirect_page', array(
			'label'       => esc_html__( 'After Login, Redirect User to Selected Page (optional)', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'User will be redirected to the selected page after successful login. By default user will be redirected to the Homepage.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_members_login',
			'choices'     => RH_Data::get_pages_array(),
		) );

		// OPT Page Options
		if ( function_exists( 'ere_is_social_login_enabled' ) && ( ere_is_social_login_enabled( 'facebook' ) || ere_is_social_login_enabled( 'google' ) || ere_is_social_login_enabled( 'twitter' ) ) ) {
			$wp_customize->add_setting(
				'realhomes_otp_page', array(
					'type'              => 'option',
					'transport'         => 'postMessage',
					'sanitize_callback' => 'inspiry_sanitize_select',
				)
			);

			// Arguments for the OTP Template
			$otp_page_args = array(
				'meta_query' => array(
					array(
						'key'   => '_wp_page_template',
						'value' => 'templates/otp.php',
					),
				),
			);

			$wp_customize->add_control(
				'realhomes_otp_page', array(
					'label'       => esc_html__( 'Select OTP Page', RH_TEXT_DOMAIN ),
					'description' => esc_html__( 'Ensure that you have assigned an OTP page if social login is enabled. Also, make sure to configure Permalinks as "Post name".', RH_TEXT_DOMAIN ),
					'type'        => 'select',
					'section'     => 'inspiry_members_login',
					'choices'     => inspiry_pages( $otp_page_args ),
				)
			);
		}

		// Login and register page setting
		$wp_customize->add_setting( 'inspiry_login_register_page', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'inspiry_login_register_page', array(
			'label'       => esc_html__( 'Login and Register Page (optional)', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'By default the login dialog box will appear and you do not need to configure this option. Selected page should have Login & Register Template assigned to it.', RH_TEXT_DOMAIN ),
			'type'        => 'select',
			'section'     => 'inspiry_members_login',
			'choices'     => RH_Data::get_pages_array(),
		) );

		// Registration notification section
		$wp_customize->add_setting( 'realhomes_registration_notification_section_label',
			array( 'sanitize_callback' => 'sanitize_text_field', )
		);
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_registration_notification_section_label',
			array(
				'label'   => esc_html__( 'Registration Notification', RH_TEXT_DOMAIN ),
				'section' => 'inspiry_members_login',
			)
		) );

		$wp_customize->add_setting( 'realhomes_email_confirmation_before_login', array(
			'type'              => 'option',
			'default'           => 'no',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'inspiry_sanitize_radio'
		) );
		$wp_customize->add_control( 'realhomes_email_confirmation_before_login', array(
			'label'   => esc_html__( 'Enable Email Confirmation Before User Can Login', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_login',
			'choices' => array(
				'yes' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
				'no'  => esc_html__( 'No', RH_TEXT_DOMAIN ),
			),
		) );

		// Dialog section
		$wp_customize->add_setting( 'realhomes_login_register_dialog_label',
			array( 'sanitize_callback' => 'sanitize_text_field', )
		);
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_login_register_dialog_label',
			array(
				'label'   => esc_html__( 'Dialog', RH_TEXT_DOMAIN ),
				'section' => 'inspiry_members_login',
			)
		) );

		$wp_customize->add_setting( 'inspiry_login_quote_side_display', array(
			'type'              => 'option',
			'default'           => 'true',
			'sanitize_callback' => 'inspiry_sanitize_radio',
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_quote_side_display', array(
			'label'   => esc_html__( 'Quote Side (Half of Dialog)', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_login',
			'choices' => array(
				'true'  => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'theme_login_modal_background', array(
			'type'              => 'option',
			'sanitize_callback' => 'esc_url_raw',
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'theme_login_modal_background', array(
			'label'    => esc_html__( 'Login Background Image', RH_TEXT_DOMAIN ),
			'section'  => 'inspiry_members_login',
			'settings' => 'theme_login_modal_background',
		) ) );

		$wp_customize->add_setting( 'inspiry_login_quote_text', array(
			'type'              => 'option',
			'default'           => 'Owning a home is a keystone of wealth… both financial affluence and emotional security.',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage'
		) );

		$wp_customize->add_control( 'inspiry_login_quote_text', array(
			'label'     => esc_html__( 'Quote Text', RH_TEXT_DOMAIN ),
			'type'      => 'textarea',
			'transport' => 'postMessage',
			'section'   => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_quote_author', array(
			'type'              => 'option',
			'default'           => 'Suze Orman',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_quote_author', array(
			'label'   => esc_html__( 'Quote Author', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_date_day_display', array(
			'type'              => 'option',
			'default'           => 'true',
			'sanitize_callback' => 'inspiry_sanitize_radio',
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_date_day_display', array(
			'label'   => esc_html__( 'Show Date and Day', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_members_login',
			'choices' => array(
				'true'  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'No', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'inspiry_login_bloginfo_display', array(
			'type'              => 'option',
			'default'           => 'site-title',
			'sanitize_callback' => 'inspiry_sanitize_radio',
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_bloginfo_display', array(
			'label'   => esc_html__( 'Select Site Title/Logo', RH_TEXT_DOMAIN ),
			'type'    => 'select',
			'section' => 'inspiry_members_login',
			'choices' => array(
				'none'       => esc_html__( 'None', RH_TEXT_DOMAIN ),
				'site-title' => esc_html__( 'Site Title', RH_TEXT_DOMAIN ),
				'site-logo'  => esc_html__( 'Site Logo', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'inspiry_login_text', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Login', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_text', array(
			'label'   => esc_html__( 'Login Tab Text', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_register_text', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Register', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_register_text', array(
			'label'   => esc_html__( 'Register Tab Text', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_forget_text', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Forget Password?', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_forget_text', array(
			'label'   => esc_html__( 'Forget Password Text', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_user_name_label', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Username', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_user_name_label', array(
			'label'   => esc_html__( 'Username Label', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_user_name_placeholder', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Username', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_user_name_placeholder', array(
			'label'   => esc_html__( 'Username Placeholder', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );
		$wp_customize->add_setting( 'inspiry_login_password_label', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Password', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_password_label', array(
			'label'   => esc_html__( 'Password Label', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );
		$wp_customize->add_setting( 'inspiry_login_password_placeholder', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Password', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_password_placeholder', array(
			'label'   => esc_html__( 'Password Placeholder', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_button_text', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Login', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_login_button_text', array(
			'label'   => esc_html__( 'Login Button Text', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_login_form_separator', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Separator_Control( $wp_customize, 'inspiry_login_form_separator',
			array(
				'section' => 'inspiry_members_login',
			)
		) );

		$wp_customize->add_setting( 'inspiry_register_email_label', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Email', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_register_email_label', array(
			'label'   => esc_html__( 'Email Label', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_register_email_placeholder', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Email', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_register_email_placeholder', array(
			'label'   => esc_html__( 'Email Placeholder', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_register_user_role_label', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'User Role', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_register_user_role_label', array(
			'label'   => esc_html__( 'User Role Label', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_register_user_role_placeholder', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'User Role', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_register_user_role_placeholder', array(
			'label'   => esc_html__( 'User Role Placeholder', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_register_button_text', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Register', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_register_button_text', array(
			'label'   => esc_html__( 'Register Button Text', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_register_form_separator', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Separator_Control( $wp_customize, 'inspiry_register_form_separator',
			array(
				'section' => 'inspiry_members_login',
			)
		) );

		$wp_customize->add_setting( 'inspiry_restore_password_placeholder', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Username or Email', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_restore_password_placeholder', array(
			'label'   => esc_html__( 'Restore Field Placeholder', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

		$wp_customize->add_setting( 'inspiry_restore_button_text', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => esc_html__( 'Reset Password', RH_TEXT_DOMAIN ),
			'transport'         => 'postMessage'
		) );
		$wp_customize->add_control( 'inspiry_restore_button_text', array(
			'label'   => esc_html__( 'Reset Password Button Text', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_members_login',
		) );

	}

	add_action( 'customize_register', 'inspiry_login_register_customizer' );
endif;

if ( ! function_exists( 'inspiry_login_register_defaults' ) ) :
	function inspiry_login_register_defaults( WP_Customize_Manager $wp_customize ) {
		$login_register_settings_ids = array(
			'theme_enable_user_nav',
			'inspiry_login_quote_side_display',
			'inspiry_login_quote_text',
			'inspiry_login_quote_author',
			'inspiry_login_date_day_display',
			'inspiry_login_bloginfo_display',
			'inspiry_login_text',
			'inspiry_login_register_text',
			'inspiry_login_forget_text',
			'inspiry_login_user_name_label',
			'inspiry_login_user_name_placeholder',
			'inspiry_login_password_label',
			'inspiry_login_password_placeholder',
			'inspiry_login_button_text',
			'inspiry_register_email_label',
			'inspiry_register_email_placeholder',
			'inspiry_register_user_role_label',
			'inspiry_register_user_role_placeholder',
			'inspiry_register_button_text',
			'inspiry_restore_password_placeholder',
			'inspiry_restore_button_text',
		);
		inspiry_initialize_defaults( $wp_customize, $login_register_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_login_register_defaults' );
endif;