<?php
/**
 * Section: RVR Sections
 * Panel: Property Detail Page
 *
 * @since 4.4.2
 * @package realhomes/customizer
 */

if ( ! function_exists( 'realhomes_rvr_additional_sections_customizer' ) ) {
	/**
	 * Registers RVR-specific sections with Show/Hide settings.
	 *
	 * @since 4.4.2
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	function realhomes_rvr_sections_customizer( WP_Customize_Manager $wp_customize ) {

		$sections = [
			'realhomes_rvr_surroundings'      => esc_html__( 'Property Surroundings', RH_TEXT_DOMAIN ),
			'realhomes_rvr_services'          => esc_html__( 'Services', RH_TEXT_DOMAIN ),
			'realhomes_rvr_property_policies' => esc_html__( 'Property Rules', RH_TEXT_DOMAIN ),
		];

		foreach ( $sections as $key => $label ) {
			$section_id = $key . '_section';

			$wp_customize->add_section( $section_id, array(
				'title'    => $label,
				'panel'    => 'inspiry_property_panel',
				'priority' => 25,
			) );

			$wp_customize->add_setting( $key, array(
				'type'              => 'option',
				'default'           => 'true',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );

			$wp_customize->add_control( $key, array(
				'label'   => $label,
				'type'    => 'radio',
				'section' => $section_id,
				'choices' => array(
					'true'  => esc_html__( 'Show', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
				),
			) );
		}

		$wp_customize->add_setting( 'realhomes_rvr_outdoor_features', array(
			'type'              => 'option',
			'default'           => 'true',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_rvr_outdoor_features', array(
			'label'   => esc_html__( 'Outdoor Features', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_rvr_surroundings_section',
			'choices' => array(
				'true'  => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );
	}

	add_action( 'customize_register', 'realhomes_rvr_sections_customizer' );
}