<?php
/**
 * Section: Sections Manager
 * Panel: Property
 *
 * @since 3.8.4
 */
if ( ! function_exists( 'inspiry_property_sections_manager_customizer' ) ) :
	function inspiry_property_sections_manager_customizer( WP_Customize_Manager $wp_customize ) {

		$wp_customize->add_section( 'inspiry_property_sections_manager', array(
			'title'    => esc_html__( 'Sections Manager', RH_TEXT_DOMAIN ),
			'panel'    => 'inspiry_property_panel',
			'priority' => 1
		) );

		$wp_customize->add_setting( 'inspiry_property_sections_order_default', array(
			'default'           => 'default',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_property_sections_order_default', array(
			'label'    => esc_html__( 'Order Settings', RH_TEXT_DOMAIN ),
			'type'     => 'radio',
			'section'  => 'inspiry_property_sections_manager',
			'settings' => 'inspiry_property_sections_order_default',
			'choices'  => array(
				'default' => esc_html__( 'Default', RH_TEXT_DOMAIN ),
				'custom'  => esc_html__( 'Custom', RH_TEXT_DOMAIN ),
			)
		) );

		/* Property Sections Order - Classic */
		if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
			$property_sections_default = 'slider,content,floor-plans,video,virtual-tour,map,walkscore,yelp-nearby-places,attachments,children,agent,energy-performance,mortgage-calculator';
			$property_sections         = array(
				'slider'              => esc_html__( 'Slider', RH_TEXT_DOMAIN ),
				'content'             => esc_html__( 'Content', RH_TEXT_DOMAIN ),
				'floor-plans'         => esc_html__( 'Floor Plans', RH_TEXT_DOMAIN ),
				'video'               => esc_html__( 'Video', RH_TEXT_DOMAIN ),
				'virtual-tour'        => esc_html__( 'Virtual Tour', RH_TEXT_DOMAIN ),
				'map'                 => esc_html__( 'Map', RH_TEXT_DOMAIN ),
				'walkscore'           => esc_html__( 'WalkScore', RH_TEXT_DOMAIN ),
				'yelp-nearby-places'  => esc_html__( 'Nearby Places', RH_TEXT_DOMAIN ),
				'attachments'         => esc_html__( 'Attachments', RH_TEXT_DOMAIN ),
				'children'            => esc_html__( 'Child Properties', RH_TEXT_DOMAIN ),
				'agent'               => esc_html__( 'Agents', RH_TEXT_DOMAIN ),
				'energy-performance'  => esc_html__( 'Energy Performance', RH_TEXT_DOMAIN ),
				'mortgage-calculator' => esc_html__( 'Mortgage Calculator', RH_TEXT_DOMAIN ),
			);

			// Add Property Views section if Property Analytic is enabled.
			if ( inspiry_is_property_analytics_enabled() ) {

				$property_sections = array_merge(
					$property_sections,
					array(
						'property-views' => esc_html__( 'Property Views', RH_TEXT_DOMAIN ),
					)
				);

				$property_sections_default .= ',property-views';
			}

			// Add RVR related section if RVR is enabled.
			if ( inspiry_is_rvr_enabled() ) {

				$property_sections = array_merge(
					$property_sections,
					array(
						'rvr/price-details'         => esc_html__( 'Price Details', RH_TEXT_DOMAIN ),
						'rvr/guests-accommodation'  => esc_html__( 'Guests Accommodation', RH_TEXT_DOMAIN ),
						'rvr/seasonal-prices'       => esc_html__( 'Seasonal Prices', RH_TEXT_DOMAIN ),
						'rvr/availability-calendar' => esc_html__( 'Availability Calendar', RH_TEXT_DOMAIN ),
					)
				);

				$property_sections_default .= ',rvr/price-details,rvr/seasonal-prices,rvr/availability-calendar';
			}

			$wp_customize->add_setting( 'inspiry_property_sections_order', array(
				'type'              => 'option',
				'default'           => $property_sections_default,
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new Inspiry_Dragdrop_Control( $wp_customize, 'inspiry_property_sections_order',
				array(
					'label'       => esc_html__( 'Sections Order', RH_TEXT_DOMAIN ),
					'description' => esc_html__( 'Select custom order for classic design variation.', RH_TEXT_DOMAIN ),
					'section'     => 'inspiry_property_sections_manager',
					'settings'    => 'inspiry_property_sections_order',
					'choices'     => $property_sections,
				)
			) );
		}

		/* Property Sections Order - Modern */
		if ( 'modern' === INSPIRY_DESIGN_VARIATION || 'ultra' === INSPIRY_DESIGN_VARIATION) {
			$property_sections_default = 'content,additional-details,common-note,features,attachments,floor-plans,video,virtual-tour,map,walkscore,yelp-nearby-places,children,agent,energy-performance,mortgage-calculator';
			$property_sections         = array(
				'content'             => esc_html__( 'Content', RH_TEXT_DOMAIN ),
				'additional-details'  => esc_html__( 'Additional Details', RH_TEXT_DOMAIN ),
				'common-note'         => esc_html__( 'Common Note', RH_TEXT_DOMAIN ),
				'features'            => esc_html__( 'Features', RH_TEXT_DOMAIN ),
				'attachments'         => esc_html__( 'Attachments', RH_TEXT_DOMAIN ),
				'floor-plans'         => esc_html__( 'Floor Plans', RH_TEXT_DOMAIN ),
				'video'               => esc_html__( 'Video', RH_TEXT_DOMAIN ),
				'virtual-tour'        => esc_html__( 'Virtual Tour', RH_TEXT_DOMAIN ),
				'map'                 => esc_html__( 'Map', RH_TEXT_DOMAIN ),
				'walkscore'           => esc_html__( 'WalkScore', RH_TEXT_DOMAIN ),
				'yelp-nearby-places'  => esc_html__( 'Nearby Places', RH_TEXT_DOMAIN ),
				'schedule-a-tour'     => esc_html__( 'Schedule A Tour', RH_TEXT_DOMAIN ),
				'children'            => esc_html__( 'Child Properties', RH_TEXT_DOMAIN ),
				'agent'               => esc_html__( 'Agents', RH_TEXT_DOMAIN ),
				'energy-performance'  => esc_html__( 'Energy Performance', RH_TEXT_DOMAIN ),
				'mortgage-calculator' => esc_html__( 'Mortgage Calculator', RH_TEXT_DOMAIN )
			);

			// Add Property Views section if Property Analytic is enabled.
			if ( inspiry_is_property_analytics_enabled() ) {
				$property_sections = array_merge(
					$property_sections,
					array(
						'property-views' => esc_html__( 'Property Views', RH_TEXT_DOMAIN ),
					)
				);

				$property_sections_default .= ',property-views';
			}

			if ( inspiry_is_rvr_enabled() ) {
				$property_sections = array_merge(
					$property_sections,
					array(
						'rvr/location-surroundings' => esc_html__( 'Surroundings & Outdoor Features', RH_TEXT_DOMAIN ),
						'rvr/optional-services'     => esc_html__( 'Services', RH_TEXT_DOMAIN ),
						'rvr/property-policies'     => esc_html__( 'Property Rules', RH_TEXT_DOMAIN ),
						'rvr/price-details'         => esc_html__( 'Price Details', RH_TEXT_DOMAIN ),
						'rvr/guests-accommodation'  => esc_html__( 'Guests Accommodation', RH_TEXT_DOMAIN ),
						'rvr/seasonal-prices'       => esc_html__( 'Seasonal Prices', RH_TEXT_DOMAIN ),
						'rvr/availability-calendar' => esc_html__( 'Availability Calendar', RH_TEXT_DOMAIN ),
						'rvr/booking-form'          => esc_html__( 'Booking Form', RH_TEXT_DOMAIN ),
					)
				);

				$property_sections_default .= ',rvr/location-surroundings,rvr/optional-services,rvr/property-policies,rvr/price-details,rvr/seasonal-prices,rvr/availability-calendar';
			}

			$property_sections = apply_filters( 'realhomes_property_sections', $property_sections );

			$wp_customize->add_setting( 'inspiry_property_sections_order_mod', array(
				'type'              => 'option',
				'default'           => $property_sections_default,
				'sanitize_callback' => 'sanitize_text_field'
			) );
			$wp_customize->add_control( new Inspiry_Dragdrop_Control( $wp_customize, 'inspiry_property_sections_order_mod',
				array(
					'label'       => esc_html__( 'Sections Order', RH_TEXT_DOMAIN ),
					'description' => esc_html__( 'Select custom order for modern design variation.', RH_TEXT_DOMAIN ),
					'section'     => 'inspiry_property_sections_manager',
					'settings'    => 'inspiry_property_sections_order_mod',
					'choices'     => $property_sections,
				)
			) );
		}
	}

	add_action( 'customize_register', 'inspiry_property_sections_manager_customizer' );
endif;

if ( ! function_exists( 'inspiry_property_sections_manager_defaults' ) ) :
	function inspiry_property_sections_manager_defaults( WP_Customize_Manager $wp_customize ) {
		$property_sections_manager_settings_ids = array(
			'inspiry_property_sections_order_default',
			'inspiry_property_sections_order',
			'inspiry_property_sections_order_mod'
		);
		inspiry_initialize_defaults( $wp_customize, $property_sections_manager_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_property_sections_manager_defaults' );
endif;