<?php
/**
 * RealHomes Print Functions
 *
 * @since       4.4.2
 * @subpackage  Print
 * @package     RealHomes
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue print script with localized data.
 *
 * @since   4.4.2
 */
add_action( 'wp_enqueue_scripts', 'realhomes_enqueue_print_script' );
function realhomes_enqueue_print_script() {
	if ( is_singular( 'property' ) ) {

		// Enqueue print script
		wp_enqueue_script(
			'print-property',
			get_theme_file_uri( '/common/js/print-property.js' ),
			[ 'jquery' ],
			INSPIRY_THEME_VERSION,
			true
		);

		$property_id = get_the_ID();

		if ( ! empty( has_post_thumbnail( $property_id ) ) ) {
			$property_thumbnail = get_the_post_thumbnail_url( $property_id, 'large' );
		} else {
			$property_thumbnail = get_inspiry_image_placeholder_url( 'large' );
		}

		// Localized strings + data
		wp_localize_script( 'print-property', 'printProperty', [
			'printUrl'          => get_permalink( $property_id ) . '?print_view=1',
			'loadingText'       => esc_html__( 'Loading print preview...', RH_TEXT_DOMAIN ),
			'propertyThumbnail' => esc_url( $property_thumbnail )
		] );

		wp_enqueue_script( 'print-property' );
	}
}