<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$quick_links = array(
	'links' => array(
		array(
			'title' => esc_html__( 'Support', RH_TEXT_DOMAIN ),
			'link'  => 'https://support.inspirythemes.com/'
		),
	),
);

$documentation_postbox = array(
	'links'         => array(
		array(
			'title' => esc_html__( 'Documentation', RH_TEXT_DOMAIN ),
			'link'  => 'https://realhomes.io/documentation/'
		)
	),
	'posts_heading' => esc_html__( 'Useful Links', RH_TEXT_DOMAIN ),
	'posts'         => array(
		array(
			'title' => esc_html__( 'Installation', RH_TEXT_DOMAIN ),
			'link'  => 'https://realhomes.io/documentation/installation-and-activation/'
		),
		array(
			'title' => esc_html__( 'Demo Import', RH_TEXT_DOMAIN ),
			'link'  => 'https://realhomes.io/documentation/import-demo/'
		),
		array(
			'title' => esc_html__( 'Add New Property', RH_TEXT_DOMAIN ),
			'link'  => 'https://realhomes.io/documentation/add-property/'
		),
		array(
			'title' => esc_html__( 'Price Format', RH_TEXT_DOMAIN ),
			'link'  => 'https://realhomes.io/documentation/price-format-settings/'
		),
		array(
			'title' => esc_html__( 'Performance', RH_TEXT_DOMAIN ),
			'link'  => 'https://realhomes.io/documentation/#few-performance-improvement-tips'
		),
	)
);

$knowledge_base_postbox = array(
	'links'         => array(
		array(
			'title' => esc_html__( 'Knowledge Base', RH_TEXT_DOMAIN ),
			'link'  => 'https://support.inspirythemes.com/knowledgebase-category/real-homes-theme/'
		)
	),
	'posts_heading' => esc_html__( 'Common Topics', RH_TEXT_DOMAIN ),
	'posts'         => array(
		array(
			'title' => esc_html__( 'How to Update RealHomes Theme Safely', RH_TEXT_DOMAIN ),
			'link'  => 'https://support.inspirythemes.com/knowledgebase/how-to-update-real-homes-theme-safely/',
		),
		array(
			'title' => esc_html__( 'How to Fix SSL Related Problems', RH_TEXT_DOMAIN ),
			'link'  => 'https://support.inspirythemes.com/knowledgebase/how-to-fix-ssl-related-problems/ '
		),
		array(
			'title' => esc_html__( 'How to Inspect Element to Change CSS Properties', RH_TEXT_DOMAIN ),
			'link'  => 'https://support.inspirythemes.com/knowledgebase/how-to-inspect-element-to-change-css-properties/'
		),
		array(
			'title' => esc_html__( 'How to Translate Your Website', RH_TEXT_DOMAIN ),
			'link'  => 'https://support.inspirythemes.com/knowledgebase/how-to-translate-your-theme-to-your-language/'
		),
		array(
			'title' => esc_html__( 'Extending and Renewing Theme Support', RH_TEXT_DOMAIN ),
			'link'  => 'https://support.inspirythemes.com/knowledgebase/extend-renew-support/'
		),
	)
);

$how_to_get_help = array(
	'posts_heading' => esc_html__( 'How to Get Support', RH_TEXT_DOMAIN ),
	'posts'         => array(
		array(
			'description' => sprintf(
			/* translators: 1: Register URL, 2: Ask question URL */
				__( 'You need to <a href="%1$s" target="_blank">register at our support website</a> and <a href="%2$s" target="_blank">ask your question</a> over there to get support from Inspiry Themes team.', RH_TEXT_DOMAIN ),
				esc_url( 'https://support.inspirythemes.com/login-register/' ),
				esc_url( 'https://support.inspirythemes.com/ask-question/' )
			),
		)
	)
);

$extend_support = array(
	'posts_heading' => esc_html__( 'Extend and Renew Theme Support', RH_TEXT_DOMAIN ),
	'posts'         => array(
		array(
			'description' => sprintf(
				__( 'RealHomes comes with 6 months of free support with your purchase. Support can be <a href="%s" target="_blank">extended or renewed</a> via ThemeForest.', RH_TEXT_DOMAIN ),
				esc_url( 'https://support.inspirythemes.com/knowledgebase/extend-renew-support/' )
			)
		),
	)
);
?>
<?php $this->header( 'help' ); ?>
    <div class="realhomes-page-inner-wrap inspiry-help-content-wrap form-wrapper">
        <h2 class="inspiry-title"><?php esc_html_e( 'Welcome to Inspiry Help Desk!', RH_TEXT_DOMAIN ); ?></h2>
        <div class="row">
            <div class="col-3">
                <div class="inspiry-postbox postbox">
                    <div class="inspiry-postbox-header">
                        <h2 class="title"><span aria-hidden="true" class="dashicons dashicons-book"></span><?php esc_html_e( 'User Guide', RH_TEXT_DOMAIN ); ?></h2>
                    </div>
                    <div class="inspiry-postbox-inside inside">
						<?php $this->inspiry_postbox_posts( $documentation_postbox['posts'], $documentation_postbox['posts_heading'] ); ?>
                    </div>
                    <div class="inspiry-postbox-footer">
						<?php $this->inspiry_quick_links( $documentation_postbox['links'] ); ?>
                    </div>
                </div>
            </div>
            <div class="col-3">
                <div class="inspiry-postbox postbox">
                    <div class="inspiry-postbox-header">
                        <h2 class="title"><span aria-hidden="true" class="dashicons dashicons-book-alt"></span><?php esc_html_e( 'Knowledge Base', RH_TEXT_DOMAIN ); ?></h2>
                    </div>
                    <div class="inspiry-postbox-inside inside">
						<?php $this->inspiry_postbox_posts( $knowledge_base_postbox['posts'], $knowledge_base_postbox['posts_heading'] ); ?>
                    </div>
                    <div class="inspiry-postbox-footer">
						<?php $this->inspiry_quick_links( $knowledge_base_postbox['links'] ); ?>
                    </div>
                </div>
            </div>
            <div class="col-3">
                <div class="inspiry-postbox postbox">
                    <div class="inspiry-postbox-header">
                        <h2 class="title"><span aria-hidden="true" class="dashicons dashicons-sos"></span><?php esc_html_e( 'Get Support', RH_TEXT_DOMAIN ); ?></h2>
                    </div>
                    <div class="inspiry-postbox-inside inside">
						<?php $this->inspiry_postbox_posts( $how_to_get_help['posts'], $how_to_get_help['posts_heading'] ); ?>
                        <?php $this->inspiry_postbox_posts( $extend_support['posts'], $extend_support['posts_heading'] ); ?>
                    </div>
                    <div class="inspiry-postbox-footer">
						<?php $this->inspiry_quick_links( $quick_links['links'] ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $this->footer( 'help' ); ?>