<?php
$tabs['content_area'] = array(
	'label' => esc_html__( 'Content Area', RH_TEXT_DOMAIN ),
	'icon'  => 'dashicons-media-text',
);

$content_position_label = esc_html__( 'Display Content Above Footer?', RH_TEXT_DOMAIN );
if ( 'ultra' === INSPIRY_DESIGN_VARIATION ) {
	$content_position_label = esc_html__( 'Display Content Area At Bottom?', RH_TEXT_DOMAIN );
}

$fields[] = array(
	'name'      => $content_position_label,
	'id'        => 'REAL_HOMES_content_area_above_footer',
	'type'      => 'switch',
	'style'     => 'square',
	'on_label'  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
	'off_label' => esc_html__( 'No', RH_TEXT_DOMAIN ),
	'std'       => 0,
	'columns'   => 8,
	'class'     => 'inspiry_switch_inline',
	'tab'       => 'content_area',
);

if ( 'ultra' !== INSPIRY_DESIGN_VARIATION ) {
	$tabs['spacing'] = array(
		'label' => esc_html__( 'Spacing', RH_TEXT_DOMAIN ),
		'icon'  => 'dashicons-yes',
	);

	if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
		$fields[] = array(
			'name'      => esc_html__( 'Remove page’s top and bottom spacing', RH_TEXT_DOMAIN ),
			'id'        => 'REAL_HOMES_page_top_bottom_padding_nil',
			'type'      => 'switch',
			'style'     => 'square',
			'on_label'  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
			'off_label' => esc_html__( 'No', RH_TEXT_DOMAIN ),
			'std'       => 0,
			'columns'   => 8,
			'class'     => 'inspiry_switch_inline',
			'tab'       => 'spacing',
		);
		$fields[] = array(
			'name'      => esc_html__( 'Remove Content Area Padding?', RH_TEXT_DOMAIN ),
			'id'        => 'REAL_HOMES_content_area_padding_nil',
			'type'      => 'switch',
			'style'     => 'square',
			'on_label'  => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
			'off_label' => esc_html__( 'No', RH_TEXT_DOMAIN ),
			'std'       => 0,
			'columns'   => 8,
			'class'     => 'inspiry_switch_inline',
			'tab'       => 'spacing',
		);

	} else if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
		$fields[] = array(
			'name' => esc_html__( 'Remove Content Area Padding?', RH_TEXT_DOMAIN ),
			'desc' => esc_html__( 'Yes', RH_TEXT_DOMAIN ),
			'id'   => 'REAL_HOMES_content_area_padding_nil',
			'type' => 'checkbox',
			'std'  => 0,
			'tab'  => 'spacing',
		);
	}
}

