<?php
/**
 * This file loads the whole theme framework.
 *
 * @package realhomes/framework
 */


/**
 * Load classes files
 */
require_once( INSPIRY_FRAMEWORK . 'classes/load.php' );

// Theme version.
define( 'INSPIRY_THEME_VERSION', RealHomes_Helper::get_theme_version() );

/**
 * Load functions files
 */
require_once( INSPIRY_FRAMEWORK . 'functions/load.php' );

/**
 * Google Fonts
 */
require_once( INSPIRY_FRAMEWORK . 'customizer/google-fonts/google-fonts.php' );

/**
 * Customizer
 */
require_once( INSPIRY_FRAMEWORK . 'customizer/customizer.php' );

/**
 * RealHomes Admin
 *
 * @since 3.8.4
 */
if ( file_exists( INSPIRY_FRAMEWORK . 'include/admin/class-rh-admin.php' ) ) {
	require_once( INSPIRY_FRAMEWORK . 'include/admin/class-rh-admin.php' );
}

/**
 * RealHomes Admin functions
 *
 * @since 4.3.9
 */
require_once( INSPIRY_FRAMEWORK . 'include/admin/admin-functions.php' );

/**
 * Theme meta boxes
 */
require_once( INSPIRY_FRAMEWORK . 'include/meta-boxes/post-meta-box.php' );
require_once( INSPIRY_FRAMEWORK . 'include/meta-boxes/home-page-meta-box.php' );
require_once( INSPIRY_FRAMEWORK . 'include/meta-boxes/meta-boxes.php' );