<?php
/**
 * Template Name: OTP Verification
 *
 * @since      4.3.7
 *
 * @subpackage common
 * @package    realhomes
 */

if ( isset( $_POST['ere_social_verify_otp'] ) ) {
	ere_verify_social_otp();
}

get_header();

// Getting current server/user details
$user_id            = isset( $_GET['user_id'] ) ? absint( $_GET['user_id'] ) : 0;
$user_ip            = $_SERVER['REMOTE_ADDR'];
$attempt_key        = 'ere_otp_attempts_' . md5( $user_ip );
$attempts           = (int)get_transient( $attempt_key );
$max_attempts       = get_option( 'ere_otp_max_login_attempts', 5 );
$remaining_attempts = max( 0, $max_attempts - $attempts );

// Get current time
$otp_expiry = $user_id ? get_user_meta( $user_id, 'ere_social_otp_expiry', true ) : 0;

// Calculate remaining time in seconds
$remaining_time = max( 0, (int)$otp_expiry - time() );
?>
    <div class="otp-container">
        <div id="otp-message-container"></div>
        <div class="otp-box">
            <div class="logo-container">
				<?php
				$logo_path        = get_option( 'theme_sitelogo' );
				$retina_logo_path = get_option( 'theme_sitelogo_retina' );
				if ( ! empty( $logo_path ) || ! empty( $retina_logo_path ) ) {
					?>
                    <a class="site-logo" title="<?php bloginfo( 'name' ); ?>" href="<?php echo esc_url( home_url() ); ?>">
						<?php inspiry_logo_img( $logo_path, $retina_logo_path ); ?>
                    </a>
					<?php
				} else {
					?>
                    <h2 class="rh_logo__heading">
                        <a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo( 'name' ); ?>">
							<?php bloginfo( 'name' ); ?>
                        </a>
                    </h2>
					<?php
				}
				?>
            </div>

			<?php
			if ( empty( $user_id ) ) {
				?>
                <p><?php esc_html_e( 'You are at the wrong place!', RH_TEXT_DOMAIN ); ?> <a href="<?php echo home_url( '' ); ?>"><?php esc_html_e( 'Go Back', RH_TEXT_DOMAIN ); ?></a></p>
				<?php
			} else if ( 1 > intval( $remaining_attempts ) ) {
				?>
                <p><?php esc_html_e( 'You are out of attempts. Try in almost six hours.', RH_TEXT_DOMAIN ); ?> <a href="<?php echo home_url( '' ); ?>"><?php esc_html_e( 'Go Back', RH_TEXT_DOMAIN ); ?></a></p>
				<?php
			} else if ( 1 > $remaining_time ) {
				?>
                <p><?php esc_html_e( 'The otp entry time is over. Try again!', RH_TEXT_DOMAIN ); ?> <a href="<?php echo home_url( '' ); ?>"><?php esc_html_e( 'Go Back', RH_TEXT_DOMAIN ); ?></a></p>
				<?php
			} else {
				?>
                <h2><?php esc_html_e( 'OTP Verification', RH_TEXT_DOMAIN ); ?></h2><p><?php esc_html_e( 'Please enter the OTP (One-Time Password) sent to your registered email/phone number to complete your verification.', RH_TEXT_DOMAIN ); ?></p>

				<?php
				if ( ere_is_social_login_enabled( 'facebook' ) || ere_is_social_login_enabled( 'google' ) || ere_is_social_login_enabled( 'twitter' ) ) {
					ere_show_otp_form();
				} else {
					?>
                    <p class="alert"><?php esc_html_e( 'Notice: Social login for any of the given services is not configured!', RH_TEXT_DOMAIN ); ?></p>
					<?php
				}
				?>
                <p class="otp-attempts">
					<?php
					esc_html_e( 'Remaining attempts from this IP: ', RH_TEXT_DOMAIN );
					echo '<span>' . esc_html( $remaining_attempts ) . '</span>';
					?>
                </p>
				<?php
			}
			?>
        </div>
    </div>
<?php
get_footer();